/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_circle.h"
#include "mainw.h"

struct circle_dialog
{
  GtkCheckButton*                       m_border_checkbutton;
  GtkComboBoxText*                      m_border_style_comboboxtext;
  GtkSpinButton*                        m_border_thickness_spinbutton;
  GtkEntry*                             m_border_color_entry;
  GtkButton*                            m_border_color_button;
  GtkCheckButton*                       m_fill_color_checkbutton;
  GtkEntry*                             m_fill_color_entry;
  GtkButton*                            m_fill_color_button; 
  GtkCheckButton*                       m_ellipse_checkbutton;
};

static void
item_circle_border_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct circle_dialog*                 l_circle;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_circle= (struct circle_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_circle).m_border_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_circle).m_border_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_circle_fill_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct circle_dialog*                 l_circle;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_circle= (struct circle_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_circle).m_border_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_circle).m_fill_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_circle_bind(
  struct circle_dialog*const            o_circle,
  GtkBuilder*const                      i_builder)
{

  memset(o_circle, 0, sizeof(*o_circle));

  do
  {

    (*o_circle).m_border_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "border_checkbutton"));

    (*o_circle).m_border_style_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "border_style_comboboxtext"));

    (*o_circle).m_border_thickness_spinbutton=
      GTK_SPIN_BUTTON(gtk_builder_get_object(i_builder, "border_thickness_spinbutton"));

    (*o_circle).m_border_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "border_color_entry"));

    (*o_circle).m_border_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "border_color_button"));

    g_signal_connect(
      (*o_circle).m_border_color_button,
      "clicked",
      G_CALLBACK(item_circle_border_color_button_cb),
      o_circle);

    (*o_circle).m_fill_color_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_checkbutton"));

    (*o_circle).m_fill_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_button"));

    g_signal_connect(
      (*o_circle).m_fill_color_button,
      "clicked",
      G_CALLBACK(item_circle_fill_color_button_cb),
      o_circle);

    (*o_circle).m_fill_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "fill_color_entry"));

    (*o_circle).m_ellipse_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "ellipse_checkbutton"));

  }while(0);

  return;
}

static void
item_circle_set_values(
  struct circle_dialog*const            i_circled,
  struct item_circle const*const        i_circle)
{
  gchar*                                l_color;

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_circled).m_border_checkbutton),
    (*i_circle).m_border);

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_circled).m_border_style_comboboxtext), 
      (*i_circle).m_border_style);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*i_circled).m_border_thickness_spinbutton),
    (*i_circle).m_border_thickness);

  l_color= gdk_rgba_to_string(&(*i_circle).m_border_color);
  gtk_entry_set_text((*i_circled).m_border_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_circled).m_fill_color_checkbutton),
    (*i_circle).m_fill);

  l_color= gdk_rgba_to_string(&(*i_circle).m_fill_color);
  gtk_entry_set_text((*i_circled).m_fill_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_circled).m_ellipse_checkbutton),
    (*i_circle).m_ellipse);

  return;
}

static void
item_circle_copy_values(
  struct item_circle *const             io_circle,
  struct circle_dialog const*const      i_circled)
{
  gchar const*                          l_text;
  gint                                  l_rc;

  (*io_circle).m_border=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_circled).m_border_checkbutton));

  l_rc = gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_circled).m_border_style_comboboxtext));

  if ((0 <= l_rc) && (LINE_STYLE_SLOTS > l_rc))
  {
    (*io_circle).m_border_style= (enum line_style_type)l_rc;
  }
  else
  {
    (*io_circle).m_border_style= line_style_solid;
  }

  (*io_circle).m_border_thickness= gtk_spin_button_get_value_as_int(
    GTK_SPIN_BUTTON((*i_circled).m_border_thickness_spinbutton));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_circled).m_border_color_entry));
  gdk_rgba_parse(&(*io_circle).m_border_color, l_text);

  (*io_circle).m_fill=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_circled).m_fill_color_checkbutton));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_circled).m_fill_color_entry));
  gdk_rgba_parse(&(*io_circle).m_fill_color, l_text);

  (*io_circle).m_ellipse=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_circled).m_ellipse_checkbutton));

  return;
}

extern int
item_circle_property(
  struct item_circle*const              io_circle)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GtkGrid*                              l_grid;
  GError*                               l_error;
  int                                   l_exit;
  struct circle_dialog                  l_circle;
  int                                   l_rc;

  l_builder= 0;
  l_grid= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "circle.glade", &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_grid= GTK_GRID(gtk_builder_get_object(l_builder, "circle_grid"));

    if (0 == l_grid)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'circle_grid'");
      l_exit= -1;
      break;
    }

    item_circle_bind(&l_circle, l_builder);

    item_circle_set_values(&l_circle, io_circle);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Circle Edit",
      mainw(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_grid), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_grid));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_circle_copy_values(io_circle, &l_circle);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_grid)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return l_exit;
}
