/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_circle.h"

extern void
item_circle_assign(
  struct item_circle*const              o_circle,
  struct item_method*const              o_method)
{

  memset(o_circle, 0, sizeof(*o_circle));

  (*o_circle).m_len_x= 30.0;
  (*o_circle).m_len_y= 30.0;
  (*o_circle).m_border= 1;
  (*o_circle).m_border_style= line_style_solid;
  (*o_circle).m_border_thickness= 1.0;

  ITEM_METHOD_ASSIGN(o_method, circle);

  return;
}

extern void
item_circle_discharge(
  struct item_circle*const              io_circle)
{

  memset(io_circle, 0, sizeof(*io_circle));

  return;
}

extern void
item_circle_draw(
  struct item_circle*const              i_circle,
  struct item_draw_context const*const  i_ctx)
{

  do
  {

    if ((*i_circle).m_fill)
    {
      cairo_save((*i_ctx).m_cr);

      cairo_set_source_rgb(
        (*i_ctx).m_cr,
        (*i_circle).m_fill_color.red,
        (*i_circle).m_fill_color.green,
        (*i_circle).m_fill_color.blue);

      cairo_translate(
        (*i_ctx).m_cr,
        (*i_circle).m_center_x,
        (*i_circle).m_center_y);

      cairo_scale(
        (*i_ctx).m_cr,
        ((*i_circle).m_len_x/2),
        ((*i_circle).m_len_y/2));

      cairo_arc((*i_ctx).m_cr, 0.0, 0.0, 1.0, 0.0, 2*G_PI);
      cairo_fill((*i_ctx).m_cr);
      cairo_restore((*i_ctx).m_cr);
    }

    if ((*i_circle).m_border)
    {
      cairo_save((*i_ctx).m_cr);

      cairo_translate(
        (*i_ctx).m_cr,
        (*i_circle).m_center_x,
        (*i_circle).m_center_y);

      cairo_scale(
        (*i_ctx).m_cr,
        ((*i_circle).m_len_x/2),
        ((*i_circle).m_len_y/2));

      cairo_arc((*i_ctx).m_cr, 0.0, 0.0, 1.0, 0.0, 2*G_PI);
      cairo_restore((*i_ctx).m_cr);

      cairo_set_source_rgb(
        (*i_ctx).m_cr,
        (*i_circle).m_border_color.red,
        (*i_circle).m_border_color.green,
        (*i_circle).m_border_color.blue);

      item_common_cairo_dash_set((*i_ctx).m_cr, (*i_circle).m_border_style);
      cairo_set_line_width((*i_ctx).m_cr, (*i_circle).m_border_thickness);
      cairo_stroke((*i_ctx).m_cr);
    }

    if (0 == (*i_ctx).m_selected)
    {
      if ((*i_ctx).m_option.m_highlight &&
        (item_draw_design == (*i_ctx).m_option.m_type))
      {
        cairo_save((*i_ctx).m_cr);
        cairo_translate(
          (*i_ctx).m_cr,
          (*i_circle).m_center_x,
          (*i_circle).m_center_y);
        cairo_scale(
          (*i_ctx).m_cr,
          ((*i_circle).m_len_x/2),
          ((*i_circle).m_len_y/2));
        cairo_arc((*i_ctx).m_cr, 0.0, 0.0, 1.0, 0.0, 2*G_PI);
        cairo_restore((*i_ctx).m_cr);
        cairo_set_source_rgb((*i_ctx).m_cr, 0.50, 0.50, 0.00);
        item_common_cairo_dash_set((*i_ctx).m_cr, (*i_circle).m_border_style);
        cairo_set_line_width((*i_ctx).m_cr, (*i_circle).m_border_thickness);
        cairo_stroke((*i_ctx).m_cr);
      }
      break;
    }

    item_common_circle_draw_grips((*i_ctx).m_cr, (struct geom_ellipse*)i_circle);

  }while(0);

  return;
}

extern void
item_circle_get_bbox(
  struct geom_rect*const                o_bbox,
  int*const                             o_overlay,
  void const*const                      i_object)
{
  (*o_overlay)= 0;
  return;
}

extern void
item_circle_in_event(
  enum event_type*const                 o_type,
  struct item_circle const*const        i_circle,
  struct item_in_event const*const      i_ctx)
{

  item_common_circle_in_event(o_type, i_ctx, (struct geom_ellipse*)i_circle);

  return;
}

extern void
item_circle_move(
  struct item_circle*const              io_circle,
  struct geom_point const*const         i_event)
{

  item_common_circle_move((struct geom_ellipse*)io_circle, i_event);

  return;
}

extern void
item_circle_normalize(
  struct item_circle*const              io_circle,
  double const                          i_bound_width,
  double const                          i_bound_height)
{

  if (0 > (*io_circle).m_len_x)
  {
    (*io_circle).m_len_x*= -1.0;
  }

  if (0 > (*io_circle).m_len_y)
  {
    (*io_circle).m_len_y*= -1.0;
  }

  return;
}

extern int
item_circle_read(
  GError**                              o_error,
  struct item_circle*const              io_circle,
  struct bson_node *const               i_element)
{
  struct bson_node *                    l_element;
  int                                   l_found;
  enum element_tag_type                 l_type;

  l_element= i_element;

  do
  {

    if (0 == l_element)
    {
      break;
    }

    if (bson_type_end == (*l_element).m_type)
    {
      break;
    }

    item_common_lookup(&l_found, &l_type, (*l_element).m_ename);

    if (l_found)
    {
        switch(l_type)
        {
          case element_tag_border:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_circle).m_border= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_border_color_red:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_border_color.red= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_color_green:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_border_color.green= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_color_blue:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_border_color.blue= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_thickness:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_border_thickness= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_style:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_circle).m_border_style= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_center_x:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_center_x= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_center_y:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_center_y= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_fill:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_circle).m_fill= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_fill_color_red:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_fill_color.red= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_fill_color_green:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_fill_color.green= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_fill_color_blue:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_fill_color.blue= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_len_x:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_len_x= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_len_y:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_circle).m_len_y= (*l_element).m_object.m_float;
            }
            break;
          default:
            break;
        }
    }

    l_element= (*l_element).m_next;

  }while(1);

  return 0;
}

extern void
item_circle_resize(
  struct item_circle*const              io_circle,
  struct item_resize_event const*const  i_ctx)
{

  item_common_circle_resize(
    (struct geom_ellipse*)io_circle, 
    i_ctx, 
    (*io_circle).m_ellipse);

  return;
}

extern int
item_circle_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_circle const*const        i_circle)
{
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;

  l_exit= 0;

  /* array */
  l_octet= bson_type_array;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "circle%c",0);

  /* document */
  l_offset= ftell(io_fp);
  l_int32= 0;
  fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 

  /* center_x */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "center_x%c",0);
  fwrite(&(*i_circle).m_center_x, sizeof(double), 1, io_fp);

  /* center_y */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "center_y%c",0);
  fwrite(&(*i_circle).m_center_y, sizeof(double), 1, io_fp);

  /* len_x */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "len_x%c",0);
  fwrite(&(*i_circle).m_len_x, sizeof(double), 1, io_fp);

  /* len_y */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "len_y%c",0);
  fwrite(&(*i_circle).m_len_y, sizeof(double), 1, io_fp);

  /* border */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border%c",0);
  fwrite(&(*i_circle).m_border, sizeof(int32_t), 1, io_fp);

  /* border_style */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_style%c",0);
  fwrite(&(*i_circle).m_border_style, sizeof(int32_t), 1, io_fp);

  /* border_thickness */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_thickness%c",0);
  fwrite(&(*i_circle).m_border_thickness, sizeof(double), 1, io_fp);

  /* border_color - red */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_red%c",0);
  fwrite(&(*i_circle).m_border_color.red, sizeof(double), 1, io_fp);

  /* border_color - green */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_green%c",0);
  fwrite(&(*i_circle).m_border_color.green, sizeof(double), 1, io_fp);

  /* border_color - blue */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_blue%c",0);
  fwrite(&(*i_circle).m_border_color.blue, sizeof(double), 1, io_fp);

  /* fill */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill%c",0);
  fwrite(&(*i_circle).m_fill, sizeof(int32_t), 1, io_fp);

  /* fill color - red */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill_red%c",0);
  fwrite(&(*i_circle).m_fill_color.red, sizeof(double), 1, io_fp);

  /* fill color - green */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill_green%c",0);
  fwrite(&(*i_circle).m_fill_color.green, sizeof(double), 1, io_fp);

  /* fill color - blue */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill_blue%c",0);
  fwrite(&(*i_circle).m_fill_color.blue, sizeof(double), 1, io_fp);

  /* end of document */
  l_octet= 0;
  fwrite(&l_octet, 1, 1, io_fp); 

  /* document */
  l_int32= ftell(io_fp);
  l_size= (l_int32 - l_offset);
  fseek(io_fp, l_offset, SEEK_SET);
  fwrite(&l_size, sizeof(l_size), 1, io_fp); 

  fseek(io_fp, 0, SEEK_END);

  return l_exit;
}
