/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "unicode/calendar.h"
#include "unicode/datefmt.h"
#include <unicode/dcfmtsym.h>
#include <unicode/decimfmt.h>
#include <unicode/fmtable.h>
#include <unicode/locid.h>
#include <unicode/numfmt.h>
#include <unicode/rbnf.h>
#include <unicode/uclean.h>
#include <unicode/unistr.h>
#include <unicode/ustring.h>
#include <unicode/utypes.h>
#include <string>
#include "icu.h"

static DateFormat::EStyle
get_style(
  enum date_style const                i_format)
{
  DateFormat::EStyle                    l_style= DateFormat::kFull;

  switch(i_format)
  {
  case date_style_none:
    l_style= DateFormat::kNone;
    break;
  case date_style_short:
    l_style= DateFormat::kShort;
    break;
  case date_style_medium:
    l_style= DateFormat::kMedium;
    break;
  case date_style_long:
    l_style= DateFormat::kLong;
    break;
  case date_style_full:
    l_style= DateFormat::kFull;
    break;
  default:
    l_style= DateFormat::kDefault;
    break;
  }

  return l_style;
}

extern "C" int
icu_date_to_textual(
  char**                                o_text,
  time_t const                          i_time,
  enum date_style const                 i_date_style,
  enum date_style const                 i_time_style,
  char const*                           i_locale,
  char const*                           i_timezone)
{
  Calendar*                             l_cal= 0;
  DateFormat*                           l_date_fmt= 0;
  UDate                                 l_date= static_cast<UDate>(1000*i_time);
  DateFormat::EStyle                    l_date_style= get_style(i_date_style);
  int                                   l_exit= 0;
  char const*                           l_locale_tmp= 0;
  size_t                                l_size= 0;
  UErrorCode                            l_status = U_ZERO_ERROR;
  std::string                           l_str;
  DateFormat::EStyle                    l_time_style= get_style(i_time_style);
  TimeZone*                             l_tz= 0;
  char const*                           l_tz_temp= 0;
  UnicodeString                         l_unistr;

  (*o_text)= 0;

  if (i_locale && i_locale[0])
  {
    l_locale_tmp= i_locale; 
  }
  else
  {
    l_locale_tmp= setlocale(LC_ALL, 0);
  }

  if (i_timezone && i_timezone[0])
  {
    l_tz_temp= i_timezone;
  }
  else
  {
    l_tz_temp= setlocale(LC_TIME, 0);
  }

  l_tz= TimeZone::createTimeZone(l_tz_temp);

  l_status= U_ZERO_ERROR;
  l_cal= Calendar::createInstance(l_status);
  (*l_cal).adoptTimeZone(l_tz);
  (*l_cal).clear();
  (*l_cal).setTime(l_date, l_status);
  l_date= (*l_cal).getTime(l_status);

  l_date_fmt= DateFormat::createDateTimeInstance(
    l_date_style,
    l_time_style,
    l_locale_tmp);

  (*l_date_fmt).setCalendar((*l_cal));

  l_unistr.remove();
  l_status= U_ZERO_ERROR;
  (*l_date_fmt).format(l_date, l_unistr, l_status);
  l_unistr.toUTF8String(l_str);

  l_size= l_str.length();
  (*o_text)= (char*)malloc(1+l_size);
  memset((*o_text), 0, 1+l_size);
  memcpy((*o_text), l_str.c_str(), l_size);

  delete l_cal;
  delete l_date_fmt;

  return l_exit;
}
