/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "global_common.h"

extern void
utf8_scrub_kludge(
  char*                                 io_buf)
{
  gboolean                              l_bool;
  gchar*                                l_head;
  gchar const*                          l_end;

  l_head= io_buf;

  do
  {

    l_bool= g_utf8_validate(l_head, -1, &l_end);

    if (l_bool)
    {
      break;
    }

    l_head= (gchar*)l_end;

    (*l_head)= '?';

  }while(1);

  return;
}

#ifndef G_OS_WIN32

/* _mjo TODO: BSD systems G_OS_UNIX
  On NetBSD for example, when packaged this might be '/usr/pkg/share/iwrite/ui'
*/
static char const* g_glade_data_dir= "/usr/share/iwrite/ui/";

extern guint
wrap_gtk_builder_add_from_file(
  GtkBuilder *                          builder,
  const gchar *                         filename,
  GError **                             error)
{
  GError*                               l_error;
  guint                                 l_exit;
  char*                                 l_src;
  size_t                                l_size;

  l_error= 0;

  do
  {

    l_exit= g_file_test(filename, G_FILE_TEST_EXISTS);

    if (l_exit)
    {
      l_exit= gtk_builder_add_from_file(builder, filename, &l_error);

      if (l_exit)
      {
        break;
      }
      _error_log(l_error);
      g_clear_error(&l_error);
    }

    l_size= strlen(filename);
    l_size+= strlen(g_glade_data_dir);
    l_size+= 3;
    l_src= (char*)g_malloc0(l_size);
    sprintf(l_src, "%s%c%s", g_glade_data_dir, G_DIR_SEPARATOR, filename);

    l_exit= gtk_builder_add_from_file(builder, l_src, &l_error);

    if (l_exit)
    {
      break;
    }

    g_free(l_src);

  }while(0);

  if (l_error)
  {
    _error_log(l_error);
    g_propagate_error(error, l_error);
  }

  return l_exit;
}

/* !G_OS_WIN32 */
#endif 
