/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "export.h"

/*
static GtkTargetEntry                 g_targets[1]=
{
  {"text/plain", 0, 0}
};
*/

enum
{
  COL_ATTRIBUTE=0,
  NUM_COLS
};

static int
tree_attr_has_entry(
  GtkTreeView*                          i_tree_attr,
  char const*                           i_attr)
{
  gboolean                              l_bool;
  int                                   l_exit;
  GtkTreeIter                           l_iter;
  GtkTreeModel*                         l_model;
  int                                   l_rc;
  gchar*                                l_value;

  memset(&l_iter, 0, sizeof(l_iter));
  l_model= gtk_tree_view_get_model(i_tree_attr);
  l_exit= 0;
  l_bool= gtk_tree_model_get_iter_first(l_model, &l_iter);

  do
  {

    if (0 == l_bool)
    {
      break;
    }

    gtk_tree_model_get(l_model, &l_iter, 0, &l_value, -1);
    l_rc= strcmp(i_attr, l_value);
    g_free(l_value);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }

    l_bool= gtk_tree_model_iter_next(l_model, &l_iter);

  }while(1);

  return l_exit;
}

static void
add_button_cb(
  GtkButton*                            i_button,
  gpointer                              i_user_data)
{
  gboolean                              l_bool;
  struct exports*                       l_export;
  GtkTreeIter                           l_iter;
  GtkTreeIter                           l_iter_child;
  GtkTreeIter                           l_iter_parent;
  int                                   l_len;
  GtkTreeModel*                         l_model;
  int                                   l_rc;
  GtkTreeSelection*                     l_selection;
  gchar*                                l_value;
  gchar*                                l_value_child;
  gchar*                                l_value_parent;
  GtkListStore*                         l_store;

  l_export= (struct exports*)i_user_data;
  memset(&l_iter, 0, sizeof(l_iter));
  memset(&l_iter_child, 0, sizeof(l_iter_child));
  memset(&l_iter_parent, 0, sizeof(l_iter_parent));
  l_value= 0;
  l_value_child= 0;
  l_value_parent= 0;

  do
  {

    l_selection= gtk_tree_view_get_selection((*l_export).m_tree_db);
    l_bool= gtk_tree_selection_get_selected(
      l_selection, 
      &l_model, 
      &l_iter_child);

    if (0 == l_bool)
    {
      break;
    }

    l_bool= gtk_tree_model_iter_parent(l_model, &l_iter_parent, &l_iter_child);

    if (0 == l_bool)
    {
      break;
    }

    gtk_tree_model_get(l_model, &l_iter_parent, 0, &l_value_parent, -1);
    gtk_tree_model_get(l_model, &l_iter_child, 0, &l_value_child, -1);

    l_rc= strcmp("primary", l_value_parent);

    if (0 == l_rc)
    {
      l_len= strlen(l_value_child);
      l_value= g_malloc0(1+l_len);
      memcpy(l_value, l_value_child, l_len);
    }
    else
    {
      l_len= strlen(l_value_parent);
      l_len+= strlen(l_value_child);
      l_value= g_malloc0(2+l_len);
      sprintf(l_value, "%s.%s", l_value_parent, l_value_child);
    }

    l_rc= tree_attr_has_entry((*l_export).m_tree_attr, l_value);

    if (l_rc)
    {
      break;
    }

    l_store= GTK_LIST_STORE(gtk_tree_view_get_model((*l_export).m_tree_attr));
    gtk_list_store_append(l_store, &l_iter);
    gtk_list_store_set(l_store, &l_iter, 0, l_value, -1);

  }while(0);

  g_free(l_value_parent);
  g_free(l_value_child);
  g_free(l_value);

  return;
}

static void
add_all_button_cb(
  GtkButton*                            i_button,
  gpointer                              i_user_data)
{
  gboolean                              l_bool;
  struct exports*                       l_export;
  GtkTreeIter                           l_iter;
  GtkTreeIter                           l_iter_child;
  GtkTreeIter                           l_iter_parent;
  gint                                  l_len;
  GtkTreeModel*                         l_model;
  int                                   l_rc;
  GtkListStore*                         l_store;
  gchar*                                l_value;
  gchar*                                l_value_child;
  gchar*                                l_value_parent;

  l_export= (struct exports*)i_user_data;
  memset(&l_iter_parent, 0, sizeof(l_iter_parent));
  memset(&l_iter_child, 0, sizeof(l_iter_child));
  l_value= 0;
  l_value_child= 0;
  l_value_parent= 0;
  l_model= gtk_tree_view_get_model((*l_export).m_tree_attr);
  l_store= GTK_LIST_STORE(l_model);
  l_model= gtk_tree_view_get_model((*l_export).m_tree_db);
  l_bool= gtk_tree_model_get_iter_first(l_model, &l_iter_parent);

  do
  {
  
    if (0 == l_bool)
    {
      break;
    }

    gtk_tree_model_get(l_model, &l_iter_parent, 0, &l_value_parent, -1);
    l_bool= gtk_tree_model_iter_children(l_model, &l_iter_child, &l_iter_parent);

    do
    {

      if (0 == l_bool)
      {
        break;
      }

      gtk_tree_model_get(l_model, &l_iter_child, 0, &l_value_child, -1);

      l_rc= strcmp("primary", l_value_parent);

      if (0 == l_rc)
      {
        l_len= strlen(l_value_child);
        l_value= g_malloc0(1+l_len);
        memcpy(l_value, l_value_child, l_len);
      }
      else
      {
        l_len= strlen(l_value_parent);
        l_len+= strlen(l_value_child);
        l_value= g_malloc0(2+l_len);
        sprintf(l_value, "%s.%s", l_value_parent, l_value_child);
      }

      l_rc= tree_attr_has_entry((*l_export).m_tree_attr, l_value);
    
      if (0 == l_rc)
      {
        gtk_list_store_append(l_store, &l_iter);
        gtk_list_store_set(l_store, &l_iter, 0, l_value, -1);
      }

      g_free(l_value);
      l_value= 0;
      g_free(l_value_child);
      l_value_child= 0;

      l_bool= gtk_tree_model_iter_next(l_model, &l_iter_child);

    }while(1);

    g_free(l_value_parent); 
    l_value_parent= 0;
    l_bool= gtk_tree_model_iter_next(l_model, &l_iter_parent);

  }while(0);

  return;
}

static void
remove_button_cb(
  GtkButton*                            i_button,
  gpointer                              i_user_data)
{
  struct exports*                       l_export;
  GtkTreeSelection*                     l_selection;
  GtkTreeModel*                         l_model;
  GtkTreeIter                           l_iter;
  gboolean                              l_bool;
  GtkListStore*                         l_store;

  l_export= (struct exports*)i_user_data;
  l_model= gtk_tree_view_get_model((*l_export).m_tree_attr);
  l_store= GTK_LIST_STORE(l_model);

  do
  {

    l_selection= gtk_tree_view_get_selection((*l_export).m_tree_attr);
    l_bool= gtk_tree_selection_get_selected(
      l_selection, 
      &l_model, 
      &l_iter);

    if (0 == l_bool)
    {
      break;
    }

    gtk_list_store_remove(l_store, &l_iter);

  }while(0);

  return;
}

static void
remove_all_button_cb(
  GtkButton*                            i_button,
  gpointer                              i_user_data)
{
  struct exports*                       l_export;
  GtkTreeModel*                         l_model;

  l_export= (struct exports*)i_user_data;
  l_model= gtk_tree_view_get_model((*l_export).m_tree_attr);
  gtk_list_store_clear(GTK_LIST_STORE(l_model));

  return;
}

static void
export_bind(
  struct exports *const                 io_export,
  GtkBuilder*const                      i_builder)
{
  GtkButton*                            l_button;

  l_button= GTK_BUTTON(
    gtk_builder_get_object(i_builder, "add_button"));

  g_signal_connect(
    l_button,
    "clicked",
    G_CALLBACK(add_button_cb),
    io_export);

  l_button= GTK_BUTTON(
    gtk_builder_get_object(i_builder, "add_all_button"));

  g_signal_connect(
    l_button,
    "clicked",
    G_CALLBACK(add_all_button_cb),
    io_export);

  l_button= GTK_BUTTON(
    gtk_builder_get_object(i_builder, "remove_button"));

  g_signal_connect(
    l_button,
    "clicked",
    G_CALLBACK(remove_button_cb),
    io_export);

  l_button= GTK_BUTTON(
    gtk_builder_get_object(i_builder, "remove_all_button"));

  g_signal_connect(
    l_button,
    "clicked",
    G_CALLBACK(remove_all_button_cb),
    io_export);

  return;
}

static void
export_create_attr_tree(
  GtkTreeView**                         o_tree)
{
  GtkCellRenderer *                     l_renderer;
  GtkListStore*                         l_store;
  GtkTreeView *                         l_tree;

  l_tree= GTK_TREE_VIEW(gtk_tree_view_new());
  gtk_widget_set_hexpand(GTK_WIDGET(l_tree), 1);
  gtk_widget_set_vexpand(GTK_WIDGET(l_tree), 1);
  gtk_tree_view_set_headers_visible(l_tree, 1);
  gtk_tree_view_set_reorderable(l_tree, 1);

/*
  gtk_tree_view_enable_model_drag_dest(
    l_tree,
    g_targets,
    1,
    GDK_ACTION_DEFAULT);
*/

  l_renderer= gtk_cell_renderer_text_new();

  gtk_tree_view_insert_column_with_attributes(
    l_tree,
    -1,
    "Attribute",
    l_renderer,
    "text", 
    0,
    NULL);

  l_store= gtk_list_store_new(NUM_COLS, G_TYPE_STRING);
  gtk_tree_view_set_model(l_tree, GTK_TREE_MODEL(l_store));
  g_object_unref(l_store);

  (*o_tree)= l_tree;
}

static void
export_create_db_tree(
  GtkTreeView**                         o_tree)
{
  GtkCellRenderer *                     l_renderer;
  GtkTreeStore*                         l_store;
  GtkTreeView *                         l_tree;

  l_tree= GTK_TREE_VIEW(gtk_tree_view_new());
  gtk_widget_set_hexpand(GTK_WIDGET(l_tree), 1);
  gtk_widget_set_vexpand(GTK_WIDGET(l_tree), 1);
  gtk_tree_view_set_headers_visible(l_tree, 1);
  gtk_tree_view_set_reorderable(l_tree, 0);

/*
  gtk_tree_view_enable_model_drag_source(
    l_tree,
    GDK_BUTTON1_MASK,
    g_targets,
    1,
    GDK_ACTION_COPY);
*/

  l_renderer= gtk_cell_renderer_text_new();

  gtk_tree_view_insert_column_with_attributes(
    l_tree,
    -1,
    "Attribute",
    l_renderer,
    "text", 
    0,
    NULL);

  l_store= gtk_tree_store_new(NUM_COLS, G_TYPE_STRING);
  gtk_tree_view_set_model(l_tree, GTK_TREE_MODEL(l_store));
  g_object_unref(l_store);

  (*o_tree)= l_tree;

  return;
}

extern void
export_assign(
  struct exports*const                  o_export)
{

  memset(o_export, 0, sizeof(*o_export));
  export_config_assign(&(*o_export).m_config);

  return;
}

extern void
export_assign_filename(
  struct exports*const                  io_export,
  char const*                           i_reportfile)
{

  export_config_assign_filename(&(*io_export).m_config, i_reportfile);

  return;
}

extern void
export_discharge(
  struct exports *const                 io_export)
{

  export_config_discharge(&(*io_export).m_config);

  if ((*io_export).m_grid)
  {
    gtk_widget_destroy(GTK_WIDGET((*io_export).m_grid));
  }

  memset(io_export, 0, sizeof(*io_export));

  return;
}

static void
export_read_array(
  struct exports *const                 io_export,
  struct bson_node const*               i_element)
{
  struct bson_node const*               l_element;
  GtkTreeIter                           l_iter;
  GtkListStore*                         l_store;

  l_element= i_element;
  memset(&l_iter, 0, sizeof(l_iter));
  l_store= GTK_LIST_STORE(gtk_tree_view_get_model((*io_export).m_tree_attr));

  do
  {

    if (0 == l_element)
    {
      break;
    }

    if (bson_type_end == (*l_element).m_type)
    {
      break;
    }

    if (bson_type_string == (*l_element).m_type)
    {
      gtk_list_store_append(l_store, &l_iter);
      gtk_list_store_set(
        l_store, 
        &l_iter,
        0, 
        (*l_element).m_object.m_string.m_text, 
        -1);
    }

    l_element= (*l_element).m_next;

  }while(1);

  return;
}

extern GtkWidget*
export_gui_new(
  struct exports *const                 io_export)
{
  GtkBuilder*                           l_builder;
  GError*                               l_error;
  int                                   l_rc;
  GtkScrolledWindow*                    l_swleft;
  GtkScrolledWindow*                    l_swright;

  l_builder= 0;
  l_error= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "export.glade", &l_error);

    if (0 == l_rc)
    {
      _error_log(l_error);
      g_warning("Unable to build dialog: %s\n", l_error->message);
      break;
    }

    (*io_export).m_grid= GTK_GRID(gtk_builder_get_object(l_builder, "grid1"));

    if (0 == (*io_export).m_grid)
    {
      g_warning("Unable to find grid object: 'grid1'");
      break;
    }

    g_object_ref((*io_export).m_grid);

    export_bind(io_export, l_builder);

    l_swleft= GTK_SCROLLED_WINDOW(gtk_builder_get_object(l_builder, "scrolledwindow1"));
    export_create_db_tree(&(*io_export).m_tree_db);
    gtk_container_add(GTK_CONTAINER(l_swleft), GTK_WIDGET((*io_export).m_tree_db));

    l_swright= GTK_SCROLLED_WINDOW(gtk_builder_get_object(l_builder, "scrolledwindow2"));
    export_create_attr_tree(&(*io_export).m_tree_attr);
    gtk_container_add(GTK_CONTAINER(l_swright), GTK_WIDGET((*io_export).m_tree_attr));

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  g_clear_error(&l_error);

  return GTK_WIDGET((*io_export).m_grid);
}

extern int
export_read(
  GError**                              o_error,
  struct exports *const                 io_export,
  struct bson_node const*const          i_element)
{
  struct bson_node const*               l_bson;
  struct bson_node const*               l_bson_array;
  int                                   l_exit;
  int                                   l_rc;

  do
  {

    l_exit= export_config_read(o_error, &(*io_export).m_config);

    if (l_exit)
    {
      break;
    }

    l_bson= i_element;

    do
    {

      if (0 == l_bson)
      {
        break;
      }

      do
      {

        if (bson_type_array != (*l_bson).m_type)
        {
          break;
        }

        l_bson_array= (*l_bson).m_object.m_document.m_head;

        if (0 == l_bson_array)
        {
          break;
        }

        l_rc= strcmp("attribute", (*l_bson).m_ename);

        if (l_rc)
        {
          break;
        }

        export_read_array(io_export, l_bson_array);

      }while(0);

      if (l_exit)
      {
        break;
      }

      l_bson= (*l_bson).m_next;

    }while(1);

  }while(0);

  return 0;
}

extern void
export_reload(
  struct exports *const                 io_export,
  struct database_aspect *const         io_aspect,
  struct query const*const              i_query)
{
  unsigned                              l_attr_slot;
  GtkTreeIter                           l_child;
  GtkTreeIter                           l_parent;
  unsigned                              l_slot;
  GtkTreeModel*                         l_model;
  GtkTreeStore*                         l_store;

  l_model= gtk_tree_view_get_model((*io_export).m_tree_db);
  l_store= GTK_TREE_STORE(l_model);
  gtk_tree_store_clear(l_store);
  memset(&l_parent, 0, sizeof(l_parent));
  memset(&l_child, 0, sizeof(l_child));

  do
  {

    if (0 == g_cache)
    {
      database_field_create_cache(io_aspect, i_query);
    }

    for (l_slot= 0; g_cache_slots > l_slot; l_slot++)
    {
      gtk_tree_store_append(l_store, &l_parent, 0);
      gtk_tree_store_set(
        l_store,
        &l_parent, 
        COL_ATTRIBUTE, 
        g_cache[l_slot].m_tag,
        -1);

      for (
        l_attr_slot= 0; 
        g_cache[l_slot].m_attr_slots > l_attr_slot; 
        l_attr_slot++)
      {
        gtk_tree_store_append(l_store, &l_child, &l_parent);
        gtk_tree_store_set(
          l_store, 
          &l_child,
          COL_ATTRIBUTE,
          g_cache[l_slot].m_attr[l_attr_slot].m_tag,
          -1);
      }

    }

  }while(0);

  return;
}

extern int
export_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct exports const*const            i_export)
{
  gboolean                              l_bool;
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;
  GtkTreeIter                           l_iter;
  gchar*                                l_value;
  GtkTreeModel*                         l_model;

  l_exit= 0;

  do
  {

    l_exit= export_config_write(o_error, &(*i_export).m_config);

    if (l_exit)
    {
      break;
    }

    l_octet= bson_type_array;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "%s%c", "attribute", 0);

    /* document */
    l_offset= ftell(io_fp);
    l_int32= 0;
    fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 

    l_model= gtk_tree_view_get_model((*i_export).m_tree_attr);
    l_bool= gtk_tree_model_get_iter_first(l_model, &l_iter);

    do
    {

      if (0 == l_bool)
      {
        break;
      }

      gtk_tree_model_get(l_model, &l_iter, 0, &l_value, -1);

      l_octet= bson_type_string;
      fwrite(&l_octet, 1, 1, io_fp); 
      fprintf(io_fp, "text%c",0);
      l_size= 1+strlen(l_value);
      fwrite(&l_size, sizeof(int32_t), 1, io_fp); 
      fwrite(l_value, 1, l_size, io_fp);
      g_free(l_value);

      l_bool= gtk_tree_model_iter_next(l_model, &l_iter);

    }while(1);

    /* end of document */
    l_octet= 0;
    fwrite(&l_octet, 1, 1, io_fp); 

    /* document */
    l_int32= ftell(io_fp);
    l_size= (l_int32 - l_offset);
    fseek(io_fp, l_offset, SEEK_SET);
    fwrite(&l_size, sizeof(l_size), 1, io_fp); 

    fseek(io_fp, 0, SEEK_END);

  }while(0);

  return l_exit;
}
