/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __error_h__

#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#include <stdio.h>
#include <string.h>

enum error_domain
{
  GENERAL                               = 1,    
  DRIVER_CONFIG                         = 1000,
  IWSQL_DLL                             = 2000,
  DATABASE_SESSION                      = 3000,
  QUERY_EXEC                            = 4000,
  QUERY                                 = 5000,
  REPORT                                = 6000,
  RW                                    = 7000,
  CSV                                   = 8000
};

enum error_code
{
  GENERIC                         = -1,
  NONE                            = 0,
  DRIVER_CONFIG_NOTFOUND          = DRIVER_CONFIG|1,
  DRIVER_CONFIG_EMPTY             = DRIVER_CONFIG|2,
  IWSQL_DLL_OPEN                  = IWSQL_DLL|1,
  IWSQL_DLL_LOAD                  = IWSQL_DLL|2,
  IWSQL_DLL_CONNECT               = IWSQL_DLL|3,
  IWSQL_DLL_EXEC                  = IWSQL_DLL|4,
  IWSQL_DLL_FETCH                 = IWSQL_DLL|5,
  DATABASE_SESSION_FILE_OPEN      = DATABASE_SESSION|1, 
  DATABASE_SESSION_DRIVER_NAME    = DATABASE_SESSION|2,
  DATABASE_SESSION_TABLE_NAME     = DATABASE_SESSION|3,
  DATABASE_SESSION_MODULE         = DATABASE_SESSION|4,
  QUERY_EXEC_FILE_CREATE1         = QUERY_EXEC|1,
  QUERY_EXEC_FILE_CREATE2         = QUERY_EXEC|2,
  QUERY_FILE_OPEN                 = QUERY|1,
  QUERY_FILE_CREATE               = QUERY|2,
  QUERY_SQL_PARSE                 = QUERY|3,
  REPORT_FILE_OPEN                = REPORT|1,
  REPORT_FILE_CREATE              = REPORT|2,
  REPORT_PARSE                    = REPORT|3,
  RW_CREATE_SURFACE               = RW|1,
  CSV_CREATE_FILE                 = CSV|1
};

extern void _error_log(GError*);

#define _error_log(e) fprintf(stderr, "%s.%d: [%d.%d]; %s\n",\
    __func__, __LINE__, (e)->domain, (e)->code, (e)->message)

extern void
_error_display_prompt(
  GError const*const                    i_error);

#define __error_h__
#endif
