/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __database_session_h__

#include "iwsql.h"
#include "iwsql_dll.h"
#include "driver_config.h"
#include "database_config.h"
#include "database_aspect.h"

struct database_session
{
  int                                   m_connected;
  struct iwsql_dll                      m_dll;
};

extern void
database_session_assign(
  struct database_session*const         o_session);

extern int
database_session_connect(
  GError**                              o_error,
  struct database_session*const         io_session,
  struct database_aspect const*const    i_aspect);

extern void
database_session_discharge(
  struct database_session*const         io_session);

extern int
database_session_exec(
  GError**                              o_error,
  struct database_session*const         io_session,
  char const*                           i_sqlfile);

extern int
database_session_exec_buffer(
  GError**                              o_error,
  struct database_session*const         io_session,
  char const*                           i_sql);

extern void
database_session_get_attributes(
  struct iwsql_attr const**             o_attr,
  unsigned*const                        o_slots,
  struct database_session const*const   i_session);

extern int
database_session_next(
  GError**                              o_error,
  int*const                             o_eof,
  struct database_session*const         io_session);

#define  __database_session_h__
#endif
