/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "database_field.h"

enum
{
  COL_ATTRIBUTE=0,
  NUM_COLS
};

static void
field_create_and_fill_model(
  GtkTreeModel**                        o_model,
  struct database_aspect *const         io_aspect,
  struct query const*const              i_query)
{
  unsigned                              l_attr_slot;
  GtkTreeIter                           l_child;
  GtkTreeIter                           l_parent;
  unsigned                              l_slot;
  GtkTreeStore*                         l_store;

  l_store= 0;
  (*o_model)= 0;
  memset(&l_parent, 0, sizeof(l_parent));
  memset(&l_child, 0, sizeof(l_child));

  do
  {

    if (0 == g_cache)
    {
      database_field_create_cache(io_aspect, i_query);
    }

    l_store= gtk_tree_store_new(NUM_COLS, G_TYPE_STRING);

    for (l_slot= 0; g_cache_slots > l_slot; l_slot++)
    {
      gtk_tree_store_append(l_store, &l_parent, 0);
      gtk_tree_store_set(
        l_store,
        &l_parent, 
        COL_ATTRIBUTE, 
        g_cache[l_slot].m_tag,
        -1);

      for (
        l_attr_slot= 0; 
        g_cache[l_slot].m_attr_slots > l_attr_slot; 
        l_attr_slot++)
      {
        gtk_tree_store_append(l_store, &l_child, &l_parent);
        gtk_tree_store_set(
          l_store, 
          &l_child,
          COL_ATTRIBUTE,
          g_cache[l_slot].m_attr[l_attr_slot].m_tag,
          -1);
      }

    }

  }while(0);

  (*o_model)= GTK_TREE_MODEL(l_store);

  return;
}

static void
field_create_new_tree_view(
  GtkTreeView**                         o_tree,
  struct database_aspect *const         io_aspect,
  struct query const*const              i_query)
{
  GtkTreeViewColumn *                   l_col;
  GtkTreeModel *                        l_model;
  GtkCellRenderer *                     l_renderer;
  GtkTreeView *                         l_view;

  l_view= GTK_TREE_VIEW(gtk_tree_view_new());

  l_col= gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(l_col, "Attribute");
  gtk_tree_view_append_column(l_view, l_col);

  l_renderer= gtk_cell_renderer_text_new();
  gtk_tree_view_column_pack_start(l_col, l_renderer, TRUE);
  gtk_tree_view_column_add_attribute(l_col, l_renderer, "text", 0);

  field_create_and_fill_model(&l_model, io_aspect, i_query);
  gtk_tree_view_set_model(l_view, l_model);
  g_object_unref(l_model);

  (*o_tree)= l_view;

  return;
}

extern void
field_get_selected(
  char**                                o_attribute,
  GtkTreeView*                          i_tree)
{
  gboolean                              l_bool;
  GtkTreeIter                           l_iter_child;
  GtkTreeIter                           l_iter_parent;
  int                                   l_len;
  GtkTreeModel*                         l_model;
  int                                   l_rc;
  GtkTreeSelection*                     l_selection;
  gchar*                                l_value;
  gchar*                                l_value_child;
  gchar*                                l_value_parent;

  (*o_attribute)= 0;
  l_value_child= 0;
  l_value_parent= 0;

  do
  {

    l_selection= gtk_tree_view_get_selection(i_tree);
    l_bool= gtk_tree_selection_get_selected(l_selection, &l_model, &l_iter_child);

    if (0 == l_bool)
    {
      break;
    }

    l_bool= gtk_tree_model_iter_parent(l_model, &l_iter_parent, &l_iter_child);

    if (0 == l_bool)
    {
      break;
    }

    gtk_tree_model_get(l_model, &l_iter_parent, 0, &l_value_parent, -1);
    gtk_tree_model_get(l_model, &l_iter_child, 0, &l_value_child, -1);

    l_rc= strcmp("primary", l_value_parent);

    if (0 == l_rc)
    {
      l_len= strlen(l_value_child);
      l_value= g_malloc0(1+l_len);
      memcpy(l_value, l_value_child, l_len);
    }
    else
    {
      l_len= strlen(l_value_parent);
      l_len+= strlen(l_value_child);
      l_value= g_malloc0(2+l_len);
      sprintf(l_value, "%s.%s", l_value_parent, l_value_child);
    }

    (*o_attribute)= l_value;
    g_free(l_value_parent);
    g_free(l_value_child);

  }while(0);

  return;
}

extern int
database_field_property(
  char**                                o_attribute,
  struct database_aspect *const         io_aspect,
  struct query const*const              i_query)
{
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_rc;
  GtkTreeView*                          l_tree;
  GtkViewport*                          l_viewport;

  (*o_attribute)= 0;
  l_builder= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(
      l_builder,
      "field.glade",
      &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_dialog= (GtkDialog*)gtk_builder_get_object(l_builder, "field_dialog");

    if (0 == l_dialog)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'field_dialog'");
      l_exit= -1;
      break;
    }

    l_viewport= GTK_VIEWPORT(gtk_builder_get_object(l_builder, "viewport1"));
    field_create_new_tree_view(&l_tree, io_aspect, i_query);
    gtk_container_add(GTK_CONTAINER(l_viewport), GTK_WIDGET(l_tree));

    gtk_window_set_transient_for(GTK_WINDOW(l_dialog), mainw());
    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    gtk_widget_grab_focus(gtk_dialog_get_widget_for_response(
      GTK_DIALOG(l_dialog), GTK_RESPONSE_OK));

    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_CANCEL == l_exit)
    {
      break;
    }

    field_get_selected(o_attribute, l_tree);
    l_exit= 0;

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  return l_exit;
}
