/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "database_field.h"

struct database_field_cache*            g_cache= 0;
unsigned                                g_cache_slots= 0;

extern void
database_field_destroy_cache()
{
  unsigned                             l_slot;
  unsigned                             l_attr_slot;

  for (l_slot= 0; g_cache_slots > l_slot; l_slot++)
  {

    g_free(g_cache[l_slot].m_tag);

    for (
      l_attr_slot= 0; 
      g_cache[l_slot].m_attr_slots > l_attr_slot; 
      l_attr_slot++)
    {
        g_free(g_cache[l_slot].m_attr[l_attr_slot].m_tag);
    }

    g_free(g_cache[l_slot].m_attr);
  }

  g_free(g_cache);
  g_cache= 0;
  g_cache_slots= 0;

  return;
}

extern void
database_field_create_cache(
  struct database_aspect *const         io_aspect,
  struct query const*const              i_query)
{
  unsigned                              l_attr_slot;
  int                                   l_cancel;
  GtkDialog*                            l_dialog;
  int                                   l_eof;
  GError*                               l_error;
  struct query_exec                     l_exec;
  enum error_code                       l_exit;
  unsigned                              l_slot;

  l_error= 0;
  query_exec_assign(&l_exec);
  database_field_destroy_cache();

  do
  {

    database_aspect_password_fill(&l_cancel, io_aspect);

    if (l_cancel)
    {
      break;
    }

    l_exit= query_exec_connect_prepare_first(
      &l_error,
      &l_eof,
      &l_exec,
      i_query,
      io_aspect,
      0,
      1);

    if (l_exit)
    {
      break;
    }

    g_cache_slots= l_exec.m_count;
    g_cache= (struct database_field_cache*)g_malloc0(
      sizeof(struct database_field_cache)*l_exec.m_count);

    for (l_slot= 0; l_exec.m_count > l_slot; l_slot++)
    {
        g_cache[l_slot].m_tag= 
          g_strdup(l_exec.m_sql[l_slot].m_query.m_tag);

        g_cache[l_slot].m_attr_slots= l_exec.m_sql[l_slot].m_attr_count;
        g_cache[l_slot].m_attr= g_malloc0(
          sizeof(struct iwsql_attr) * l_exec.m_sql[l_slot].m_attr_count);

      for (
        l_attr_slot= 0; 
        l_exec.m_sql[l_slot].m_attr_count > l_attr_slot; 
        l_attr_slot++)
      {
          g_cache[l_slot].m_attr[l_attr_slot]=
            l_exec.m_sql[l_slot].m_attr[l_attr_slot];
          g_cache[l_slot].m_attr[l_attr_slot].m_value= 0;
          g_cache[l_slot].m_attr[l_attr_slot].m_tag=
            g_strdup(l_exec.m_sql[l_slot].m_attr[l_attr_slot].m_tag);
      }
    }

  }while(0);

  if (l_error)
  {
    l_dialog= GTK_DIALOG(gtk_message_dialog_new(
      mainw(),
      GTK_DIALOG_MODAL,
      GTK_MESSAGE_ERROR,
      GTK_BUTTONS_CLOSE,
      (*l_error).message, 
      0));
    gtk_dialog_run(l_dialog);
    gtk_widget_destroy(GTK_WIDGET(l_dialog));
  }

  g_clear_error(&l_error);

  query_exec_discharge(&l_exec);

  return;
}
