/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "database_aspect.h"
#include "item_common.h"

extern void
database_aspect_assign(
  struct database_aspect *const         o_aspect)
{

  memset(o_aspect, 0, sizeof(*o_aspect));

  return;
}

extern void
database_aspect_clear(
  struct database_aspect *const         io_aspect)
{

  database_aspect_password_delete(io_aspect);
  memset(io_aspect, 0, sizeof(*io_aspect));

  return;
}

extern void
database_aspect_copy(
  struct database_aspect *const         o_aspect,
  struct database_aspect const*const    i_aspect)
{
   
  database_aspect_password_delete(o_aspect);
  memcpy(o_aspect, i_aspect, sizeof(*i_aspect));
  if ((*i_aspect).m_password)
  {
    (*o_aspect).m_password= g_strdup((*i_aspect).m_password);
  }

}

extern void
database_aspect_discharge(
  struct database_aspect *const         io_aspect)
{

  database_aspect_clear(io_aspect);

  return;
}

extern void
database_aspect_password_delete(
  struct database_aspect *const         io_aspect)
{

  do
  {

    if (0 == (*io_aspect).m_password) 
    {
      break;
    }

    g_free((*io_aspect).m_password);
    (*io_aspect).m_password= 0;

  }while(0);

  return;
}

extern void
database_aspect_password_fill(
  int*const                             o_cancel,
  struct database_aspect *const         io_aspect)
{

  (*o_cancel)= 0;

  do
  {

    if (0 == (*io_aspect).m_prompt_password)
    {
      break;
    }

    if (((*io_aspect).m_password) && (*io_aspect).m_password[0])
    {
      break;
    }

    if ((*io_aspect).m_password)
    {
      g_free((*io_aspect).m_password);
      (*io_aspect).m_password= 0;
    }

    database_aspect_password_prompt(o_cancel, &(*io_aspect).m_password);

  }while(0);

  return;
}

extern void
database_aspect_password_prompt(
  int*const                             o_cancel,
  char**                                o_password)
{
  GtkWidget*                            l_content;
  GtkDialog*                            l_dialog;
  GtkEntry*                             l_entry;
  int                                   l_rc;
  char const*                           l_text;

  (*o_cancel)= 0;
  (*o_password)= 0;

  l_dialog= GTK_DIALOG(gtk_message_dialog_new(
    mainw(),
    GTK_DIALOG_MODAL,
    GTK_MESSAGE_QUESTION,
    GTK_BUTTONS_OK_CANCEL,
    "Password"));

  gtk_dialog_set_default_response(l_dialog, GTK_RESPONSE_OK);
  gtk_widget_grab_focus(gtk_dialog_get_widget_for_response(
      GTK_DIALOG(l_dialog), GTK_RESPONSE_OK));
  gtk_window_set_title(GTK_WINDOW(l_dialog), "Database password");  

  l_entry= GTK_ENTRY(gtk_entry_new());
  gtk_entry_set_visibility(l_entry, 0);
  gtk_entry_set_invisible_char(l_entry, '*');

  l_content= gtk_dialog_get_content_area(l_dialog);
  gtk_container_add(GTK_CONTAINER(l_content), GTK_WIDGET(l_entry));
    
  gtk_widget_show_all(GTK_WIDGET(l_dialog));

  l_rc= gtk_dialog_run(l_dialog);

  if (l_rc == GTK_RESPONSE_OK)
  {
    l_text= gtk_entry_get_text(l_entry);
    if (l_text && l_text[0])
    {
      (*o_password)= g_strdup(l_text);
    }
  }
  else  
  {
    (*o_cancel)= 1;
  }

  gtk_widget_destroy(GTK_WIDGET(l_dialog));

  return;
}

extern int
database_aspect_attrs_read(
  struct database_aspect *const         io_aspect,
  struct bson_node *                    i_element)
{
  int                                   l_found;
  enum element_tag_type                 l_type;

  do
  {

    if (0 == i_element)
    {
      break;
    }

    if (bson_type_end == (*i_element).m_type)
    {
      break;
    }

    item_common_lookup(&l_found, &l_type, (*i_element).m_ename);

    if (l_found)
    {
        switch(l_type)
        {
          case element_tag_tag:
            if (bson_type_string == (*i_element).m_type)
            {
              strncpy(
                (*io_aspect).m_tag,
                (*i_element).m_object.m_string.m_text,
                sizeof((*io_aspect).m_tag));
            }
          case element_tag_driver:
            if (bson_type_string == (*i_element).m_type)
            {
              strncpy(
                (*io_aspect).m_driver,
                (*i_element).m_object.m_string.m_text,
                sizeof((*io_aspect).m_driver));
            }
          case element_tag_dbname:
            if (bson_type_string == (*i_element).m_type)
            {
              strncpy(
                (*io_aspect).m_dbname,
                (*i_element).m_object.m_string.m_text,
                sizeof((*io_aspect).m_dbname));
            }
            break;
          case element_tag_host:
            if (bson_type_string == (*i_element).m_type)
            {
              strncpy(
                (*io_aspect).m_host,
                (*i_element).m_object.m_string.m_text,
                sizeof((*io_aspect).m_host));
            }
            break;
          case element_tag_hostaddr:
            if (bson_type_string == (*i_element).m_type)
            {
              strncpy(
                (*io_aspect).m_hostaddr,
                (*i_element).m_object.m_string.m_text,
                sizeof((*io_aspect).m_hostaddr));
            }
            break;
          case element_tag_port:
            if (bson_type_string == (*i_element).m_type)
            {
              strncpy(
                (*io_aspect).m_port,
                (*i_element).m_object.m_string.m_text,
                sizeof((*io_aspect).m_port));
            }
            break;
          case element_tag_username:
            if (bson_type_string == (*i_element).m_type)
            {
              strncpy(
                (*io_aspect).m_username,
                (*i_element).m_object.m_string.m_text,
                sizeof((*io_aspect).m_username));
            }
            break;
          case element_tag_prompt_password:
            if (bson_type_int32 == (*i_element).m_type)
            {
              (*io_aspect).m_prompt_password= (*i_element).m_object.m_int32;
            }
          default:
            break;
        }
    }

    i_element= (*i_element).m_next;

  }while(1);

  return 0;
}

extern int
database_aspect_read(
  struct database_aspect *const         io_aspect,
  struct bson_node *                    i_element)
{
  ptrdiff_t                             l_exit;
  int                                   l_rc;

  l_exit= 0;

  do
  {

    if (0 == i_element)
    {
      break;
    }

    if (bson_type_end == (*i_element).m_type)
    {
      break;
    }

    l_rc= strcmp("database", (*i_element).m_ename);

    if (0 == l_rc)
    {
      if (bson_type_array == (*i_element).m_type)
      {
        l_exit= database_aspect_attrs_read(
          io_aspect,
          (*i_element).m_object.m_array.m_head);
      }
      break;
    }

    i_element= (*i_element).m_next;

  }while(1);

  return l_exit;
}

extern int
database_aspect_write(
  FILE*const                            io_fp,
  struct database_aspect const*const    i_aspect)
{
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;

  l_exit= 0;

  /* array */
  l_octet= bson_type_array;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "database%c",0);

  /* document */
  l_offset= ftell(io_fp);
  l_int32= 0;
  fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 

  /* tag */
  if ((*i_aspect).m_tag[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "tag%c",0);
    l_int32= strlen((*i_aspect).m_tag);
    l_int32++;
    fwrite(&l_int32, sizeof(l_int32), 1, io_fp);
    fwrite((*i_aspect).m_tag, l_int32, 1, io_fp);
  }

  /* driver */
  if ((*i_aspect).m_driver[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "driver%c",0);
    l_int32= strlen((*i_aspect).m_driver);
    l_int32++;
    fwrite(&l_int32, sizeof(l_int32), 1, io_fp);
    fwrite((*i_aspect).m_driver, l_int32, 1, io_fp);
  }

  /* dbname */
  if ((*i_aspect).m_dbname[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "dbname%c",0);
    l_int32= strlen((*i_aspect).m_dbname);
    l_int32++;
    fwrite(&l_int32, sizeof(l_int32), 1, io_fp);
    fwrite((*i_aspect).m_dbname, l_int32, 1, io_fp);
  }

  /* host */
  if ((*i_aspect).m_host[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "host%c",0);
    l_int32= strlen((*i_aspect).m_host);
    l_int32++;
    fwrite(&l_int32, sizeof(l_int32), 1, io_fp);
    fwrite((*i_aspect).m_host, l_int32, 1, io_fp);
  }

  /* hostaddr */
  if ((*i_aspect).m_hostaddr[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "hostaddr%c",0);
    l_int32= strlen((*i_aspect).m_hostaddr);
    l_int32++;
    fwrite(&l_int32, sizeof(l_int32), 1, io_fp);
    fwrite((*i_aspect).m_hostaddr, l_int32, 1, io_fp);
  }

  /* port */
  if ((*i_aspect).m_port[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "port%c",0);
    l_int32= strlen((*i_aspect).m_port);
    l_int32++;
    fwrite(&l_int32, sizeof(l_int32), 1, io_fp);
    fwrite((*i_aspect).m_port, l_int32, 1, io_fp);
  }

  /* username */
  if ((*i_aspect).m_username[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "username%c",0);
    l_int32= strlen((*i_aspect).m_username);
    l_int32++;
    fwrite(&l_int32, sizeof(l_int32), 1, io_fp);
    fwrite((*i_aspect).m_username, l_int32, 1, io_fp);
  }

  /* prompt_password */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "prompt_password%c",0);
  l_int32= (*i_aspect).m_prompt_password;
  fwrite(&l_int32, sizeof(l_int32), 1, io_fp);

  /* end of document */
  l_octet= 0;
  fwrite(&l_octet, 1, 1, io_fp); 

  /* document */
  l_int32= ftell(io_fp);
  l_size= (l_int32 - l_offset);
  fseek(io_fp, l_offset, SEEK_SET);
  fwrite(&l_size, sizeof(l_size), 1, io_fp); 

  fseek(io_fp, 0, SEEK_END);

  return l_exit;
}
