/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __config_h__

#include "global_common.h"
#include "page_setup.h"

struct config
{
  char*                                 m_filename;
  GtkPageSetup*                         m_page_setup;
};

extern void
config_assign(
  struct config*const                   o_config);

extern void
config_assign_filename(
  struct config*const                   io_config,
  char const*                           i_reportfile);

extern void
config_discharge(
  struct config*const                   io_config);

extern int
config_read(
  GError**                              o_error,
  struct config*const                   io_config);

extern gboolean
config_read_division_height(
  double *const                         o_height,
  char const*                           i_tag,
  struct config const*const             i_config);

extern void
config_reset_page_setup(
  struct config*const                   io_config);

extern void
config_set_paper(
  struct config*const                   io_config,
  GtkPageSetup const*const              i_page_setup);

extern int
config_write(
  GError**                              o_error,
  struct config const*const             i_config);

extern gboolean
config_write_division_height(
  struct config const*const             io_config,
  char const*                           i_tag,
  double const                          i_height);

#define  __config_h__
#endif
