/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "config.h"

extern void
config_assign(
  struct config*const                   o_config)
{

  memset(o_config, 0, sizeof(*o_config));
  (*o_config).m_page_setup= gtk_page_setup_new();

  return;
}

extern void
config_assign_filename(
  struct config*const                   io_config,
  char const*                           i_reportfile)
{
  FILE*                                 l_fp;
  char*                                 l_ptr;
  unsigned                              l_size;
  char*                                 l_configfile;

  if ((*io_config).m_filename)
  {
    g_free((*io_config).m_filename);
  }

  l_size= strlen(i_reportfile);
  l_configfile= (char*)g_malloc0(5+l_size);
  strcpy(l_configfile, i_reportfile);

  l_ptr= strrchr(l_configfile, '.'); 

  if (0 == l_ptr)
  {
    l_ptr= &l_configfile[l_size];
  }

  strcpy(l_ptr, ".cfg");

  l_fp= g_fopen(l_configfile, "a+");

  if (l_fp)
  {
    fclose(l_fp);
  }

  (*io_config).m_filename= l_configfile;

  return;
}

extern void
config_discharge(
  struct config*const                   io_config)
{

  if ((*io_config).m_filename)
  {
    g_free((*io_config).m_filename);
  }

  if ((*io_config).m_page_setup)
  {
    g_object_unref((*io_config).m_page_setup);
  }

  memset(io_config, 0, sizeof(*io_config));

  return;
}

extern void
config_reset_page_setup(
  struct config*const                   io_config)
{

  if ((*io_config).m_page_setup)
  {
    g_object_unref((*io_config).m_page_setup);
  }

  (*io_config).m_page_setup= gtk_page_setup_new();

  return;
}

extern void
config_set_paper(
  struct config*const                   io_config,
  GtkPageSetup const*const              i_page_setup)
{

  if ((*io_config).m_page_setup)
  {
    g_object_unref((*io_config).m_page_setup);
  }

  (*io_config).m_page_setup= gtk_page_setup_copy((GtkPageSetup*)i_page_setup);

  return;
}

extern int
config_read(
  GError**                              o_error,
  struct config*const                   io_config)
{
  int                                   l_exit;

  l_exit= page_setup_read(
    o_error,
    (*io_config).m_page_setup,
    (*io_config).m_filename);

  return l_exit;
}

extern gboolean
config_read_division_height(
  double *const                         o_height,
  char const*                           i_tag,
  struct config const*const             i_config)
{
  GKeyFile*                             l_key;
  gboolean                              l_exit;
  GError*                               l_error;
  double                                l_value;

  l_error= 0;
  
  do
  {

    l_key= g_key_file_new();

    l_exit= g_key_file_load_from_file(
      l_key,
      (*i_config).m_filename, 
      G_KEY_FILE_NONE, 
      0);

    if (0 == l_exit)
    {
      break;
    }

    l_value= g_key_file_get_double(l_key, i_tag, "Height", &l_error);

    if (l_error)
    {
      _error_log(l_error);
      l_exit= -1;
      break;
    }

    (*o_height)= l_value;

  }while(0);

  g_clear_error(&l_error);
  
  if (l_key)
  {
    g_key_file_free(l_key);
  }

  return l_exit;
}

extern int
config_write(
  GError**                              o_error,
  struct config const*const             i_config)
{
  int                                   l_exit;

  l_exit= page_setup_write(
    o_error,
    (*i_config).m_filename,
    (*i_config).m_page_setup);

  return l_exit;
}

extern gboolean
config_write_division_height(
  struct config const*const             io_config,
  char const*                           i_tag,
  double const                          i_height)
{
  GError*                               l_error;
  gboolean                              l_exit;
  GKeyFile*                             l_key;

  l_error= 0;
  
  do
  {

    l_key= g_key_file_new();

    l_exit= g_key_file_load_from_file(
      l_key,
      (*io_config).m_filename, 
      G_KEY_FILE_NONE, 
      0);

    if (0 == l_exit)
    {
      break;
    }

    g_key_file_set_double(l_key, i_tag, "Height", i_height);
    g_key_file_save_to_file(l_key, (*io_config).m_filename, &l_error);

    if (l_error)
    {
      _error_log(l_error);
      l_exit= -1;
      break;
    }

  }while(0);

  g_clear_error(&l_error);
  
  if (l_key)
  {
    g_key_file_free(l_key);
  }

  return l_exit;
}
