/*
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
  Copyright (c) 2015 Dante University Foundation and Contributors
  
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
  
     1. Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
  
     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
  
  THIS SOFTWARE IS PROVIDED BY Dante University Foundation ``AS IS'' AND ANY
  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL Dante University Foundation OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
  
  The views and conclusions contained in the software and documentation are
  those of the authors and should not be interpreted as representing official
  policies, either expressed or implied, of Dante University Foundation.
  
  Dante University Foundation
  P.O. Box 812158
  Wellesley, MA 02482
  USA
  www.danteuniversity.org
*/
#include "bson.h"

extern void
bson_node_assign(
  struct bson_node*                     o_node)
{

  if (o_node)
  {
    memset(o_node, 0, sizeof(*o_node));
  }

  return;
}

extern void
bson_node_discharge(
  struct bson_node*                     io_node)
{

  do
  {

    if (0 == io_node)
    {
      break;
    }
    
    if ((*io_node).m_ename)
    {
      free((*io_node).m_ename); 
    }

    switch((*io_node).m_type)
    {
      case bson_type_float:
        break;
      case bson_type_string:
        break;
      case bson_type_document:
        bson_document_discharge(&(*io_node).m_object.m_document);
        break;
      case bson_type_array:
        bson_document_discharge(&(*io_node).m_object.m_array);
        break;
      case bson_type_binary:
        break;
      case bson_type_deprecated1:
        break;
      case bson_type_objectid:
        break;
      case bson_type_boolean:
        break;
      case bson_type_utc_datetime:
        break;
      case bson_type_null:
        break;
      case bson_type_regex:
        if ((*io_node).m_object.m_regex.m_pattern)
        {
          free((*io_node).m_object.m_regex.m_pattern);
        }

        if ((*io_node).m_object.m_regex.m_options)
        {
          free((*io_node).m_object.m_regex.m_options);
        }
        break;
      case bson_type_deprecated2:
        break;
      case bson_type_js_code:
        if ((*io_node).m_object.m_js_code.m_text)
        {
          free((*io_node).m_object.m_js_code.m_text);
        }
        break;
      case bson_type_deprecated3:
        break;
      case bson_type_js_code_w_s:
        if ((*io_node).m_object.m_js_code_w_s.m_string.m_text)
        {
          free((*io_node).m_object.m_js_code_w_s.m_string.m_text);
        }
        bson_document_discharge(&(*io_node).m_object.m_js_code_w_s.m_document);
        break;
      case bson_type_int32:
        break;
      case bson_type_timestamp:
        break;
      case bson_type_int64:
        break;
      case bson_type_min_key:
        break;
      case bson_type_max_key:
        break;
      default:
        break;
    }

  }while(0);

  return;
}

