/*
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
  Copyright (c) 2015 Dante University Foundation and Contributors
  
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
  
     1. Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
  
     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
  
  THIS SOFTWARE IS PROVIDED BY Dante University Foundation ``AS IS'' AND ANY
  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL Dante University Foundation OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
  
  The views and conclusions contained in the software and documentation are
  those of the authors and should not be interpreted as representing official
  policies, either expressed or implied, of Dante University Foundation.
  
  Dante University Foundation
  P.O. Box 812158
  Wellesley, MA 02482
  USA
  www.danteuniversity.org
*/
#include "bson.h"

extern void
bson_document_assign(
  struct bson_document*                 o_doc)
{
  if (o_doc)
  {
    memset(o_doc, 0, sizeof(*o_doc));
  }

  return;
}

extern void
bson_document_discharge(
  struct bson_document*                 io_doc)
{
  struct bson_node*                     l_node;
  struct bson_node*                     l_next;

  do
  {

    if (0 == io_doc)
    {
      break;
    }

    l_node= (*io_doc).m_head;

    do
    {

      if (0 == l_node)
      {
        break;
      }

      l_next= (*l_node).m_next;

      bson_node_discharge(l_node);
      free(l_node);
      l_node= l_next;

    }while(1);

  }while(0);

  return;
}

extern struct bson_node*
bson_document_node_new(
  struct bson_document*                 io_doc)
{
  struct bson_node*                     l_node;

  do
  {

    if (0 == io_doc)
    {
      break;
    }

    l_node= (struct bson_node*)malloc(sizeof(*l_node));
    bson_node_assign(l_node);

    if (0 == (*io_doc).m_head)
    { 
      (*io_doc).m_head= l_node;
    }
    else
    {
      (*l_node).m_prev= (*io_doc).m_tail;
      (*io_doc).m_tail->m_next= l_node;
    }
    
    (*io_doc).m_tail= l_node;

  }while(0);

  return l_node;
}

