/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "barsym_code128.h"

char const* g_code128_encode[107]= {
  /*value*//*pattern*/
  /*  0*/ "11011001100",
  /*  1*/ "11001101100",
  /*  2*/ "11001100110",
  /*  3*/ "10010011000",
  /*  4*/ "10010001100",
  /*  5*/ "10001001100",
  /*  6*/ "10011001000",
  /*  7*/ "10011000100",
  /*  8*/ "10001100100",
  /*  9*/ "11001001000",
  /* 10*/ "11001000100",
  /* 11*/ "11000100100",
  /* 12*/ "10110011100",
  /* 13*/ "10011011100",
  /* 14*/ "10011001110",
  /* 15*/ "10111001100",
  /* 16*/ "10011101100",
  /* 17*/ "10011100110",
  /* 18*/ "11001110010",
  /* 19*/ "11001011100",
  /* 20*/ "11001001110",
  /* 21*/ "11011100100",
  /* 22*/ "11001110100",
  /* 23*/ "11101101110",
  /* 24*/ "11101001100",
  /* 25*/ "11100101100",
  /* 26*/ "11100100110",
  /* 27*/ "11101100100",
  /* 28*/ "11100110100",
  /* 29*/ "11100110010",
  /* 30*/ "11011011000",
  /* 31*/ "11011000110",
  /* 32*/ "11000110110",
  /* 33*/ "10100011000",
  /* 34*/ "10001011000",
  /* 35*/ "10001000110",
  /* 36*/ "10110001000",
  /* 37*/ "10001101000",
  /* 38*/ "10001100010",
  /* 39*/ "11010001000",
  /* 40*/ "11000101000",
  /* 41*/ "11000100010",
  /* 42*/ "10110111000",
  /* 43*/ "10110001110",
  /* 44*/ "10001101110",
  /* 45*/ "10111011000",
  /* 46*/ "10111000110",
  /* 47*/ "10001110110",
  /* 48*/ "11101110110",
  /* 49*/ "11010001110",
  /* 50*/ "11000101110",
  /* 51*/ "11011101000",
  /* 52*/ "11011100010",
  /* 53*/ "11011101110",
  /* 54*/ "11101011000",
  /* 55*/ "11101000110",
  /* 56*/ "11100010110",
  /* 57*/ "11101101000",
  /* 58*/ "11101100010",
  /* 59*/ "11100011010",
  /* 60*/ "11101111010",
  /* 61*/ "11001000010",
  /* 62*/ "11110001010",
  /* 63*/ "10100110000",
  /* 64*/ "10100001100",
  /* 65*/ "10010110000",
  /* 66*/ "10010000110",
  /* 67*/ "10000101100",
  /* 68*/ "10000100110",
  /* 69*/ "10110010000",
  /* 70*/ "10110000100",
  /* 71*/ "10011010000",
  /* 72*/ "10011000010",
  /* 73*/ "10000110100",
  /* 74*/ "10000110010",
  /* 75*/ "11000010010",
  /* 76*/ "11001010000",
  /* 77*/ "11110111010",
  /* 78*/ "11000010100",
  /* 79*/ "10001111010",
  /* 80*/ "10100111100",
  /* 81*/ "10010111100",
  /* 82*/ "10010011110",
  /* 83*/ "10111100100",
  /* 84*/ "10011110100",
  /* 85*/ "10011110010",
  /* 86*/ "11110100100",
  /* 87*/ "11110010100",
  /* 88*/ "11110010010",
  /* 89*/ "11011011110",
  /* 90*/ "11011110110",
  /* 91*/ "11110110110",
  /* 92*/ "10101111000",
  /* 93*/ "10100011110",
  /* 94*/ "10001011110",
  /* 95*/ "10111101000",
  /* 96*/ "10111100010", /* FNC 3   : FNC 3   : 96 */
  /* 97*/ "11110101000", /* FNC 2   : FNC 2   : 97 */
  /* 98*/ "11110100010", /* SHIFT B : SHIFT A : 98*/
  /* 99*/ "10111011110", /* CODE C  : CODE C  : 99 */
  /*100*/ "10111101110", /* CODE B  : FNC 4   : CODE-B */
  /*101*/ "11101011110", /* FNC 4   : CODE A  : CODE-A */
  /*102*/ "11110101110", /* FNC 1   : FNC 1   : FNC 1 */
  /*103*/ "11010000100", /* Start Code A */
  /*104*/ "11010010000", /* Start Code B */
  /*105*/ "11010011100", /* Start Code C */
  /*106*/ "1100011101011" /* Stop */
};

extern int
barsym_code128ab_get_value(
  int*const                             o_flags,
  unsigned char const                   i_code)
{
  int                                   l_code;
  int                                   l_value;

  switch(i_code)
  {
  case ' ':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 0;
    break;
  case '!':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 1;
    break;
  case '"':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 2;
    break;
  case '#':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 3;
    break;
  case '$':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 4;
    break;
  case '%':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 5;
    break;
  case '&':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 6;
    break;
  case '\'':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 7;
    break;
  case '(':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 8;
    break;
  case ')':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 9;
    break;
  case '*':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 10;
    break;
  case '+':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 11;
    break;
  case ',':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 12;
    break;
  case '-':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 13;
    break;
  case '.':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 14;
    break;
  case '/':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 15;
    break;
  case '0':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 16;
    break;
  case '1':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 17;
    break;
  case '2':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 18;
    break;
  case '3':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 19;
    break;
  case '4':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 20;
    break;
  case '5':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 21;
    break;
  case '6':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 22;
    break;
  case '7':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 23;
    break;
  case '8':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 24;
    break;
  case '9':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 25;
    break;
  case ':':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 26;
    break;
  case ';':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 27;
    break;
  case '<':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 28;
    break;
  case '=':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 29;
    break;
  case '>':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 30;
    break;
  case '?':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 31;
    break;
  case '@':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 32;
    break;
  case 'A':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 33;
    break;
  case 'B':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 34;
    break;
  case 'C':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 35;
    break;
  case 'D':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 36;
    break;
  case 'E':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 37;
    break;
  case 'F':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 38;
    break;
  case 'G':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 39;
    break;
  case 'H':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 40;
    break;
  case 'I':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 41;
    break;
  case 'J':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 42;
    break;
  case 'K':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 43;
    break;
  case 'L':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 44;
    break;
  case 'M':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 45;
    break;
  case 'N':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 46;
    break;
  case 'O':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 47;
    break;
  case 'P':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 48;
    break;
  case 'Q':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 49;
    break;
  case 'R':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 50;
    break;
  case 'S':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 51;
    break;
  case 'T':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 52;
    break;
  case 'U':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 53;
    break;
  case 'V':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 54;
    break;
  case 'W':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 55;
    break;
  case 'X':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 56;
    break;
  case 'Y':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 57;
    break;
  case 'Z':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 58;
    break;
  case '[':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 59;
    break;
  case '\\':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 60;
    break;
  case ']':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 61;
    break;
  case '^':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 62;
    break;
  case '_':
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 63;
    break;
  /* CODE B ONLY */
  case '`':
    l_code= CODE_128B_FLAG;
    l_value= 64;
    break;
  case 'a':
    l_code= CODE_128B_FLAG;
    l_value= 65;
    break;
  case 'b':
    l_code= CODE_128B_FLAG;
    l_value= 66;
    break;
  case 'c':
    l_code= CODE_128B_FLAG;
    l_value= 67;
    break;
  case 'd':
    l_code= CODE_128B_FLAG;
    l_value= 68;
    break;
  case 'e':
    l_code= CODE_128B_FLAG;
    l_value= 69;
    break;
  case 'f':
    l_code= CODE_128B_FLAG;
    l_value= 70;
    break;
  case 'g':
    l_code= CODE_128B_FLAG;
    l_value= 71;
    break;
  case 'h':
    l_code= CODE_128B_FLAG;
    l_value= 72;
    break;
  case 'i':
    l_code= CODE_128B_FLAG;
    l_value= 73;
    break;
  case 'j':
    l_code= CODE_128B_FLAG;
    l_value= 74;
    break;
  case 'k':
    l_code= CODE_128B_FLAG;
    l_value= 75;
    break;
  case 'l':
    l_code= CODE_128B_FLAG;
    l_value= 76;
    break;
  case 'm':
    l_code= CODE_128B_FLAG;
    l_value= 77;
    break;
  case 'n':
    l_code= CODE_128B_FLAG;
    l_value= 78;
    break;
  case 'o':
    l_code= CODE_128B_FLAG;
    l_value= 79;
    break;
  case 'p':
    l_code= CODE_128B_FLAG;
    l_value= 80;
    break;
  case 'q':
    l_code= CODE_128B_FLAG;
    l_value= 81;
    break;
  case 'r':
    l_code= CODE_128B_FLAG;
    l_value= 82;
    break;
  case 's':
    l_code= CODE_128B_FLAG;
    l_value= 83;
    break;
  case 't':
    l_code= CODE_128B_FLAG;
    l_value= 84;
    break;
  case 'u':
    l_code= CODE_128B_FLAG;
    l_value= 85;
    break;
  case 'v':
    l_code= CODE_128B_FLAG;
    l_value= 86;
    break;
  case 'w':
    l_code= CODE_128B_FLAG;
    l_value= 87;
    break;
  case 'x':
    l_code= CODE_128B_FLAG;
    l_value= 88;
    break;
  case 'y':
    l_code= CODE_128B_FLAG;
    l_value= 89;
    break;
  case 'z':
    l_code= CODE_128B_FLAG;
    l_value= 90;
    break;
  case '{':
    l_code= CODE_128B_FLAG;
    l_value= 91;
    break;
  case '|':
    l_code= CODE_128B_FLAG;
    l_value= 92;
    break;
  case '}':
    l_code= CODE_128B_FLAG;
    l_value= 93;
    break;
  case '~':
    l_code= CODE_128B_FLAG;
    l_value= 94;
    break;
  case 0x7F:
    l_code= CODE_128B_FLAG;
    l_value= 95;
    break;
  /* CODE A ONLY */
  case 0x00:
    l_code= CODE_128A_FLAG;
    l_value= 64;
    break;
  case 0x01:
    l_code= CODE_128A_FLAG;
    l_value= 65;
    break;
  case 0x02:
    l_code= CODE_128A_FLAG;
    l_value= 66;
    break;
  case 0x03:
    l_code= CODE_128A_FLAG;
    l_value= 67;
    break;
  case 0x04:
    l_code= CODE_128A_FLAG;
    l_value= 68;
    break;
  case 0x05:
    l_code= CODE_128A_FLAG;
    l_value= 69;
    break;
  case 0x06:
    l_code= CODE_128A_FLAG;
    l_value= 70;
    break;
  case 0x07:
    l_code= CODE_128A_FLAG;
    l_value= 71;
    break;
  case 0x08:
    l_code= CODE_128A_FLAG;
    l_value= 72;
    break;
  case 0x09:
    l_code= CODE_128A_FLAG;
    l_value= 73;
    break;
  case 0x0A:
    l_code= CODE_128A_FLAG;
    l_value= 74;
    break;
  case 0x0B:
    l_code= CODE_128A_FLAG;
    l_value= 75;
    break;
  case 0x0C:
    l_code= CODE_128A_FLAG;
    l_value= 76;
    break;
  case 0x0D:
    l_code= CODE_128A_FLAG;
    l_value= 77;
    break;
  case 0x0E:
    l_code= CODE_128A_FLAG;
    l_value= 78;
    break;
  case 0x0F:
    l_code= CODE_128A_FLAG;
    l_value= 79;
    break;
  case 0x10:
    l_code= CODE_128A_FLAG;
    l_value= 80;
    break;
  case 0x11:
    l_code= CODE_128A_FLAG;
    l_value= 81;
    break;
  case 0x12:
    l_code= CODE_128A_FLAG;
    l_value= 82;
    break;
  case 0x13:
    l_code= CODE_128A_FLAG;
    l_value= 83;
    break;
  case 0x14:
    l_code= CODE_128A_FLAG;
    l_value= 84;
    break;
  case 0x15:
    l_code= CODE_128A_FLAG;
    l_value= 85;
    break;
  case 0x16:
    l_code= CODE_128A_FLAG;
    l_value= 86;
    break;
  case 0x17:
    l_code= CODE_128A_FLAG;
    l_value= 87;
    break;
  case 0x18:
    l_code= CODE_128A_FLAG;
    l_value= 88;
    break;
  case 0x19:
    l_code= CODE_128A_FLAG;
    l_value= 89;
    break;
  case 0x1A:
    l_code= CODE_128A_FLAG;
    l_value= 90;
    break;
  case 0x1B:
    l_code= CODE_128A_FLAG;
    l_value= 91;
    break;
  case 0x1C:
    l_code= CODE_128A_FLAG;
    l_value= 92;
    break;
  case 0x1D:
    l_code= CODE_128A_FLAG;
    l_value= 93;
    break;
  case 0x1E:
    l_code= CODE_128A_FLAG;
    l_value= 94;
    break;
  case 0x1F:
    l_code= CODE_128A_FLAG;
    l_value= 95;
    break;
  case 200:
    l_code= CODE_128A_FLAG | CODE_128B_FLAG;
    l_value= 95;
    break;
/*
  case 201:
    l_value= 96;
    break;
  case 202:
    l_value= 97;
    break;
  case 203:
    l_value= 98;
    break;
  case 204:
    l_value= 99;
    break;
  case 205:
    l_value= 100;
    break;
  case 206:
    l_value= 101;
    break;
  case 207:
    l_value= 102;
    break;
  case 208:
    l_value= 103;
    break;
  case 209:
    l_value= 104;
    break;
  case 210:
    l_value= 105;
    break;
  case 211:
    l_value= 106;
*/
    break;
  default:
    l_code= CODE_UNKOWN;
    l_value= -1; /* not found */
    break;
  }

  (*o_flags)= l_code;

  return l_value;
}
