/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __barsym_h__

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <cairo/cairo.h>

#define BARSYM_FONT_SIZE                10.0

#ifdef POINTS_PER_INCH
#undef POINTS_PER_INCH
#endif
#define POINTS_PER_INCH                 72.0

#define MM_PER_IN                       0.03937007874

#define EAN13_XDIMENSION_MM             0.33
#define EAN13_WIDTH                     (37.29 * MM_PER_IN)
#define EAN13_HEIGHT                    (25.93 * MM_PER_IN)
#define EAN13_QUIET_ZONE_LEFT           (3.63 * MM_PER_IN)
#define EAN13_QUIET_ZONE_RIGHT          (2.31 * MM_PER_IN)
#define EAN13_BAR_HEIGHT                (22.85 * MM_PER_IN)
#define EAN13_BAR_WIDTH                 (EAN13_XDIMENSION_MM * MM_PER_IN)
#define EAN13_SCALE_MIN                 0.8
#define EAN13_SCALE_MAX                 2.0

#define EAN8_XDIMENSION_MM              EAN13_XDIMENSION_MM
#define EAN8_WIDTH                      (26.73 * MM_PER_IN)
#define EAN8_HEIGHT                     (21.31 * MM_PER_IN)
#define EAN8_QUIET_ZONE_RIGHT           EAN13_QUIET_ZONE_RIGHT
#define EAN8_QUIET_ZONE_LEFT            EAN13_QUIET_ZONE_RIGHT
#define EAN8_BAR_HEIGHT                 (18.23 * MM_PER_IN)
#define EAN8_BAR_WIDTH                  EAN13_BAR_WIDTH
#define EAN8_SCALE_MIN                  EAN13_SCALE_MIN
#define EAN8_SCALE_MAX                  EAN13_SCALE_MAX

#define BARSYM_GUARD                    0x01

struct barsym
{
  cairo_t*                              m_cr;
  double                                m_height;
  double                                m_quiet_zone_left;
  double                                m_quiet_zone_right;
  double                                m_bar_width;
  double                                m_bar_height;
  double                                m_guard_height;
  double                                m_pos_x;
  double                                m_pos_y;
  unsigned                              m_print_text:1;
};

extern int
barsym_code128(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern void
barsym_code128_default(
  struct barsym*const                   io_barsym);

extern double
barsym_code128_get_width(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern int
barsym_code128_verify(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern void
barsym_code39(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern void
barsym_code39_default(
  struct barsym*const                   io_barsym);

extern double
barsym_code39_get_width(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern int
barsym_code39_verify(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern void
barsym_code93(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern void
barsym_code93_default(
  struct barsym*const                   io_barsym);

extern double
barsym_code93_get_width(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern int
barsym_code93_verify(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern void
barsym_codabar(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern void
barsym_codabar_default(
  struct barsym*const                   io_barsym);

extern double
barsym_codabar_get_width(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern int
barsym_codabar_verify(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern void
barsym_ean2(
  struct barsym*const                   io_barsym,
  char const                            i_digits[2]);

extern void
barsym_ean2_default(
  struct barsym*const                   io_barsym);

extern double
barsym_ean2_get_width(
  struct barsym*const                   io_barsym,
  char const                            i_digits[2]);

extern int
barsym_ean2_verify(
  char const                            i_digits[2]);

extern void
barsym_ean5(
  struct barsym*const                   io_barsym,
  char const                            i_digits[5]);

extern void
barsym_ean5_default(
  struct barsym*const                   io_barsym);

extern double
barsym_ean5_get_width(
  struct barsym*const                   io_barsym,
  char const                            i_digits[5]);

extern int
barsym_ean5_verify(
  char const                            i_digits[5]);

extern void
barsym_ean8(
  struct barsym*const                   io_barsym,
  char const                            i_digits[8]);

extern void
barsym_ean8_default(
  struct barsym*const                   io_barsym);

extern double
barsym_ean8_get_width(
  struct barsym*const                   io_barsym,
  char const                            i_digits[8]);

extern int
barsym_ean8_verify(
  char const                            i_digits[8]);

extern void
barsym_ean13(
  struct barsym*const                   io_barsym,
  char const                            i_digits[13]);

extern void
barsym_ean13_default(
  struct barsym*const                   io_barsym);

extern double
barsym_ean13_get_width(
  struct barsym*const                   io_barsym,
  char const                            i_digits[13]);

extern int
barsym_ean13_verify(
  char const                            i_digits[13]);

extern unsigned char*
barsym_filter(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length);

extern void
barsym_interleaved2of5(
  struct barsym*const                   io_barsym,
  char const*                           i_digits);

extern void
barsym_interleaved2of5_default(
  struct barsym*const                   io_barsym);

extern double
barsym_interleaved2of5_get_width(
  struct barsym*const                   io_barsym,
  char const*                           i_digits);

extern int
barsym_interleaved2of5_verify(
  char const*                           i_digits);

extern void
barsym_set_font(
  struct barsym*const                   io_barsym);

extern void
barsym_standard2of5(
  struct barsym*const                   io_barsym,
  char const*                           i_digits);

extern void
barsym_standard2of5_default(
  struct barsym*const                   io_barsym);

extern double
barsym_standard2of5_get_width(
  struct barsym*const                   io_barsym,
  char const*                           i_digits);

extern int
barsym_standard2of5_verify(
  char const*                           i_digits);

extern int
barsym_verify_digits(
  char const*                           i_digits,
  unsigned const                        i_length);

extern void
barsym_write_bar(
  struct barsym*const                   io_ctx,
  char const*                           i_encode,
  int const                             i_flags);

#define __barsym_h__
#endif
