/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "orcl.hpp"

static int
build_attr(
  char**                                o_error,
  struct orcl*const                     io_oracle)
{
  char const*                           l_emsg;
  struct iwsql_attr*                    l_attr;
  int                                   l_exit= 0;
  std::string                           l_name;
  unsigned                              l_slot;
  oracle::occi::Type                    l_type;
  std::vector<oracle::occi::MetaData>   l_vec;

  (*o_error)= 0;

  try
  {

    l_vec.clear();
    l_vec= (*io_oracle).m_rs->getColumnListMetaData();
    (*io_oracle).m_attr_slots= l_vec.size();

    l_attr= (struct iwsql_attr*)
      calloc((*io_oracle).m_attr_slots, sizeof(struct iwsql_attr));
    (*io_oracle).m_attr= l_attr;

    for (l_slot=0; (*io_oracle).m_attr_slots > l_slot; l_slot++)
    {
      memset(l_attr, 0, sizeof(*l_attr));

      l_name= l_vec[l_slot].getString(oracle::occi::MetaData::ATTR_NAME);
      (*l_attr).m_tag= (char*)malloc(1+l_name.length());
      strcpy((*l_attr).m_tag, l_name.c_str());

      l_type= static_cast<oracle::occi::Type>(
        l_vec[l_slot].getInt(oracle::occi::MetaData::ATTR_DATA_TYPE));

      iwsql_type_translate(&(*l_attr).m_type, l_type);

      (*l_attr).m_size= 
        l_vec[l_slot].getInt(oracle::occi::MetaData::ATTR_DATA_SIZE);
  
      l_attr++;

    }
  
  }
  catch(std::exception& excp)
  {
    l_emsg= excp.what();
    (*o_error)= (char*)malloc(1+strlen(l_emsg));
    strcpy((*o_error), l_emsg);
    l_exit= -1;
  }


  return l_exit;
}

extern int
iwsql_exec(
  char**                                o_error,
  char const*                           i_query,
  struct orcl*const                     io_oracle)
{
  int                                   l_exit= 0;
  char const*                           l_emsg;

  if ((*io_oracle).m_attr)
  {
    iwsql_attr_delete(&(*io_oracle).m_attr, (*io_oracle).m_attr_slots);
    (*io_oracle).m_attr_slots= 0;
  }

  if ((*io_oracle).m_rs)
  {
    try
    {
      (*io_oracle).m_stmt->closeResultSet((*io_oracle).m_rs);
      (*io_oracle).m_conn->terminateStatement((*io_oracle).m_stmt);
      (*io_oracle).m_rs= 0;
      (*io_oracle).m_stmt= 0;
    }
    catch(std::exception& excp)
    {
      // todo:
    }
  }

  do
  {

    try
    {
      (*io_oracle).m_stmt= (*io_oracle).m_conn->createStatement(i_query);
      (*io_oracle).m_rs= (*io_oracle).m_stmt->executeQuery();
    }
    catch(std::exception& excp)
    {
      l_emsg= excp.what();
      (*o_error)= (char*)malloc(1+strlen(l_emsg));
      strcpy((*o_error), l_emsg);
      l_exit= -1;
      break;
    }

    l_exit= build_attr(o_error, io_oracle);

  }while(0);

  return l_exit;
}
