/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __iwsql_h__

struct iwsql_aspect
{
  char                                  m_dbname[255+1];
  char                                  m_host[63+1];
  char                                  m_hostaddr[47+1];
  char                                  m_port[7+1];
  char                                  m_username[31+1];
  char                                  m_password[31+1];
};

enum iwsql_type
{
  iwsql_type_unkown,
  iwsql_type_blob,        /* blob type */
  iwsql_type_bool,        /* true/false bool */
  iwsql_type_bytea,       /* variable length string */
  iwsql_type_char,        /* single char */
  iwsql_type_double,      /* 8 byte float */
  iwsql_type_float,       /* 4 byte float */
  iwsql_type_long,        /* 4 byte -2 billion to 2 billon */ 
  iwsql_type_longlong,    /* 8 byte 18 digit number */
  iwsql_type_null,        /* null/empty - no value */
  iwsql_type_short,       /* 2 byte -32 thousand to 32 thousand */
  iwsql_type_vchar        /* variable length string */
};

struct iwsql_attr
{
  char*                                 m_tag;
  unsigned                              m_size;
  enum iwsql_type                       m_type;
  char*                                 m_value;
};

#define IWSQL_METHOD_CONNECT            "iwsql_connect"
#define IWSQL_METHOD_DELETE             "iwsql_delete"
#define IWSQL_METHOD_EXEC               "iwsql_exec" 
#define IWSQL_METHOD_NEW                "iwsql_new" 
#define IWSQL_METHOD_NEXT               "iwsql_next"
#define IWSQL_METHOD_FETCH_RESULT       "iwsql_result"

typedef void*                           iwsql_handle_t;

#ifdef __cplusplus
extern "C" {
#endif

typedef int (*iwsql_connect_t)(
  char**                                o_error,
  struct iwsql_aspect const*const       i_aspect,
  iwsql_handle_t const                  i_handle);

typedef void (*iwsql_delete_t) (
  iwsql_handle_t*                       io_handle);

typedef int (*iwsql_exec_t)(
  char**                                o_error,
  char const*                           i_query,
  iwsql_handle_t const                  i_handle);

typedef void (*iwsql_new_t) (
  iwsql_handle_t*                       o_handle);

typedef int (*iwsql_next_t)(
  char**                                o_error,
  int*const                             o_eof,
  iwsql_handle_t const                  o_handle);

typedef void (*iwsql_result_t)(
  struct iwsql_attr const**             o_attr,
  unsigned*const                        o_slots,
  iwsql_handle_t const                  o_handle);

#ifdef __cplusplus
}
#endif

#define __iwsql_h__
#endif
