{- This source file is part of mmisar - a tool for converting
Metamath proofs to Isabelle/Isar.
Copyright 2006 Slawomir Kolodynski

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
-}


module Main where

import System
import Outer

main = do 
   args <- getArgs
   if (length args) == 2 then do 
         kths <- readFile (head args)  -- list of known theorems
         nths <- readFile (args !! 1) -- new theorems to be imported
         writeFile "new_theorems.mms" (makeMMscript "new_theorems.log" nths )
         system "./metamath set.mm < new_theorems.mms > /dev/null"
         ntlog <- readFile "new_theorems.log"
         writeOut "new_theorems.thy" "new_deps.txt" "new_known_theorems.txt" (mmiIn2out MMIinput{ knownThms = kths, mmout = ntlog})
         d <- readFile "new_deps.txt"
         writeFile "new_deps.mms" (makeMMscript "new_deps.log" d )
         system "./metamath set.mm < new_deps.mms > /dev/null"
         dlog <- readFile "new_deps.log"
         writeFile "new_deps.thy" (mmiIn2outDeps dlog)
      else error usage

------------------- level 0 ---------------------------------------------------

usage = "Usage:\nmmisar <known_theorems> <new_theorems>\n"

-- writes out the contents of the MMIoutput structure to three files
-- file1 is the file with new Isar theorems, 
---file2 is the list of unsatisfied depemdencies
-- file3 is the new list of known theorems
writeOut :: FilePath -> FilePath -> FilePath -> MMIoutput -> IO ()
writeOut file1 file2 file3 outstruct = do
   writeFile file1 (isarThms outstruct)
   writeFile file2 (newDeps outstruct)
   writeFile file3 (newKnown outstruct)
