
(*
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

HIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Real\_ZF\_1.thy}*}

theory Real_ZF_1 imports Real_ZF Int_ZF_2

begin

text{*In this theory file we continue the construction of real numbers started
  in @{text "Real_ZF.thy"}. We put here those parts of the construction that 
  can not be done in the general settings of abelian groups and require 
  integers, but do not require the axiom of choice.*}

section{*Multiplication of real numbers*}

text{*Multiplication of real numbers is defined as a projection of 
  composition of slopes onto the space of equivalence classes of slopes.
  Thus, the product of the real numbers given as classes of slopes $s$ and 
  $r$ is defined as the class of $s\circ r$. The goal of this section is to 
  show that multiplication defined this way is commutative.*}

text{*The next locale extends the locale @{text "real0"} to define notation 
  specific to the construction of real numbers.*}

locale real1 = real0 +

  fixes AlEq (infix "\<sim>" 68)
  defines AlEq_def [simp]: "s \<sim> r \<equiv> \<langle>s,r\<rangle> \<in> SlopeEquivalenceRel"

  fixes slope_comp (infix "\<circ>" 70)
  defines slope_comp_def [simp]: "s \<circ> r \<equiv>  SlopeOp2`\<langle>s,r\<rangle>"

text{*We will need two results from @{text "Group_ZF_3.thy"} 
  The first one that states that the definition
  of multiplication of real numbers is consistent, that is the result 
  does not depend on the choice of the slopes representing the numbers.
  The second one implies that what we call @{text "SlopeEquivalenceRel"} 
  is actually an equivalence relation on the set of slopes.*}

lemma (in real1) Real_ZF_1_1_L1: shows 
  "Congruent2(SlopeEquivalenceRel,SlopeOp2)"
  "equiv(Slopes,SlopeEquivalenceRel)"
proof-
  let ?G = "int"
  let ?f = "IntegerAddition"
  let ?FR = "FinRangeFunctions(int, int)"
  have "Congruent2
    (QuotientGroupRel(AlmostHoms(?G, ?f), AlHomOp1(?G, ?f), ?FR), 
    AlHomOp2(?G, ?f))"
    using Real_ZF_1_L1 group1.Group_ZF_3_4_L13A by simp
  then show "Congruent2(SlopeEquivalenceRel, SlopeOp2)"
    using SlopeEquivalenceRel_def SlopeOp1_def Slopes_def 
      BoundedIntMaps_def SlopeOp2_def by simp;
  have 
    "equiv(AlmostHoms(?G, ?f),
    QuotientGroupRel(AlmostHoms(?G, ?f),AlHomOp1(?G, ?f),?FR))"
    using Real_ZF_1_L1 group1.Group_ZF_3_3_L3 by simp;
  then show "equiv(Slopes,SlopeEquivalenceRel)"
    using BoundedIntMaps_def SlopeEquivalenceRel_def SlopeOp1_def Slopes_def
    by simp;
qed;

text{*Let's recall a theorem from @{text "Int_ZF_2.thy"} that states that 
  if $f,g$ are slopes,
  then $f\circ g$ is equivalent to $g\circ f$. Here we conclude from that that
  the classes of $f\circ g$ and $g\circ f$ are the same.*}

lemma (in real1) Real_ZF_1_1_L2: assumes A1: "f \<in> Slopes"  "g \<in> Slopes"
  shows "SlopeEquivalenceRel``{f\<circ>g} = SlopeEquivalenceRel``{g\<circ>f}"
proof -
  from A1 have "f\<circ>g \<sim> g\<circ>f" 
    using Slopes_def int1.Arthan_Th_9 SlopeOp1_def BoundedIntMaps_def
      SlopeEquivalenceRel_def SlopeOp2_def by simp;
  then show ?thesis using Real_ZF_1_1_L1 equiv_class_eq
    by simp;
qed;
  
text{*Multiplication of real numbers is commutative.*}

theorem (in real1) Real_mult_commute: assumes A1: "a\<in>\<real>"  "b\<in>\<real>"
  shows "a\<cdot>b = b\<cdot>a"
proof -;
  let ?r = "SlopeEquivalenceRel"
  from A1 have "a \<in> Slopes//?r"  "b \<in> Slopes//?r"  
    using RealNumbers_def by auto;
  then obtain f g where 
    D1: "f \<in> Slopes"  "g \<in> Slopes" and 
    D2: "a = ?r``{f}"  "b = ?r``{g}" 
    using quotient_def by auto;
  then have "a\<cdot>b = ProjFun2(Slopes,?r,SlopeOp2)`\<langle>?r``{f}, ?r``{g}\<rangle>"
    using RealMultiplication_def by simp;
  also from D1 have "\<dots> = ProjFun2(Slopes,?r,SlopeOp2)`\<langle>?r``{g}, ?r``{f}\<rangle>"
    using Real_ZF_1_1_L1 EquivClass_1_L10 Real_ZF_1_1_L2
    by simp;
  also from D2 have "\<dots> = b\<cdot>a"
    using RealMultiplication_def by simp;
  finally show "a\<cdot>b = b\<cdot>a" by simp;
qed;

end
  