(*
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Order\_ZF.thy}*}

theory Order_ZF = Trancl:

text{*This theory file defines a linear order as an antisymmetric,
  transitive and total relation. *}

section{*Linear order*}

text{*In this section we formulate the definition of linear order.*}

text{*We define a linear order as a binary relation that is antisymmetric, 
  transitive and total. Note that this terminology is different than the
  one used the standard Order.thy file. The sets that are bounded below and 
  above are also defined, as are bounded sets. Empty sets are defined as 
  bounded, we will see later if this does not lead to trouble.*}

constdefs 

  IsTotal :: "[i,i]\<Rightarrow>o" (infixl "{is total on}" 65)
  "r {is total on} X == (\<forall>a\<in>X.\<forall>b\<in>X. <a,b> \<in> r \<or> <b,a> \<in> r)"

  IsLinOrder :: "[i,i]\<Rightarrow>o"
  "IsLinOrder(X,r) == ( antisym(r) \<and> trans(r) \<and> 
  (r {is total on} X))"

  IsPartOrder :: "[i,i]\<Rightarrow>o"
  "IsPartOrder(X,r) == (refl(X,r) \<and> antisym(r) \<and> trans(r))"

  IsBoundedAbove :: "[i,i]\<Rightarrow>o"
  "IsBoundedAbove(A,r) == ( A=0 \<or> (\<exists>u. \<forall>x\<in>A. <x,u> \<in> r))"

  IsBoundedBelow :: "[i,i]\<Rightarrow>o"
  "IsBoundedBelow(A,r) == (A=0 \<or> (\<exists>l. \<forall>x\<in>A. <l,x> \<in> r))"

  IsBounded :: "[i,i]\<Rightarrow>o"
  "IsBounded(A,r) == (IsBoundedAbove(A,r) \<and> IsBoundedBelow(A,r))"

  Interval :: "[i,i,i]\<Rightarrow>i"
  "Interval(r,a,b) == r``{a} \<inter> r-``{b}";


text{*The essential condition to show that a total relation is reflexive.*}

lemma Order_ZF_L1: assumes A1: "r {is total on} X" and A2: "a\<in>X"
  shows "<a,a> \<in> r"
proof -;
  from A1 A2 show ?thesis using IsTotal_def by auto;
qed;

text{*A linear order is partial order.*}

lemma Order_ZF_L2: assumes A1: "IsLinOrder(X,r)" 
  shows "IsPartOrder(X,r)"
proof -;
  from A1 show ?thesis 
    using IsLinOrder_def IsPartOrder_def refl_def Order_ZF_L1
    by auto;
qed;

text{*The next lemma explains the notation of the definition of an interval.*}

lemma Order_ZF_L3: "x \<in> Interval(r,a,b) \<longleftrightarrow> <a,x> \<in> r \<and> <x,b> \<in> r"
proof -;
  show ?thesis using Interval_def by auto;
qed;


end
 
  
  

