/*
* ip_util.h (was ipv4_util.h and includes ipv4_util2 too)

Copyright (C) 2008-2023 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined IP_UTIL_H_INCLUDED
#include <stdint.h>
#include <arpa/inet.h>

union base_ip_fields
{
	unsigned char ip_data[16];
	uint32_t ipv4l;
	unsigned char ipv4[4];
	unsigned char ipv6[16];
	uint64_t ipv6l[2];
};

#define BASE_STRUCT_FIELDS                  \
	char ip;    /* 4 or 6               */ \
	char args;  /* 0, 1 or 2            */ \
	char plen;  /* [0, 127] if cidr     */ \
	char kill;  /* exec_connkill flag    */ \
	char ipv4_mapped; /* was IPv6       */ \
	char nu[3];                            \
	union  base_ip_fields u;

typedef struct ip_u
{
	BASE_STRUCT_FIELDS
} ip_u;

typedef struct ip_range
{
	BASE_STRUCT_FIELDS
	union  base_ip_fields u2;
} ip_range;

#undef BASE_STRUCT_FIELDS

static inline ip_u *base_ip_u(ip_range *ip) {return (ip_u*)ip;}
int my_inet_pton(char const *p, ip_u* u);
char const *my_inet_ntop(ip_u *ip_addr, char addr[INET6_ADDRSTRLEN]);
void first_in_range(unsigned char ip[16], int plen);


enum parse_ip_error
{
	parse_ip_ok = 0,
	parse_ip_invalid_too_high,
	parse_ip_invalid_too_long,
	parse_ip_invalid_separator,
	parse_ip_invalid_range,
	parse_ip_invalid_cidr,
	parse_ip_invalid_ipv6_1,
	parse_ip_invalid_ipv6_2
};

#define INET_RANGESTRLEN (INET6_ADDRSTRLEN + INET6_ADDRSTRLEN + 2)

int parse_ip_address(char *in, ip_range *out, char **term);
char const *snprint_range(char *buf, size_t bufsiz, ip_range const *ip);
char const *parse_ip_invalid_what(int err);
int range_ip(unsigned char const *ip1, unsigned char *ip2, unsigned sz);

#define IP_UTIL_H_INCLUDED
#endif
