/*
* percent_prob.h

Copyright (C) 2011 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/
#if ! defined PERCENT_PROB_H_INCLUDED

#include <stdlib.h>

static inline double percent_prob(int p)
/*
* Return the probability as a percentage, suitable for display
*/
{
	return 100.0 * (double)p / ((double)RAND_MAX);
}


#define PERCENT_PROB_H_INCLUDED
#endif
