/*
* Ipq Berkeley db Daemon  DEL - ibd-del
* written by ale in milano on 13 jan 2010
* display ipqbdb configuration

Copyright (C) 2010 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/
#include <stdio.h>
#include <stdlib.h>

#define __USE_BSD 1
// for u_int in db.h
#include <sys/types.h>

#include <db.h>
#include "config_names.h"
#include "dbstruct.h"

static const char debug_status[] =
#if !defined NDEBUG
	"en"
#else
	"dis"
#endif
	"abled";

int main()
{
	int major = 0, minor = 0;
	
	db_version(&major, &minor, NULL);
	
	printf("ipqbdb version " PACKAGE_VERSION "\n"
		"compiled with " DB_VERSION_STRING " (%smatched)\n",
		major == DB_VERSION_MAJOR && minor == DB_VERSION_MINOR? "": "NOT ");

	printf("#\n"
		"IPQBDB_DATABASE_PREFIX     " IPQBDB_DATABASE_PREFIX "\n"
		"IPQBDB_DATABASE_SUFFIX     " IPQBDB_DATABASE_SUFFIX "\n"
		"IPQBDB_DATABASE_NAME       " IPQBDB_DATABASE_NAME " recsize=%zu\n"
		"IPQBDB_WHITE_DATABASE_NAME " IPQBDB_WHITE_DATABASE_NAME " recsize=%zu\n"
		"IPQBDB_DESCR_DATABASE_NAME " IPQBDB_DESCR_DATABASE_NAME
			" recsize=%zu+descr\n"
		"IPQBDB_DESCR_MAX_LENGTH    %d\n"
		"IPQBDB_OPTION_FILE         " IPQBDB_OPTION_FILE "\n"
		"IPQBDB_PCRE_FILE           " IPQBDB_PCRE_FILE "\n"
		"IPQBDB_PARSE_SOCKET        " IPQBDB_PARSE_SOCKET "\n#\n",
		sizeof(ip_data_t),
		sizeof(ip_white_t),
		sizeof(bynumber_descr_t), IPQBDB_DESCR_MAX_LENGTH);

	printf(
		"RECENT_DROP_TIME %d\n"
		"UPDATE_TICK_TIME %d\n"
		"IPQBDB_INITIAL_DECAY %g\n"
		"IPQBDB_DECAY_ADDEND_ON_THRESHOLD %g\n"
		"IPQBDB_PROBABILITY_THRESHOLD %d (RAND_MAX %jd)\n"
		"IPQBDB_NEVER_DECAY %f\n#\n"
		"IPQBDB_DEBUG %s\n",
		RECENT_DROP_TIME,
		UPDATE_TICK_TIME,
		IPQBDB_INITIAL_DECAY,
		IPQBDB_DECAY_ADDEND_ON_THRESHOLD,
		IPQBDB_PROBABILITY_THRESHOLD, (intmax_t)RAND_MAX,
		IPQBDB_NEVER_DECAY,
		debug_status);

	return 0;
}

