/* log.c -- write logs
   Copyright (C) 2005 Angshuman Sarkar

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#define _POSIX_SOURCE

#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <sys/types.h>
#include "log.h"
#include "misc.h"
#include "user_iface.h"

void
lg_log_text (const char *user, contact_t *contact, const char *text, int len)
{
	int logfile, log_len;
	char *filename, *log_text;
	
	
	filename = home_path2 (".ipchat/log/", contact->nick);
	if (!filename)
		return;

	logfile = open (filename , O_CREAT | O_WRONLY | O_APPEND ,
	                S_IRUSR | S_IWUSR );
	
	if(logfile < 0)
	{
		ui_output_info ("Can't open log file %s", filename) ;
		free (filename);
		return ;
	}
	else
	{
		free (filename);
		log_len = len + strlen (user) + 4 ;
		log_text = (char *) malloc (log_len);
		if(!log_text)
		{
			ui_output_info ("Memory Allocation Failure in loggin");
			close (logfile);
			return ;
		}
		else
		{
			strcpy (log_text , user);
			strcat (log_text , ": ");
			strncat (log_text , text, len);
			strcat (log_text , "\n" );
			if (write (logfile, log_text , strlen(log_text)) < 0)
				;
			free (log_text);
		}
		close (logfile);
	}
}
