/* tls.h -- encryption and authentication code
   Copyright (C) 2006 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef TLS_H
#define TLS_H 1

#include <unistd.h>		/* size_t, ssize_t */
#include "contact.h"

/* Initialize TLS stuff. */
extern void tls_init (void);

/* Finish TLS stuff. */
extern void tls_finish (void);

/* Is TLS enabled? */
extern int tls_enabled (void);

/* Initialize TLS session for a connected contact. This involves no traffic
   at all, it only initializes the session structure, so tls_handshake()
   can be called later to "upgrade" the connection to SSL/TLS.
   Parameter 'server' indicates whether connection was initiated by us
   or by the peer. */
extern void tls_session_init (contact_t *contact, int server);

/* Release TLS session. If a handshake was performed, tls_session_finish()
   should be called first. */
extern void tls_session_deinit (contact_t *contact);

/* Finish TLS session. */
extern void tls_session_finish (contact_t *contact);

/* Begin or continue incomplete handshake. */
extern void tls_handshake (contact_t *contact);

/* Send data to contact. If TLS has not been initialized for the connection,
   data will be sent without encryption. */
extern ssize_t tls_send (contact_t *contact, const void *data, size_t size);

/* Receive data from contact. If TLS has not been initialized for the
   connection, data is not decrypted. */
extern ssize_t tls_recv (contact_t *contact, void *data, size_t size);

/* Output TLS session information. */
extern void tls_session_info (contact_t *contact);

#endif
