/* tcp.h -- wrapper to simplify the use of TCP sockets
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef TCP_H
#define TCP_H 1

#include "common.h"

/* Create a non-blocking socket connecting to ip:port (both in host order).
   When select() reports write availability, call tcp_connect_result() to
   see whether the connection was successful. This functions returns the file
   descriptor of the socket if the connection process begins successfully,
   and returns ERR on any error. */
extern sock_t tcp_connect (ip_t ip, port_t port);

/* Returns OK if the connection process of 'socket' was successful,
   otherwise it returns ERR. */
extern int tcp_connect_result (sock_t socket);

/* Create a non-blocking socket listening at the specified TCP port, on all
   interfaces. Returns the file descriptor on success, ERR on error. */
extern sock_t tcp_listen (port_t port);

/* Accept the next pending input connection request in 'socket'. Returns
   the connected socket and the originator IP in *pip, in host order.
   It returns ERR on error. */
extern sock_t tcp_accept (sock_t socket, ip_t *pip);

/* TODO I think we don't need these */
#if 0
/* Wrapper over write(), closes 'socket' and returns 0 if peer closed. */
extern int tcp_send (sock_t socket, const BYTE * buffer, int len);

/* Wrapper over read(), closes 'socket' and returns 0 if peer closed. */
extern int tcp_recv (sock_t socket, BYTE * buffer, int max_len);
#endif

#endif
