/* contact.h -- contact structure
   Copyright (C) 2006 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef CONTACT_H
#define CONTACT_H 1

#include "common.h"
#include "demux.h"

#define BROADCAST ((contact_t *)~0)	/* send something to all contacts */
#define MAX_HNAME 256			/* RFC 1035, limit is 255 (+ '\0') */

typedef enum { CS_OFFLINE = 0, CS_HELLO_PENDING, CS_HANDSHAKING,
               CS_CONNECTED } cn_st_t;

typedef struct ct {
	char    hname[MAX_HNAME]; 	/* IP or hostname of contact */
	port_t  port;			/* port where contact listens */
	char    nick[MAX_NICK];		/* nickname of the contact */
	struct ct *next;		/* next in contact list */
	struct {
		ip_t    ip;		/* current ip address of hname */
		sock_t  socket;		/* connecting/connected socket, or -1 */
		cn_st_t cn_state;	/* connection state */
		BYTE   *in_buffer;	/* input buffer */
		len_t   in_buf_size;	/* allocated mem AND bytes to recv */
		len_t   in_buf_rcvd;	/* received bytes */
		BYTE   *out_buffer;	/* output buffer */
		len_t   out_buf_size;	/* memory allocated AND bytes to send */
		/* TODO out_buf_sent not needed by now, see transport */
		timer_id hello_timeout;	/* timer for hello timeout */
		void   *ui_info;	/* user iface info */
		void   *tls_info;	/* auth and encryption info */
	} state;
} contact_t;

/* Tells whether connection is fully established. */
#define CT_IS_CONNECTED(c) ((c)->state.cn_state == CS_CONNECTED)

/* Allocate new contact and initialize members to null values. */
extern contact_t *ct_new_contact (void);

#endif
