/* user_iface.h -- the ncurses user interface
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef USER_IFACE_H
#define USER_IFACE_H 1

#include "contact_list.h"

/* Init module. Paint the interface for the first time. */
extern int ui_init ();

/* Close curses mode, free used memory. */
extern void ui_finish ();

/* Recreate the list of contacts. Create windows for connected contacts
   which don't have one. Call whenever a contact connects or disconnects. */
extern void ui_redraw_contacts ();

/* Redraw user's nick. Call when the nick changes. */
extern void ui_redraw_nick ();

/* Close window of contact. */
extern void ui_close_win (contact_t *contact);

/* Close current window. */
extern void ui_close_cur_win ();

/* Output a new message from a contact. */
extern void ui_output_msg (contact_t *contact, const char *txt, int len);

/* Output an information message. Works like printf. */
extern void ui_output_info (const char *fmt, ...);

/* Output an error message. Works like printf. */
extern void ui_output_err (const char *fmt, ...);

/* Output the same as perror(). */
extern void ui_perror (const char *txt);

/* Generate a beep. */
extern void ui_beep ();

/* Get contact on current window, NULL if none. */
extern contact_t *ui_current_contact ();

#endif
