<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


$path = dirname(__FILE__) . "/";

include $path . "../config/config_igloo.inc.php";
include $path . "../inc/functions.inc.php";

// SETUP DATABASE -----------------------------------------------------------------------
require_once($path . '../class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
if ($db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db'])) {
	$db->prefix = $c_node['db']['prefix'];
	
	//select pending users who registered over 24 hours ago
	$yesterday = date("Y-m-d h:i:s", time() - (24*60*60));
	$yesterday = $db->DBDate($yesterday);
	
	//write to log file
	if (isset($GLOBALS['igloo_log']) && $GLOBALS['igloo_log'] == true) {
		$query = "
			SELECT user_email FROM " . $db->prefix . "_user 
			WHERE
			status_id=" . $c_node['user']['status']['pending'] . " AND 
			user_create_datetime<=" . $yesterday
		;
		
		$result = $db->Execute($query);
		
		$log = "";
		
		while (!$result->EOF) {
			$log .= $result->fields['user_email'] . "\n";
			
			$result->MoveNext();
		}
		
		if (!empty($log)) {
			
			$log = "The following pending users where deleted from the database at " . date("Y-m-d h:i:s") . "\n" . $log;
		}
		writeLogFile($log, "../");
	}
	
	// delete pending users
	$query = "
		DELETE FROM " . $db->prefix . "_user 
		WHERE
		status_id=" . $c_node['user']['status']['pending'] . " AND 
		user_create_datetime<=" . $yesterday
	;
	
	$result = $db->Execute($query);
	
	$db->Close();
}

?>