<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "my";
include "inc/header.inc.php";

if (!isset($me['user_id']) || $me['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

// SETUP LANGUAGE --------------------------------------------------------
require_once($languageArrayPath . 'arr_user.lang.php');


if (!empty($frmdata)) {
	
	if (empty($_POST['message_ids'])) {
		$_POST['message_ids'][] = $_POST['message_id'];
	}
	
	if (!empty($frmdata['mark_read'])) {
		$im->setMessagesStatus($_POST['message_ids'], $im->getStatus("read"));
		header("Location: msg_view.php?".$_SERVER["QUERY_STRING"] . "&" . strip_tags(SID));
		exit;
	}
	elseif (!empty($frmdata['mark_unread'])) {
		$im->setMessagesStatus($_POST['message_ids'], $im->getStatus("unread"));
		header("Location: msg_view.php?".$_SERVER["QUERY_STRING"] . "&" . strip_tags(SID));
		exit;
	}
	elseif (!empty($frmdata['move_save'])) {
		$im->moveToSavebox($_POST['message_ids']);
		header("Location: msg_view.php?".$_SERVER["QUERY_STRING"] . "&" . strip_tags(SID));
		exit;
	}
	elseif (!empty($frmdata['delete'])) {
		$im->deleteMessages($_POST['message_ids']);
		header("Location: msg_view.php?". $_SERVER["QUERY_STRING"] . "&" . strip_tags(SID));
		exit;
	}
}


if (isset($_REQUEST['message_id'])) {
	// Setting statistics
	$im->setStatistics();
	$output_message_statistics = $im->getStatistics();


	//setup Wiki
	require_once('class/Wiki/Wiki.php');
	$wiki = new Text_Wiki();
	$wiki->disableRule('freelink');
	$wiki->disableRule('wikilink');
	$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');
	
	$message = new Message($db, $_REQUEST['message_id']); // create message

	// Getting the status from "query_string"....
	if (isset($_REQUEST['set_unread_messages'])) {
		$status = $c_node['messaging']['message_status_unread'];
	}
	else {
		$status = $c_node['messaging']['message_status_read'];
	}
	
	$message->user_id = $me['user_id'];

	$message->setStatus($status);                    // set status of the message
	$message->setBoxes($c_node['messaging']['message_in_box'], $c_node['messaging']['message_save_box'], $c_node['messaging']['message_out_box']);
	$output_message = $message->getMessage();        // get message

	
	$output_message['message_body'] = $wiki->transform($output_message['message_body'], 'Xhtml');
	
	$output_author = $user->selProfile($output_message['from_user_id']);
	
	//setup file
	$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	
	//setup file
	if (isset($output_author['file_id'])) {
		$file->file_id = $output_author['file_id'];
		$output_author['image'] = $file->getFileRecord();
	}
	
	
	//if the messge type = 2 then we rebuid the social network as a friend has joined you
	if (isset($output_message['message_type']) && $output_message['message_type'] == 2) {
		//setup social network
		require_once('class/SocialNetwork.class.php');
		$sn = new Socialnetwork($me['user_id'], $db);
		$sn->relation_type_ids = $c_node['user']['relation_type'];
		$sn->status_ids = $c_node['user']['status'];
		$_SESSION['relations'] = $sn->selRelations($me['user_id']);
		// recompute 
		$total = count($me['relations']);
		
		if (empty($total)) {
			$total = 0;
		}
			
		if ($c_node['batch']['enabled'] == true) {
			//flag for batch processing
			$sn->updateSnStatistic(1, $total, 1);
		}
		else {
			//reset degree 1 stats
			$sn->updateSnStatistic(1, $total, null);
		}
	}
}
else { //list
	// Handling message box requests
	if (isset($_REQUEST['out_box'])) {
		$message_box = "out_box";
	}
	elseif (isset($_REQUEST['save_box'])) {
		$message_box = "save_box";
	}
	else {
		$message_box = "in_box";
	}
	
	// Get the listing of the requested message box
	$output_messages = $im->getMessageBox($message_box);
	
	// Setting statistics
	$im->setStatistics();
	
	// Getting statistics
	$output_message_statistics = $im->getStatistics();
	
	$display = "list";
}



//move to template
if (isset($display)) {
    $body->set('display', $display);
}

if (isset($output_message)) {
    $body->set('message', $output_message);
}

if(isset($output_message["message_box"])) {
	$body->set('message_box', $message->getMessageBox($output_message["message_box"]) );
	$tpl->set('message_box', $message->getMessageBox($output_message["message_box"]) );
}

//move to template
if (!empty($output_author)) {
    $body->set('author', $output_author);
}

if (!empty($_REQUEST['view'])) {
	$body->set('view', $_REQUEST['view']);
}

if (!empty($output_messages)) {
    $body->set('messages', $output_messages);
}

if (!empty($output_message_statistics)) {
    $body->set('message_statistics', $output_message_statistics);
}

if (!empty($message_box)) {
    $body->set('message_box', $message_box);
	$tpl->set('message_box', $message_box);
}

$body->set('message_status_read', $c_node['messaging']['message_status_read']);
$body->set('message_status_unread', $c_node['messaging']['message_status_unread']);

$template_pageLink = "message";
include "inc/footer.inc.php";

?>
