<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>
		
<div class="col_main">
	<?php
	if (isset($image)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_image'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td valign="top" colspan="2" align="center">
							<img src="get_file.php?file=<?php echo $image['file'];?>" border="0" class="picture" /></a><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $image['file_title'];?> (<?php echo $image['file_name'];?>.<?php echo $image['file_suffix'];?>)<br />
						</td>
						<td valign="top" align="right">
							<a href="fil_edit.php?file_id=<?php echo $image['file_id'];?>"><?php echo $lang['href_edit'];?></a><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_images'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($images)) {
				$images_per_row = 6;
				$r = 0;
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<tr>
						<td>
							<table border="0" cellspacing="0" cellpadding="2">
								<tr>
									<?php
									foreach($images as $key => $i):
									?>
				
									<td valign="top">
										<a href="fil_view.php?file_id=<?php echo $i['file_id'];?>"><img src="get_file.php?file=<?php echo $i['file']; ?>" border="0" class="picture" /></a><br />
									</td>
				
									<?php
									$r++;
									if ($r == $images_per_row) {
										echo "</tr><tr>";
										$r=0;
									}
				
									endforeach;
									if ($r != $images_per_row) {
										$r = $images_per_row-$r;
										print "<td colspan=" . $r . "><br /></td>";
									}
									?>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_files'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					if (isset($files)) {
					foreach($files as $i): ?>
					<tr>
						<td valign="top" width="1%">
							<a href="fil_view.php?file_id=<?php echo $i['file_id'];?>"><?php formatFileOutput($i, "thumb");?></a><br />
						</td>
						<td valign = "top">
							<a href="fil_view.php?file_id=<?php echo $i['file_id'];?>"><?php echo $i['file_title'];?></a><br />
						</td>
						<td valign = "top">
							<?php echo $i['file_name'];?>.<?php echo $i['file_suffix'];?><br />
						</td>
						<td valign="top" align="right">
							<a href="fil_edit.php?file_id=<?php echo $i['file_id'];?>"><?php echo $lang['href_edit'];?></a><br />
						</td>
					</tr>
					<?php
					endforeach;
					}
					else {
					?>
					<tr>
						<td>
							<?php echo $lang['err_no_files'];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_storage'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<tr>
						<td valign="top">
							<?php echo $lang['txt_storage_allowed'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['txt_storage_total'];?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo round($storage['allocation']/1000) . $lang['txt_kilobyte']; ?><br />
						</td>
						<td valign="top">
							<?php echo round($storage['allocation_used']/1000, 2) . $lang['txt_kilobyte']; ?><br />
						</td>
					</tr>
					<?php
					if (isset($storage['allocation'])) {
					?>
					<tr>
						<td valign="top" colspan="2">
							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr>
									<td width="<?php echo $percentage_used;?>%" class="bg1">
										<img src=<?php echo $templatePath;?>img/pixel.png width="1" height="7" alt="" /><br />
									</td>
									<td width="<?php echo $percentage_unused;?>%" class="bg2">
										<img src=<?php echo $templatePath;?>img/pixel.png width="1" height="7" alt="" /><br />
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<?php }?>
					<tr>
						<td colspan="2" align="right">
							<?php
							if (isset($allow_file_add)) {
							?>
							<a href="fil_edit.php" class="link_stnd"><?php echo $lang['href_add'];?></a>
							<?php
							}
							else {
								echo $lang['txt_storage_no_add'];
							}
							?>
							<br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
</form>
