<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "structure";
include "inc/header.inc.php";


//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_rsp'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}



//append language setup
require_once($languageArrayPath . 'arr_rsp.lang.php');


//setup rsp
require_once('class/Rsp.class.php');
$rsp = new Rsp($db, null);

if (isset($_REQUEST['level_id'])) {
    $level_id = $_REQUEST['level_id'];
}
else {
	$level_id = $c_node['rsp']['rsp_level']['node'];
}


if (!empty($_REQUEST['status_id']) && $_REQUEST['status_id'] > 0) {
    $status_id = $_REQUEST['status_id'];
	$rsp->rsp_status_id = $status_id;
}
else {
	unset($status_id);
}

if (!empty($_REQUEST['featured'])) {
    $rsp->rsp_featured = 1;
}


if(isset($_REQUEST['search'])) {
	//change level
	$level_id = $_REQUEST['level_id'];
	unset($frmdata);
}

$rsp->level_id = $level_id;



//get subject ids -----------------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
if (isset($frmdata['subject_status'])) {
	foreach($frmdata['subject_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_subject_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			$subject_sticky = false;
			if (isset($frmdata['subject_sticky'][$key])) {
				$subject_sticky = true;
			}
			
			$subject_featured = false;
			if (isset($frmdata['subject_featured'][$key])) {
				$subject_featured = true;
			}
			
			$rsp->updateRspItem($i, $subject_sticky, $subject_featured);
		}
	endforeach;
	
	if (isset($arr_subject_delete)) {
	    $rsp->deleteRspItems($arr_subject_delete);
	}
}
$output_rsp_subjects = $rsp->selRspItems();
foreach($output_rsp_subjects as $key => $i):
	$rsp_subject_ids[] = $i['item_id'];
endforeach;

//get group blog ids -----------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
if (isset($frmdata['blog_status'])) {
	foreach($frmdata['blog_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_blog_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			$blog_sticky = false;
			if (isset($frmdata['blog_sticky'][$key])) {
				$blog_sticky = true;
			}
			
			$blog_featured = false;
			if (isset($frmdata['blog_featured'][$key])) {
				$blog_featured = true;
			}
			
			$rsp->updateRspItem($i, $blog_sticky, $blog_featured);
		}
	endforeach;
	
	if (isset($arr_blog_delete)) {
	    $rsp->deleteRspItems($arr_blog_delete);
	}
	
}
$output_rsp_blogs = $rsp->selRspItems();
foreach($output_rsp_blogs as $key => $i):
	$rsp_blog_ids[] = $i['item_id'];
endforeach;

//get user library item ids --------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
if (isset($frmdata['library_item_status'])) {
	foreach($frmdata['library_item_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_library_item_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			$library_item_sticky = false;
			if (isset($frmdata['library_item_sticky'][$key])) {
				$library_item_sticky = true;
			}
			
			$library_item_featured = false;
			if (isset($frmdata['library_item_featured'][$key])) {
				$library_item_featured = true;
			}
			
			$rsp->updateRspItem($i, $library_item_sticky, $library_item_featured);
		}
	endforeach;
	
	if (isset($arr_library_item_delete)) {
	    $rsp->deleteRspItems($arr_library_item_delete);
	}
	
}
$output_rsp_library_items = $rsp->selRspItems();
foreach($output_rsp_library_items as $key => $i):
	$rsp_library_ids[] = $i['item_id'];
endforeach;

//get file ids --------------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['file'];
if (isset($frmdata['file_status'])) {
	foreach($frmdata['file_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_file_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			$file_sticky = false;
			if (isset($frmdata['file_sticky'][$key])) {
				$file_sticky = true;
			}
			
			$file_featured = false;
			if (isset($frmdata['file_featured'][$key])) {
				$file_featured = true;
			}
			
			$rsp->updateRspItem($i, $file_sticky, $file_featured);
		}
	endforeach;
	
	if (isset($arr_file_delete)) {
	    $rsp->deleteRspItems($arr_file_delete);
	}
}
$output_rsp_files = $rsp->selRspItems();
foreach($output_rsp_files as $key => $i):
	$rsp_file_ids[] = $i['item_id'];
endforeach;

//get poll ids ---------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
if (isset($frmdata['poll_status'])) {
	foreach($frmdata['poll_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_poll_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			$poll_sticky = false;
			if (isset($frmdata['poll_sticky'][$key])) {
				$poll_sticky = true;
			}
			
			$poll_featured = false;
			if (isset($frmdata['poll_featured'][$key])) {
				$poll_featured = true;
			}
			
			$rsp->updateRspItem($i, $poll_sticky, $poll_featured);
		}
	endforeach;
	
	if (isset($arr_poll_delete)) {
	    $rsp->deleteRspItems($arr_poll_delete);
	}
}
$output_rsp_polls = $rsp->selRspItems();
if (!empty($output_rsp_polls)) {
	foreach($output_rsp_polls as $key => $i):
		$rsp_poll_ids[] = $i['item_id'];
	endforeach;
}

//get schedule ids ---------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
if (isset($frmdata['schedule_status'])) {
	foreach($frmdata['schedule_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_schedule_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			$schedule_sticky = false;
			if (isset($frmdata['schedule_sticky'][$key])) {
				$schedule_sticky = true;
			}
			
			$schedule_featured = false;
			if (isset($frmdata['schedule_featured'][$key])) {
				$schedule_featured = true;
			}
			
			$rsp->updateRspItem($i, $schedule_sticky, $schedule_featured);
		}
	endforeach;
	
	if (isset($arr_schedule_delete)) {
	    $rsp->deleteRspItems($arr_schedule_delete);
	}
}
$output_rsp_activities = $rsp->selRspItems();
foreach($output_rsp_activities as $key => $i):
	$rsp_schedule_ids[] = $i['item_id'];
endforeach;

//get channel ids ---------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['channel'];
if (isset($frmdata['channel_status'])) {
	foreach($frmdata['channel_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_channel_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			$channel_sticky = false;
			if (isset($frmdata['channel_sticky'][$key])) {
				$channel_sticky = true;
			}
			
			$channel_featured = false;
			if (isset($frmdata['channel_featured'][$key])) {
				$channel_featured = true;
			}
			
			$rsp->updateRspItem($i, $channel_sticky, $channel_featured);
		}
	endforeach;
	
	if (isset($arr_channel_delete)) {
	    $rsp->deleteRspItems($arr_channel_delete);
	}
}
$output_rsp_channels = $rsp->selRspItems();
foreach($output_rsp_channels as $key => $i):
	$rsp_channel_ids[] = $i['item_id'];
endforeach;


//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup forum
require_once('class/Forum.class.php');
$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $file);
$forum->rsp_level_id = $level_id;
if (isset($status_id)) {
	$forum->rsp_status_id = $status_id;
}
$output_subjects = $forum->selSubjects();


//setup blog
require_once('class/Blog.class.php');
$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $file);
$blog->rsp_level_id = $level_id;
if (isset($status_id)) {
	$blog->rsp_status_id = $status_id;
}
$output_blogs = $blog->selBlogs();


//library setup
require_once('class/Library.class.php');
$library = new Library($db, $c_node['rsp']['item_type']['library'], $file);
$library->rsp_level_id = $level_id;
if (isset($status_id)) {
	$library->rsp_status_id = $status_id;
}
$output_library_items = $library->selLibraryItems();


//schedule setup
require_once('class/Schedule.class.php');
$schedule = new Schedule($db, $c_node['rsp']['item_type']['schedule'], $date, $file);
$schedule->rsp_level_id = $level_id;
$schedule->schedule_config = $c_node['schedule'];
if (isset($status_id)) {
	$schedule->rsp_status_id = $status_id;
}
$output_activities = $schedule->selScheduleItems();


// poll setup
require_once('class/Poll.class.php');
$poll = new Poll($db, $c_node['rsp']['item_type']['poll']);
$poll->rsp_level_id = $level_id;
if (isset($status_id)) {
	$poll->rsp_status_id = $status_id;
}
$output_polls = $poll->selPolls();


// channel setup
require_once('class/Channel.class.php');
$channel = new Channel($db);
$channel->rsp_item_type_id = $c_node['rsp']['item_type']['channel'];
$channel->rsp_level_id = $level_id;
if (isset($status_id)) {
	$channel->rsp_status_id = $status_id;
}
$output_channels = $channel->selChannels();


//move to template
if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
	$body->set('rsp_blogs', $output_rsp_blogs);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
	$body->set('rsp_subjects', $output_rsp_subjects);
}

if (!empty($output_library_items)) {
	$body->set('library_items', $output_library_items);
	$body->set('rsp_library_items', $output_rsp_library_items);
}

if (!empty($output_activities)) {
	$body->set('activities', $output_activities);
	$body->set('rsp_activities', $output_rsp_activities);
}

if (!empty($output_files)) {
	$body->set('files', $output_files);
	$body->set('rsp_files', $output_rsp_files);
}

if (!empty($output_channels)) {
	$body->set('channels', $output_channels);
	$body->set('rsp_channels', $output_rsp_channels);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
	$body->set('rsp_polls', $output_rsp_polls);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (isset($status_id)) {
    $body->set('status_id', $status_id);
}

if (isset($level_id)) {
    $body->set('level_id', $level_id);
}

$body->set('level_node', $c_node['rsp']['rsp_level']['node']);
$body->set('level_public', $c_node['rsp']['rsp_level']['public']);

include "inc/footer.inc.php";
?>
