<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
// Tom Calthrop (info@barnraiser.org)


// RELEASE NOTES --------------------------------------------------
$c_node['release']['version'] = 				"0.1.5";
$c_node['release']['release_date'] = 			"01-03-2006"; // MM-DD-YYYY
$c_node['release']['install_date'] = 			""; // MM-DD-YYYY


//DATABASE CONFIGURATION --------------------------------------------------
$c_node['db']['driver'] = 						"mysql";
$c_node['db']['host'] = 						"localhost";
$c_node['db']['user'] = 						"your_db_username";
$c_node['db']['pass'] = 						"your_db_password";
$c_node['db']['db']=	 						"your_db_name";
$c_node['db']['prefix'] =	 					"igloo";


// MAIL CONFIGURATION ----- ----------------------------------------------
// phpMailer. See http://phpmailer.sourceforge.net/ for settings.
$c_node['mail']['host'] = 						"your_mail_server.com";
$c_node['mail']['port'] = 						"25";
$c_node['mail']['no_reply_address'] = 			"nopreply@your_mail.org";
$c_node['mail']['default_address'] = 			"you@your_mail.org";
$c_node['mail']['mailer'] = 					"smtp";
$c_node['mail']['from_name'] = 					"company_name";
$c_node['mail']['wordwrap'] = 					"80";
//if you need a username and password to access SMTP then uncomment these
// and add your username and password
//$c_node['mail']['smtp']['username'] = 		"your_mailserver_username";
//$c_node['mail']['smtp']['password'] = 		"your_mailserver_password";


// PHP CONFIGURATION -----------------------------------------------------
//ini_set('error_reporting', E_ALL); 			// error handling in development environment.
ini_set('error_reporting', 0); 					// error handling in production environment
ini_set('session.gc_maxlifetime', '2880');		//length of session time


// NODE CONFIGURATION ----------------------------------------------------
$c_node['node']['template_default_name'] = 		"barnraiser_01";
$c_node['node']['template_default_id'] = 		"1";
//debug mode - set to 1 to see database error etc, null just returns user errors
$c_node['node']['debug_mode'] = 				"1";
// do you want users to be able to register for this node? (0=off, 1=on)
$c_node['node']['allow_registration'] = 		"1";
// do you want users to be able to invite others when they register? (0=off, 1=on)
$c_node['node']['allow_setup_invites'] = 		"1";
// do you want users to be able to retrieve a new password for this node? (0=off, 1=on)
$c_node['node']['allow_new_password'] = 		"1";
//default home page (inserted in DB upon registration
$c_node['node']['page_default'] = 				"spl_view.php";
// local path to assets directory-"/public_html/asset/"
$c_node['dir']['asset_path'] = 					"../asset/";
// set to true to write to log file / false not to.
$c_node['log'] = 								false;
// batch processing: set to true if used (false if not)
$c_node['batch']['enabled'] = 					false;
//When batch processing urls we append the following url
$c_node['node']['url'] = 						"http://your_url/igloo/";


// BATCH CONFIGURATION ----------------------------------------------------
// newsletter config
$c_node['newsletter']['type']['node'] = 			"1";  // node-members
$c_node['newsletter']['type']['event'] = 			"3";  // event
$c_node['newsletter']['type']['role'] = 			"4";  // role
$c_node['newsletter']['type']['node_pending'] = 	"5";  // node-pending-members
$c_node['newsletter']['type']['node_invited'] = 	"6";  // node-invited
$c_node['newsletter']['type']['digest'] = 			"7";  // digest

$c_node['newsletter']['nr_per_batch'] = 			"20";  // number of emails to be sent per batch


// LANGUAGE CONFIGURATION ---------------------------------------------------
// list within the array the language ID's available to this node.check
// you have the language files installed before extending this.
$c_node['node']['language']['default'] = 			"1"; //English, the default node language
$c_node['node']['language']['pack'][1] = 			array('eng', 'en'); //UK (real) English /aspell lang

// DICTIONARY CONFIGURATION ------------------------------------------------
// if Aspell is installed you can configure Igloo to show a spellchecker button
// standard aspell installs are either:
// WINDOWS -> '"C:\Program Files\Aspell\bin\aspell.exe"'(use the double quotes inside the single quotes)
// GNU/Linux -> "/usr/local/bin/aspell"
// Leave the command blank "" to tell Igloo NOT TO show shellchecker
$c_node['node']['language']['aspell']['command'] = 	'"C:\Program Files\Aspell\bin\aspell.exe"';


// FILE CONFIGURATION ----------------------------------------------------
$c_node['file']['default_max_user_space'] = 		"5000";


// MIME CONFIGURATION ----------------------------------------------------
//full list at http://www.phpfreaks.com/mimetypes.php
//make sure you think about the implications for viruses before editing this
//edit the functions.inc.php formatFileOuptput functions to create correct html output
$c_node['file']['mime'][1]['mime'] = 				"image/jpeg";
$c_node['file']['mime'][1]['suffix'] = 				"jpg";
$c_node['file']['mime'][2]['mime'] = 				"image/png";
$c_node['file']['mime'][2]['suffix'] = 				"png";
$c_node['file']['mime'][3]['mime'] = 				"image/gif";
$c_node['file']['mime'][3]['suffix'] = 				"gif";
$c_node['file']['mime'][4]['mime'] = 				"application/pdf";
$c_node['file']['mime'][4]['suffix'] = 				"pdf";
$c_node['file']['mime'][5]['mime'] = 				"text/plain";
$c_node['file']['mime'][5]['suffix'] = 				"txt";
//image and thumbs
$c_node['file']['image']['max_width'] = 			"500"; //main image
$c_node['file']['image']['thumb_directory'] = 		"thumbs/";
$c_node['file']['image']['thumb'][1]['name'] =		"t1";
$c_node['file']['image']['thumb'][1]['noimage'] =	"no_file_t1.png";
$c_node['file']['image']['thumb'][1]['width'] =		"158";
$c_node['file']['image']['thumb'][2]['name'] =		"t2";
$c_node['file']['image']['thumb'][2]['width'] =		"80";
$c_node['file']['image']['thumb'][2]['noimage'] =	"no_file_t2.png";
$c_node['file']['image']['thumb'][3]['name'] =		"t3";
$c_node['file']['image']['thumb'][3]['width'] =		"32";
$c_node['file']['image']['thumb'][3]['noimage'] =	"no_file_t3.png";
//name of "broken image" image is displayed if the file cannot be found
$c_node['file']['image']['broken_image'] =			"broken_image.png";

//sometimes MIME types vary from browser to browser - this array will convert
//other MIME types to those listed above
// add an array for each instance of the MIME types you want changing
$c_node['file']['mime']['browser_path'] =			array(array("from" => "image/pjpeg", "to" => "image/jpeg"));


// MESSAGING CONFIGURATION ----------------------------------------------
$c_node['messaging']['message_box_max_size'] = 		"10000";
$c_node['messaging']['message_in_box'] = 			"1";
$c_node['messaging']['message_out_box'] = 			"2";
$c_node['messaging']['message_save_box'] = 			"3";
$c_node['messaging']['message_status_unread'] = 	"1";
$c_node['messaging']['message_status_read'] = 		"2";


// SOCIAL NETWORK CONFIGURATION -----------------------------------------
$c_node['sn']['max_degree'] = 						"3";


// RPS CONFIGURATION ----------------------------------------------------
// zero = needs editorial approval, 1 = auto publish to splash
$c_node['rsp']['node']['auto_publish'] = 			"1";
// content types (edit DB queries in rsp class if appending)
$c_node['rsp']['item_type']['blog'] = 				"1";
$c_node['rsp']['item_type']['library'] = 			"2";
$c_node['rsp']['item_type']['file'] = 				"3";
$c_node['rsp']['item_type']['schedule'] = 			"4";
$c_node['rsp']['item_type']['forum'] = 				"5";
$c_node['rsp']['item_type']['poll'] = 				"6";
$c_node['rsp']['item_type']['channel'] = 			"7";
$c_node['rsp']['item_type']['network'] = 			"8";
// rsp content status's
$c_node['rsp']['status']['live'] = 					"3";
$c_node['rsp']['status']['hold'] = 					"2";
$c_node['rsp']['status']['pending'] = 				"1";
// number of days to display content historically (increase on less busy installs)
$c_node['rsp']['publishing']['most_read'] = 		"14";
//Abuse report default level ID from an unallocated abuse report
$c_node['rsp']['abuse_status']['unallocated'] = 	"2";
//we have a rsp for both the node and the group (home page)
$c_node['rsp']['rsp_level']['public'] = 			"64";
$c_node['rsp']['rsp_level']['node'] = 				"32";
$c_node['rsp']['rsp_level']['degree'] = 			"16";


// STATISTIC CONFIGURATION ----------------------------------------------
$c_node['statistic']['user']['total_logins'] = 		"1";
$c_node['statistic']['user']['total_blogs'] = 		"2";
$c_node['statistic']['user']['total_shouts'] = 		"3";
$c_node['statistic']['user']['total_polls'] = 		"4";
$c_node['statistic']['user']['total_library_items'] = "5";
$c_node['statistic']['user']['total_forum_subjects'] = 	"6";
$c_node['statistic']['user']['total_comments'] = "7";
$c_node['statistic']['user']['total_votes'] = 		"8";
//group statistics
$c_node['statistic']['group']['total_members'] = 	"101";
$c_node['statistic']['group']['total_forum_subjects'] = "102";
$c_node['statistic']['group']['total_comments'] = 	"103";
$c_node['statistic']['group']['total_library_items'] = 	"104";
$c_node['statistic']['group']['total_polls'] = 		"105";
$c_node['statistic']['group']['total_blogs'] = 		"106";


// USER CONFIGURATION --------------------------------------------------
// relationship type
$c_node['user']['relation_type']['approved'] = 		"2";
$c_node['user']['relation_type']['approval_pending'] = "1";
// user status (pending means they have registered by not setup)
$c_node['user']['status']['inactive'] = 			"1";
$c_node['user']['status']['hold'] = 				"2";
$c_node['user']['status']['pending'] = 				"3";
$c_node['user']['status']['active'] = 				"4";

// user preferences
$c_node['user']['preference']['email_message'] = 	"1";
$c_node['user']['preference']['digest_newsletter'] = "2";
$c_node['user']['preference']['show_in_directory'] = "3";



// SCHEDULE CONFIGURATION ---------------------------------------------------
// schedule = events and tasks
$c_node['schedule']['type']['event'] = 				"1";
$c_node['schedule']['type']['task'] = 				"2";

$c_node['schedule']['allocation_status']['pending'] = "1";
$c_node['schedule']['allocation_status']['confirmed'] = "2";
$c_node['schedule']['allocation_status']['rejected'] = "3";
$c_node['schedule']['allocation_status']['withdrawn'] = "4";

$c_node['schedule']['occurrence']['no_repeat'] = 	"0";
$c_node['schedule']['occurrence']['daily'] = 		"1";
$c_node['schedule']['occurrence']['weekly'] = 		"3";
$c_node['schedule']['occurrence']['monthly'] = 		"9";
$c_node['schedule']['occurrence']['yearly'] = 		"12";

$c_node['schedule']['status']['tentative'] = 		"1";
$c_node['schedule']['status']['confirmed'] = 		"2";
$c_node['schedule']['status']['cancelled'] = 		"3";


// BOOKMARK CONFIGURATION --------------------------------------------------
$c_node['bookmark']['type']['watch'] = 				"1";
$c_node['bookmark']['type']['recommend'] = 			"2";


// TAGGING CONFIGURATION --------------------------------------------------
$c_node['tag']['level']['recommended'] = 			"1";


//RSS CONFIGURATION --------------------------------------------------------
// options: "RSS2.0" for RSS 2.0, "RSS1.0" for RSS 1.0, "RSS0.91" for
// RSS 0.91, "PIE0.1" for PIE 0.1, "MBOX" for Unix mbox, "OPML" for OPML
// 1.0, "ATOM0.3" for ATOM 0.3, "HTML" for HTML, "JAVASCRIPT" for Javascript
$c_node['rss']['output'] = 							"RSS2.0";


//DISPLAY CONFIGURATION ----------------------------------------------------
$c_node['display']['max_list_rows'] = 				"25";


// END OF FILE -------------------------------------------------------------
?>
