<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="search.php" method="post">

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_search'];?><br />
	</div>

	<div class="box_mid">
		<div class="content">
			<table width="100%" cellpadding="2" cellspacing="2" border="0">
				<tr>
					<td>
						<?php echo $lang['txt_search_basic_intro'];?><br />
					</td>
				</tr>
				<tr>
					<td>
						<div class="box_edit">
						<table cellpadding="2" cellspacing="0" border="0" width="100%">
							<tr>
								<td width="70%">
									<?php
									$tags = "";
									
									if (isset($item_tags)) {
										echo "<b>" . $lang['txt_tag'] . "</b><br />";
										foreach ($item_tags as $key => $i):
											$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
											
											//mark my tags
											if (isset($my_tags)) {
												foreach ($my_tags as $key1 => $mt):
													if ($i['tag_body'] == $mt['tag_body']) {
														$tags .= "*";
														break;
													}
												endforeach;
											}
											
											if (count($item_tags) > $key+1) {
												$tags .= ", ";
											}
										endforeach;
									}
									
									echo $tags;
									?>
								</td>
								<td width="30%">
									<b><?php echo $lang['txt_search'];?></b><br />
									
									<input type="text" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
									<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="checkbox" /><br />
								</td>
							</tr>
						</table>
						</div>
					</td>
				</tr>
			</table>

			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />

			<?php
			if (isset($search_text)) {
			?>
			<table width="100%" cellpadding="0" cellspacing="4" border="0">
				<tr>
					<td>
						<?php echo $lang['txt_search_results'];?><br />
					</td>
				</tr>
			</table>
			<?php }?>



			<?php
			if (isset($blogs)) {
			?>
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
			<span class="txt_item_title">
				<?php echo $lang['hdr_blogs'];?><br />
			</span>
			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<?php
				foreach($blogs as $key => $i):
				?>
				<tr>
					<td>
						<table width="100%" cellpadding="2" cellspacing="0" border="0">
							<tr>
								<td width="3" valign="top" rowspan="2">
									<img src="<?php echo $templatePath;?>img/dot.png" width="3" height="9" alt="" /><br />
								</td>
								<td>
									<?php
									$url = "blg_view.php?blog_id=" . $i['blog_id'];
									?>
									<a href="<?php echo $url;?>"><?php echo $this->date->formatDate($i['blog_create_datetime']);?></a><br />
								</td>
							</tr>
							<tr>
								<td>
									<b><?php echo $i['blog_title'];?></b><br />
									<?php echo dots(200, $i['blog_synopsis']);?><br />
								</td>
							</tr>
							<tr>
								<td>
									<br />
								</td>
								<td>
									<?php echo $lang['txt_tag'];?>: 
	
									<?php
									$tags = "";
									if (isset($i['tags'])) {
										foreach ($i['tags'] as $keyt => $t):
											$tags .= $t['tag_body'];
											
											if (count($i['tags']) > $keyt+1) {
												$tags .= ", ";
											}
										endforeach;
										$tags = searchTextFormat($tag, $tags);
										echo $tags;
									}
									?>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
					</td>
				</tr>
				<?php
				endforeach;
				?>
			</table>
			<?php }?>


			<?php
			if (isset($subjects)) {
			?>
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
			<span class="txt_item_title">
				<?php echo $lang['hdr_subjects'];?><br />
			</span>
			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<?php
				foreach($subjects as $key => $i):
				?>
				<tr>
					<td>
						<table width="100%" cellpadding="2" cellspacing="0" border="0" class="table_nested">
							<tr>
								<td width="3" valign="top" rowspan="2">
									<img src="<?php echo $templatePath;?>img/dot.png" width="3" height="9" alt="" /><br />
								</td>
								<td>
									<?php
									$url = "frm_view.php?subject_id=" . $i['subject_id'];
									?>
									<a href="<?php echo $url;?>"><?php echo $this->date->formatDate($i['subject_create_datetime']);?></a><br />
								</td>
							</tr>
							<tr>
								<td>
									<?php echo $i['subject_title'];?><br />
									<?php echo $i['subject_synopsis'];?><br />
								</td>
							</tr>
							<tr>
								<td>
									<br />
								</td>
								<td>
									<?php echo $lang['txt_tag'];?>: 
									
									<?php
									$tags = "";
									if (isset($i['tags'])) {
										foreach ($i['tags'] as $keyt => $t):
											$tags .= $t['tag_body'];
											
											if (count($i['tags']) > $keyt+1) {
												$tags .= ", ";
											}
										endforeach;
										$tags = searchTextFormat($tag, $tags);
										echo $tags;
									}
									?>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
					</td>
				</tr>
				<?php
				endforeach;
				?>
			</table>
			<?php }?>


			<?php
			if (isset($polls)) {
 			?>
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
			<span class="txt_item_title">
				<?php echo $lang['hdr_polls'];?><br />
			</span>
			<table border="0" cellspacing="4" cellpadding="0" width="100%">
 				<?php
 				foreach($polls as $key => $i):
 				?>
 				<tr>
 					<td valign="top">
 						<?php
						$poll_url = "pol_view.php?poll_id=" . $i['poll_id'];
						
						$poll = $i;
 						include $templatePath . "poll.inc.tpl.php";
 						?>
 					</td>
 			    </tr>
				<tr>
					<td>
						<?php echo $lang['txt_tag'];?>: 

						<?php
						$tags = "";
						if (isset($i['tags'])) {
							foreach ($i['tags'] as $keyt => $t):
								$tags .= $t['tag_body'];
								
								if (count($i['tags']) > $keyt+1) {
									$tags .= ", ";
								}
							endforeach;
							$tags = searchTextFormat($tag, $tags);
							echo $tags;
						}
						?>
					</td>
				</tr>
				<tr>
					<td>
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
					</td>
				</tr>
 				<?php
 				endforeach;
 				?>
 			</table>
			<?php }?>


			<?php
			if (isset($library_items)) {
			?>
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
			<span class="txt_item_title">
				<?php echo $lang['hdr_library_items'];?><br />
			</span>
			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<?php
				foreach($library_items as $key => $i):
				?>
				<tr>
					<td>
						<table width="100%" cellpadding="2" cellspacing="0" border="0">
							<tr>
								<td width="3" valign="top" rowspan="2">
									<img src="<?php echo $templatePath;?>img/dot.png" width="3" height="9" alt="" /><br />
								</td>
								<td>
									<?php
									$url = "lib_view.php?library_id=" . $i['library_id'];
									?>
									<a href="<?php echo $url;?>"><?php echo $this->date->formatDate($i['library_create_datetime']);?></a><br />
								</td>
							</tr>
							<tr>
								<td>
									<b><?php echo $i['library_title'];?></b><br />
									<?php echo $i['library_synopsis'];?><br />
								</td>
							</tr>
							<tr>
								<td>
									<br />
								</td>
								<td>
									<?php echo $lang['txt_tag'];?>: 
	
									<?php
									$tags = "";
									if (isset($i['tags'])) {
										foreach ($i['tags'] as $keyt => $t):
											$tags .= $t['tag_body'];
											
											if (count($i['tags']) > $keyt+1) {
												$tags .= ", ";
											}
										endforeach;
										$tags = searchTextFormat($tag, $tags);
										echo $tags;
									}
									?>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
					</td>
				</tr>
				<?php
				endforeach;
				?>
			</table>
			<?php }?>


			<?php
			if (isset($tasks)) {
			?>
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
			<span class="txt_item_title">
				<?php echo $lang['hdr_tasks'];?><br />
			</span>
			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<?php
				foreach($tasks as $key => $i):
				?>
			     <tr>
					<td width="3" valign="top">
						<img src="<?php echo $templatePath;?>img/dot.png" width="3" height="9" alt="" /><br />
					</td>
					<td valign="top">
						<?php
						$url = "sch_view.php?schedule_id=" . $i['schedule_id'];
						?>			
						<a href="<?php echo $url;?>"><?php echo $i['schedule_title'];?></a><br />
						<?php echo $i['schedule_synopsis'];?><br />
					</td>
					<td align="right" valign="top" nowrap="nowrap">
						<?php echo $i['display_schedule_start_datetime'];?><br />
						<?php echo $i['schedule_allocation'];?><br />
					</td>
			    </tr>
				<?php
				endforeach;
				?>
			</table>
			<?php }?>



			<?php
			if (isset($activities)) {
			?>
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
			<span class="txt_item_title">
				<?php echo $lang['hdr_activities'];?><br />
			</span>
			<table width="100%" cellpadding="2" cellspacing="2" border="0">
				<?php
				foreach($activities as $key => $i):
				?>
			     <tr>
					<td width="3" valign="top">
						<img src="<?php echo $templatePath;?>img/dot.png" width="3" height="9" alt="" /><br />
					</td>
					<td>
						<?php
						$url = "sch_view.php?schedule_id=" . $i['schedule_id'];
						?>	
						<a href="<?php echo $url;?>"><?php echo $i['schedule_title'];?></a><br />
						<?php echo $i['schedule_synopsis'];?><br />
					</td>
					<td align="right" valign="top">
						<?php echo $i['display_schedule_start_datetime'];?><br />
					</td>
			    </tr>
				<?php
				endforeach;
				?>
			</table>
			<?php }?>
			
			
			<?php
			if (isset($users)) {
			?>
			<table border="0" width="100%" cellspacing="0" cellpadding="4">
				<?php
				foreach($users as $key => $i):
				?>
				<tr>
					<td valign="top" width="32" rowspan="2">
						<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
					</td>
						
					<td valign="middle">
						<?php
						if (!empty($i['am_relation_to_them']['relation_show_true_self'])) {
						?>
							<b><a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['user_firstname']. " " . $i['user_surname'];?></a></b>,
							
							
							<?php echo $i['user_create_datetime'];?>,
							<?php echo $i['user_hometown'];?>,
						<?php
						}
						else {
						?>
						
							<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><b><?php echo $i['profile_nic'];?></b></a>,
							
							
							<?php echo $i['user_create_datetime'];?>,
							<?php echo $i['profile_hometown'];?>,
						<?php }?>
						
						<?php
						if ($i['online_status'] == 1) {
						    echo "<span class='txt_breadcrumb_on'><b>" . $lang['arr_user_online_status'][1] . "</b></span><br />";
						}
						else {
							    echo $lang['arr_user_online_status'][$i['online_status']] . "<br />";
						}
						?>
					</td>
					
					<td valign="top" width="80">
						<?php
						if (isset($i['relation_to'])) {
							echo "<img src='" . $templatePath . "img/sn_connected_to_them.png' width='16' height='16' title='" .  $lang['txt_help_icon_conn'] . "' alt='" .  $lang['txt_help_icon_conn'] . "' />&nbsp;";
							
							if (!empty($i['relation_to']['relation_show_network'])) {
								echo "<img src='" . $templatePath . "img/sn_they_see_my_nw.png' width='16' height='16' title='" . $lang['txt_help_icon_net'] . "' alt='" . $lang['txt_help_icon_net'] . "' />&nbsp;";
							}
							
							if (!empty($i['relation_to']['relation_show_true_self'])) {
								echo "<img src='" . $templatePath . "img/sn_true_self_revealed_to_them.png' width='16' height='16' title='" . $lang['txt_help_icon_ts'] . "' alt='" . $lang['txt_help_icon_ts'] . "' />&nbsp;";
							}
						}
						?><br />
					</td>
					<td align="right" rowspan="2">
						<?php
						if (isset($i['profile_allow_msg']) && $i['profile_allow_msg'] == 1) {
						?>
						<a href="msg_compose.php?to_user_id=<?php echo $i['user_id'];?>"><img src="<?php echo $templatePath;?>img/unopenned_mail.png" title="<?php echo $lang['ttl_send_message'];?>" border="0" alt="" /></a>&nbsp;&nbsp;<br />
						<?php }?>
					</td>
				</tr>
				<tr>
					<td>
						<p>
							<?php echo $lang['txt_tag'];?>: 
	
							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								echo $tags;
							}
							?>
						</p>
					</td>
					<td>
						<?php
						if (!empty($i['blocked'])) {
							echo $lang['txt_blocked'] . "<br />";
						}
						?>
						<?php
						if (!empty($i['am_relation_to_them']['relation_show_network'])) {
								echo "relations: " . $i['sn_total'];
							}
						?>
						<br />
					</td>
				</tr>
				<tr>
					<td colspan="4">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="4" alt="" /><br />
					</td>
				</tr>
				<?php
				endforeach;
				?>
			</table>
			<?php }?>
		</div>
	</div>
</div>

<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
</form>
