<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//

// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class User {
	// CLASS FUNCTIONS
	// User
	// checkLogin
	// loginUser
	// setLocale
	// authUser
	// getStatus
	// getUser
	// emailVerification
	// getLanguages
	// selProfile
	// getTemplates
	// getTemplate
	// deleteLanguages
	// selProfile
	// updateUser
	// insertLanguages
	// createPassword
	// updateProfile
	// createFeedPassword
	// selUserPreferences
	// selUserPreference
	// insertUserPreference
	// deleteUserPreference
	// selUsers



	// User --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 19th April 2004
	//
	function User($db, $date) {
		$this->db = $db;
		$this->date = $date;
	}//EO User



	// checkLogin --------------------------------------------------------------------
	// checks if the person can log in
	// tom calthrop - 19th April 2004
	//
	function checkLogin($email, $password){
		if(empty($email))
			$GLOBALS['igloo_error_log'][] = array(2, null, null);
		else{
			$query = "
				SELECT user_id FROM " . $this->db->prefix . "_user
				WHERE user_email=" . $this->db->qstr($email, get_magic_quotes_gpc())
			;

			$result = $this->db->Execute($query);
			
			if(empty($result->fields['user_id']))
				$GLOBALS['igloo_error_log'][] = array(24, null, null);
		}

		// Check whether the password is in the database and correct
		if(empty($password))
			$GLOBALS['igloo_error_log'][] = array(25, null, null);
		else{
			if(empty($GLOBALS['igloo_error_log']))
			{
				$query = "
					SELECT user_id, status_id
					FROM " . $this->db->prefix . "_user
					WHERE
					user_email=" . $this->db->qstr($email, get_magic_quotes_gpc()) . " AND
					user_password=" . $this->db->qstr(MD5($password), get_magic_quotes_gpc())
				;

				
				
				$result = $this->db->Execute($query);

				if(empty($result->fields['user_id'])) {
					$GLOBALS['igloo_error_log'][] = array(19, null, null);
				}

				if($result->fields['status_id'] != $this->status_ids['active']) {
					$GLOBALS['igloo_error_log'][] = array(26, null, null);
				}
			}
		}

	}//EO checkLogin



	// loginUser --------------------------------------------------------------------
	// logs in the user
	// tom calthrop - 19th April 2004
	//
	function loginUser($email, $password) {

		$query = "SELECT
			u.user_id, u.role_id, u.user_email, u.user_firstname, u.user_surname,
			u.user_homepage, t.template_title, u.language_id, u.user_feed_password, 
			MD5(UNIX_TIMESTAMP() + user_id + RAND(UNIX_TIMESTAMP())) AS session_id
			FROM " . $this->db->prefix . "_user u, " . $this->db->prefix . "_template t
			WHERE u.template_id = t.template_id AND
			user_email=" . $this->db->qstr($email, get_magic_quotes_gpc()) . " AND
			user_password=" . $this->db->qstr(MD5($password), get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields['user_id'])){
			// Starts a session
			if (empty($_SESSION)) {
			    session_start();
			}
			
			$this->user_id = $result->fields['user_id'];
			
			// Sets the sessionvariables
			$_SESSION['s_user_id'] = 			$result->fields['user_id'];
			$_SESSION['user_email'] = 			$result->fields['user_email'];
			$_SESSION['user_firstname'] = 		$result->fields['user_firstname'];
			$_SESSION['user_surname'] = 		$result->fields['user_surname'];
			$_SESSION['s_role_id'] = 			$result->fields['role_id'];
			$_SESSION['s_md5'] = 				md5($result->fields['session_id']);
			$_SESSION['language_id'] = 			$result->fields['language_id'];
			$_SESSION['user_homepage'] = 		$result->fields['user_homepage'];
			$_SESSION['template_id'] = 			$result->fields['template_title'];
			$_SESSION['breadcrumb'] = 			array();
			$_SESSION['language_ids'] = 		$this->getLanguages();
			$_SESSION['user_feed_password'] = 	$result->fields['user_feed_password'];
			
			// SELECT RELATIONS -------------------------------------------	
			$this->sn->user_id = $result->fields['user_id'];
			$_SESSION['relations'] = $this->sn->selRelations($result->fields['user_id']);
			
			
			// SET SESSION TABLE ------------------------------------------
			$rec = array();
			$rec['session_md5'] = $_SESSION['s_md5'];
			$rec['session_firstused'] = mktime();
			$rec['session_lastused'] = mktime();
			$rec['session_ip'] = $_SERVER['REMOTE_ADDR'];
			$rec['user_id'] = $this->user_id;
			
			$table = $this->db->prefix . "_user_session";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result)) {
				//set total logins statistic
				$this->statistic->user_id = $this->user_id;
				$this->statistic->statistic_type_id = $this->total_login_stat_id;
				$total_logins = $this->statistic->getStatistic();
				if (empty($total_logins)) {
				    $total_logins = 0;
				}
				$total_logins++;
				$this->statistic->setStatistic($total_logins);
				
				//set locale
				if (isset($_SESSION['language_id'])) {
				    $this->setLocale($_SESSION['language_id']);
				}

				//did we refer from a local page?
				if (!empty($this->http_referer)) {
					return header("Location: " . $this->http_referer);
					exit;
				}
				else {
					return header("Location: " . $_SESSION['user_homepage']."?". strip_tags(SID));
					exit;
				}
			}
			else {
				$GLOBALS['igloo_error_log'][] = array(1, 1, $this->db->ErrorMsg());
			}
		}
		else {
			$GLOBALS['igloo_error_log'][] = array(19, null, null);
		}
	}//EO loginUser



	// setLocale --------------------------------------------------------------------
	// setup local language for date setting etc
	// tom calthrop - 19th April 2004
	//
	function setLocale($language_id = null) {

		if (isset($language_id) && isset($this->language_arr['pack'][$language_id][0])) {
		    setlocale(LC_ALL,$this->language_arr['pack'][$language_id][0]);
		}
		else { //We default to English
		    setlocale(LC_ALL,"eng");
		}
	}


	function logoffUser () {
		if (!isset($_SESSION)) {
		    session_start();
		}

		$_SESSION = array();
		session_destroy();
	}//EO setLocale



	// authUser --------------------------------------------------------------------
	// check that the user is authorised for entry into system
	// tom calthrop - 19th April 2004
	//
	function authUser () {
		
		// Authenticate user
		$query = "
			SELECT session_md5
			FROM " . $this->db->prefix . "_user_session
			WHERE user_id = " . $_SESSION['s_user_id'] . "
			order by session_id desc"
		;

		$result = $this->db->SelectLimit($query, 1);

		// Checks if the session-id in the database and in the session-variables agree
		if($result->fields['session_md5'] != $_SESSION['s_md5']) {
			$this->logoffUser();
			header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . strip_tags(SID));
			exit;
		}


		// Check if user is locked
		$query = "
			SELECT status_id FROM " . $this->db->prefix . "_user
			WHERE
			user_id = " . $_SESSION['s_user_id']
		;

		$result = $this->db->Execute($query);

		// If user is not active...
		if($result->fields['status_id'] != $this->status_ids['active']) {
			header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . strip_tags(SID));
			exit;
		}
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_user_session 
			WHERE 
			session_md5=" . $this->db->qstr($_SESSION['s_md5'], get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		
		$rec = array();
		$rec['session_lastused'] = mktime();
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_user 
			WHERE 
			user_id=". $_SESSION['s_user_id']
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['active_time'] = mktime();
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		
		// Logging out people who have not been active for 12 hours - they wil be directed
		// to the login-page as their session-id will not match the database session-id
		$logout_timestamp = mktime()-(720*60);

		$query = "
			SELECT user_id
			FROM " . $this->db->prefix . "_user
			WHERE " . $logout_timestamp . " > active_time"
		;

		$result = $this->db->Execute($query);  // Logout if not active for 720 minutes

		// Going through the list and changing the sessions-ids,
		// which forces "really" inactive users to log on again....
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$user_id = $result->fields['user_id'];
				
				$query = "
					SELECT * FROM " . $this->db->prefix . "_user_session 
					WHERE 
					user_id=" . $user_id
				;
				
				$result = $this->db->Execute($query);
				
				$rec = array();
				$rec['session_md5'] = "null";
				
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
				
				$result->MoveNext();
		  	}
		}

		//set locale
		if (isset($_SESSION['language_id'])) {
		    $this->setLocale($_SESSION['language_id']);
		}

	}//EO authUser



	// getStatus --------------------------------------------------------------------
	// gets the current status of the user
	// tom calthrop - 19th April 2004
	//
	function getStatus($active_time = null){
		
		$formatting = array(" ", ":", "-");
		$active_time = str_replace($formatting, "", $active_time);
		
		$status = 4; //offline

		$time[1] = 0; //online
		$time[2] = 15; //idle
		$time[3] = 20; // sleeping
		$time[4] = 30; //offline
		
		foreach($time as $key => $t):
			$timedif = $this->db->UserTimeStamp(mktime()-(60*$t), "YmdHis");
			
			if($active_time <= $timedif) {
				$status = $key;
			}

		endforeach;
		
		return $status;
	}//EO getStatus



	// getStatus --------------------------------------------------------------------
	// change the user's status... NOT YET FULLY WORKING!
	// tom calthrop - 19th April 2004
	//
	function setStatus($status){
		$time[2] = 15;
		$time[4] = 20;
		$time[6] = 30;
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_user 
			WHERE 
			user_id=". $_SESSION['s_user_id']
		;
		
		$result = $this->db->Execute($query);
		
		$active_time = "UNIX_TIMESTAMP()-60*" . $time[$status];
		
		$rec = array();
		$rec['active_time'] = $active_time;
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
	}//EO getStatus




	// getUser --------------------------------------------------------------------
	// retrieves single DB row for user
	// tom calthrop - 19th April 2004
	//
	function getUser($user_id = null) {
		if (empty($user_id) && isset($this->user_id)) {
			$user_id = $this->user_id;
		}

		$query = "
			SELECT u.user_id, u.user_hometown, u.role_id, u.user_create_datetime,
			u.language_id, u.template_id, u.user_firstname, u.user_feed_password,
			u.user_surname, u.user_email, u.user_dob, u.user_gender, u.user_number,
			u.active_time, u.status_id, u.user_file_allocation, u.user_homepage
			FROM " . $this->db->prefix . "_user u
			WHERE "
		;

		if (isset($user_id)) {
		    $query .= "u.user_id=" . $user_id . " and ";
		}

		if (isset($this->user_email)) {
		    $query .= "u.user_email=" . $this->db->qstr($this->user_email, get_magic_quotes_gpc()) . " AND ";
		}
		
		$query .= "1=1";

		$result = $this->db->Execute($query);

		if (isset($result->fields['user_id'])) {
			$temp = $result->fields;

			$result->Close();
			return $temp;
		}
	}//EO getUser



	// emailVerification --------------------------------------------------------------------
	// sends user an email with the password
	// tom calthrop - 19th April 2004
	//
	function emailVerification($password, $email, $firstname, $language_id, $txt_template){
		//pick up the language file
		$body_file_txt = readTxtFile("language/" . $language_id . "/" . $this->language_dir . "/texts/" . $txt_template);

		$body_file_txt = str_replace("\\\"", "\"", $body_file_txt);
		$body_file_txt = str_replace("USERNAME", $firstname, $body_file_txt);
		$body_file_txt = str_replace("EMAIL", $email, $body_file_txt);
		$body_file_txt = str_replace("PASSWORD", $password, $body_file_txt);

		if (!empty($this->txt_message)) {
		    $body_file_txt = str_replace("MESSAGE", $this->txt_message, $body_file_txt);
		}
		else {
			$body_file_txt = str_replace("\nMESSAGE\n", "", $body_file_txt);
		}

		//create URL
		$url = "http://" . $_SERVER['HTTP_HOST'];
		$url .= dirname ($_SERVER['PHP_SELF']);
		//sometimes the server adds / as the last characture - we need to check.
		if (substr($url, -1, 1) != "/") {
		    $url .= "/";
		}

		$url .= "setup.php?em=" . $email . "&language_id=" . $language_id;

		if (isset($user->invitee_id)) {
		    $url .= "invitee=" . $this->user_id;
		}
		
		$body_file_txt = utf8_decode($body_file_txt);
		
		$body_file_txt = str_replace("URL", $url, $body_file_txt);

		//send email to barnraiser
		$this->mail->Body = $body_file_txt;
		$this->mail->AddAddress($email, $firstname);

		if(!$this->mail->Send()) {
			$error_info = "function=emailVerification class=User.class.php - Mailer Error: " . $this->mail->ErrorInfo;
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO emailVerification



	// getLanguages --------------------------------------------------------------------
	// get the languages that the user can read
	// tom calthrop - 18th Nov 2004
	//
	function getLanguages() {
		$query = "
			SELECT language_id FROM " . $this->db->prefix . "_user_language
			WHERE
			user_id=" . $this->user_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				array_push($temp, $result->fields['language_id']);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getLanguages class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getLanguages



	// selProfile --------------------------------------------------------------------
	// gets the user profile
	// tom calthrop - 19th December 2004
	//
	function selProfile($profile_id = null, $user_id=null) {
		if (empty($profile_id) && isset($this->profile_id)) {
		    $profile_id = $this->profile_id;
		}
		elseif (empty($user_id) && isset($this->user_id)) {
		    $user_id = $this->user_id;
		}
		
		$query = "
			SELECT p.profile_id, p.profile_name, p.profile_summary, p.profile_nic,
			p.profile_text1, p.profile_text2, p.profile_text3, p.profile_text4,
			p.profile_text5, p.profile_text6, p.profile_text7, p.profile_text8,
			p.profile_text9, p.profile_text10,
			p.file_id, p.profile_hometown, p.user_id, u.language_id, 
			p.profile_create_datetime, p.profile_default, p.profile_true_self, 
			u.active_time, p.profile_gender, p.profile_allow_msg 
			FROM " . $this->db->prefix . "_user_profile p, " . $this->db->prefix . "_user u
			WHERE
			p.user_id=u.user_id AND "
		;

		if (isset($profile_id)) {
		    $query .= "p.profile_id=" . $profile_id . " AND ";
		}
		
		if (isset($this->true_self)) {
		    $query .= "p.profile_true_self=1 AND p.user_id=" . $user_id . " AND ";
		}
		elseif (isset($user_id)) {
		    $query .= "
				p.profile_default=1 AND 
				p.user_id=" . $user_id . " AND "
			;
		}

		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			
			if (isset($result->fields['profile_id'])) {
				$temp = $result->fields;
				
				//if the user is me we set to "online", else we find the status
				if (isset($_SESSION['s_user_id']) && $_SESSION['s_user_id'] == $temp['user_id']) {
					$temp['online_status'] = 1;
				}
				else {
					$temp['online_status'] = $this->getStatus($temp['active_time']);
				}
	
				$result->Close();
				return $temp;
			}
		}
		else {
			$error_info = "function=selProfile class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}

	}//EO selProfile



	// getTemplates --------------------------------------------------------------------
	// gets the available templates
	// tom calthrop - 17th April 2004
	//
	function getTemplates() {
		$query = "
			SELECT t.template_id, t.template_title
			FROM " . $this->db->prefix . "_template t
			order by t.template_title"
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				array_push($temp, $result->fields);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getTemplates class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getTemplates



	// getTemplate --------------------------------------------------------------------
	// gets the available templates
	// tom calthrop - 17th April 2004
	//
	function getTemplate($template_id) {
		$query = "
			SELECT t.template_title
			FROM " . $this->db->prefix . "_template t
			WHERE
			t.template_id =" . $template_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getTemplate class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getTemplate



	// deleteLanguages --------------------------------------------------------------------
	// deletes languages that a user can read
	// tom calthrop - 18th Nov 2004
	//
	function deleteLanguages() {

		$query = "
			DELETE FROM " . $this->db->prefix . "_user_language
			WHERE
			user_id=" . $this->user_id
		;

		$result = $this->db->Execute($query);

		if (isset($result)) {
			return true;
		}
		else {
			$GLOBALS['igloo_error_log'][] = array(1, 1, $query . "-" . $this->db->ErrorMsg());
		}
	}//EO deleteLanguages



	// selProfiles --------------------------------------------------------------------
	// gets the available profile
	// tom calthrop - 17th April 2004
	//
	function selProfiles() {
		$query = "
			SELECT p.profile_id, p.profile_name, p.profile_nic, p.profile_default,
			p.file_id, p.profile_create_datetime, p.profile_hometown, p.user_id,
			p.profile_allow_msg, u.active_time, p.profile_true_self, 
			u.user_firstname, u.user_surname 
			FROM " . $this->db->prefix . "_user_profile p, " . $this->db->prefix . "_user u
			WHERE
			p.user_id=u.user_id AND "
		;

		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $i;
				if (count($this->user_ids) > $key+1) {
				    $user_ids .=",";
				}
			endforeach;
			$query .="p.user_id in (" . $user_ids . ") AND
			p.profile_default=1 AND ";
		}
		else {
			$query .= "p.user_id=" . $this->user_id . " AND ";
		}

		$query .= "1=1 ";

		if (isset($this->orderby)) {
		    $query .= "order by " . $this->orderby;
		}
		else {
			$query .= "order by p.profile_name";
		}
		//echo $query;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				if (isset($this->file)) {
					
					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}
				
				//if the user is me we set to "online", else we find the status
				if (isset($_SESSION['s_user_id']) && $_SESSION['s_user_id'] == $temp1['user_id']) {
				    $temp1['online_status'] = 1;
				}
				else {
					$temp1['online_status'] = $this->getStatus($temp1['active_time']);
				}

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selProfiles class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selProfiles



	// updateUser --------------------------------------------------------------------
	// update non administration columns in user
	// tom calthrop - 19th December 2004
	//
	function updateUser($data) {
		if (empty($data['language_ids'])) {
			$GLOBALS['igloo_error_log'][] = array(28, null, null);
		}

		if(empty($data['user_homepage'])) {
			$GLOBALS['igloo_error_log'][] = array(33, null, null);
		}

		// Check the password
		if(!empty($data['user_password1']) || !empty($data['user_password2'])) {

			if(empty($data['user_password1']) != empty($data['user_password2'])) {
				$GLOBALS['igloo_error_log'][] = array(15, null, null);
			}

			if(strlen($data['user_password1']) < 5) {
				$GLOBALS['igloo_error_log'][] = array(16, null, null);
			}
		}

		if (empty($GLOBALS['igloo_error_log'])) {

			$data['user_dob'] = $this->db->DBDate($data['user_dob']);
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_user 
				WHERE 
				user_id=" . $this->user_id
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['language_id'] = $data['language_id'];
			$rec['template_id'] = $data['template_id'];
			$rec['user_dob'] = $data['user_dob'];
			$rec['user_homepage'] = $data['user_homepage'];
			
			if (!empty($data['user_password1'])) {
				$tmp = md5($data['user_password1']);
				$feed_password = $this->createFeedPassword($tmp);
				$rec['user_password'] = $tmp;
				$rec['user_feed_password'] = $feed_password;
			}
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			$_SESSION['language_id'] = $data['language_id'];
			
		}
	} //EO updateUser;



	// insertLanguages --------------------------------------------------------------------
	// inserts languages that a user can read
	// tom calthrop - 18th Nov 2004
	//
	function insertLanguages($in_arr) {
		$rownums = count ($in_arr);

		for ($i=0; $i < $rownums; $i++) {
			
			$rec = array();
			$rec['user_id'] = $this->user_id;
			$rec['language_id'] = $in_arr[$i];
			
			$table = $this->db->prefix . "_user_language";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (empty($result)) {
				$error_info = "function=insertLanguages class=UserAdmin.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
			}
		}

	}//EO insertLanguages



	// createPassword --------------------------------------------------------------------
	// creates a password
	// tom calthrop - 19th April 2004
	//
	function createPassword(){

		// creates a password
		$totallength = 8;
		$salt = "abcdefghijklmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
		srand((double)microtime()*1000000);
		$password = "";
		for ($i = 0; $i < $totallength; $i++) {
			$password .= substr ($salt, rand() % strlen($salt), 1);
		}

		return $password;
	}//EO createPassword



	// updateProfile --------------------------------------------------------------------
	// upates a profile
	// tom calthrop - 27th December 2004
	//
	function updateProfile($data) {
		if(!empty($data['profile_true_self'])) { // true self
			
			if (empty($data['user_hometown'])) {
				$GLOBALS['igloo_error_log'][] = array(10, null, null);
			}
			
			if (empty($data['user_firstname'])) {
				$GLOBALS['igloo_error_log'][] = array(5, null, null);
			}
			
			if (empty($data['user_surname'])) {
				$GLOBALS['igloo_error_log'][] = array(6, null, null);
			}
			
			if (empty($GLOBALS['igloo_error_log'])) {
				$query = "
					SELECT * FROM " . $this->db->prefix . "_user 
					WHERE 
					user_id=" . $this->user_id
				;
				
				$result = $this->db->Execute($query);
				
				$rec = array();
				$rec['user_hometown'] = $data['user_hometown'];
				$rec['user_firstname'] = $data['user_firstname'];
				$rec['user_surname'] = $data['user_surname'];
				
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
				
				$_SESSION['user_surname'] = $data['user_surname'];
				$_SESSION['user_firstname'] = $data['user_firstname'];
				$_SESSION['user_hometown'] = $data['user_hometown'];
			}
		}
		else { //alias
			if (empty($data['profile_nic'])) {
				$GLOBALS['igloo_error_log'][] = array(7, null, null);
			}
			
			if (empty($data['profile_hometown'])) {
				$GLOBALS['igloo_error_log'][] = array(10, null, null);
			}
		}
		
		if (empty($GLOBALS['igloo_error_log'])) {
			
			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}

			if (empty($data['profile_gender']) || (isset($data['profile_gender']) && $data['profile_gender']<=0)) {
			    $data['profile_gender'] = "null";
			}

			if (empty($data['profile_allow_msg'])) {
			    $data['profile_allow_msg'] = "null";
			}

			if (empty($data['profile_text1'])) {
			    $data['profile_text1'] = "null";
			}

			if (empty($data['profile_text2'])) {
			    $data['profile_text2'] = "null";
			}

			if (empty($data['profile_text3'])) {
			    $data['profile_text3'] = "null";
			}

			if (empty($data['profile_text4'])) {
			    $data['profile_text4'] = "null";
			}

			if (empty($data['profile_text5'])) {
			    $data['profile_text5'] = "null";
			}

			if (empty($data['profile_text6'])) {
			    $data['profile_text6'] = null;
			}

			if (empty($data['profile_text7'])) {
			    $data['profile_text7'] = "null";
			}

			if (empty($data['profile_text8'])) {
			    $data['profile_text8'] = "null";
			}

			if (empty($data['profile_text9'])) {
			    $data['profile_text9'] = "null";
			}

			if (empty($data['profile_text10'])) {
			    $data['profile_text10'] = "null";
			}

			if (empty($data['profile_hometown'])) {
			    $data['profile_hometown'] = "null";
			}

			if (empty($data['profile_nic'])) {
			    $data['profile_nic'] = "null";
			}
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_user_profile 
				WHERE 
				profile_id=" . $data['profile_id']
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['profile_name'] = $data['profile_name'];
			$rec['profile_summary'] = $data['profile_summary'];
			$rec['profile_nic'] = $data['profile_nic'];
			$rec['profile_text1'] = $data['profile_text1'];
			$rec['profile_text2'] = $data['profile_text2'];
			$rec['profile_text3'] = $data['profile_text3'];
			$rec['profile_text4'] = $data['profile_text4'];
			$rec['profile_text5'] = $data['profile_text5'];
			$rec['profile_text6'] = $data['profile_text6'];
			$rec['profile_text7'] = $data['profile_text7'];
			$rec['profile_text8'] = $data['profile_text8'];
			$rec['profile_text9'] = $data['profile_text9'];
			$rec['profile_text10'] = $data['profile_text10'];
			$rec['profile_hometown'] = $data['profile_hometown'];
			$rec['profile_gender'] = $data['profile_gender'];
			$rec['profile_allow_msg'] = $data['profile_allow_msg'];
			$rec['file_id'] = $data['file_id'];
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
		}
	}//EO updateProfile




	// createFeedPassword --------------------------------------------------------------------
	// takes MD5'ed password and pulls out somm charactures to create a feed password for RSS
	// tom calthrop - 20th December 2004
	//
	function createFeedPassword($password) {

		$password = substr($password, 0, 9);

		//get 3 random numbers
		$random1 = rand(0, strlen($password));
		$random2 = rand(0, strlen($password));
		$random3 = rand(0, strlen($password));
		//get 3 charactures from password
		$passchar1 = substr($password, $random1-1, 1);
		$passchar2 = substr($password, $random2-1, 1);
		$passchar3 = substr($password, $random3-1, 1);
		
		$feed_pass = $random1 . $random2 . $random3 . $passchar1 . $passchar2 . $passchar3;

		return $feed_pass;
	}//EO createFeedPassword

	
	
	// selUserPreferences --------------------------------------------------
	// returns a user preference
	// tom calthrop - 27th August 2005
	//
	function selUserPreferences() {
		
		$query = "
			SELECT user_id, user_preference_id 
			FROM " . $this->db->prefix . "_user_preference "
		;
		
		$query .= "WHERE ";
		
		if (isset($this->user_id)) {
		    $query .= "user_id=" . $this->user_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			
			return $temp;
			
		}
		else {
			$error_info = "function=selUserPreferences class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selUserPreferences
	
	
	
	// selUserPreference --------------------------------------------------
	// returns a user preference
	// tom calthrop - 27th August 2005
	//
	function selUserPreference($user_id, $user_preference_id) {
		
		$query = "
			SELECT user_preference_id 
			FROM " . $this->db->prefix . "_user_preference 
			WHERE 
			user_id=" . $user_id . " AND 
			user_preference_id=" . $user_preference_id
		;
		
		$result = $this->db->SelectLimit($query, 1); //returns last 1 rows
		
		if (isset($result->fields['user_preference_id'])) {
			return true;
		}
		else {
			return false;
		}
	}//EO selUserPreference
	
	
	
	// insertUserPreference --------------------------------------------------------------------
	// inserts a users preference
	// tom calthrop - 27th August 2005
	//
	function insertUserPreference($user_preference_id, $user_id = null) {
		
		if (!isset($user_id)) {
			$user_id = $this->$user_id;
		}
		
		$rec = array();
		$rec['user_id'] = $user_id;
		$rec['user_preference_id'] = $user_preference_id;
		$table = $this->db->prefix . "_user_preference";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=insertUserPreference class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO insertUserPreference
	
	
	// deletetUserPreference --------------------------------------------------------------------
	// deletes a users preference
	// tom calthrop - 27th August 2005
	//
	function deletetUserPreference($user_preference_id) {
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_user_preference 
			WHERE
			user_id=" . $this->user_id . " AND 
			user_preference_id=" . $user_preference_id
		;
		
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=deletetUserPreference class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	} //EO deletetUserPreference
	
	
	// selUsers --------------------------------------------------------------------
	// returns all rows from users - only use if in admin section
	// tom calthrop - 7th December 2004
	//
	function selUsers($tag=null) {
		
		$query = "
			SELECT u.user_id, u.user_firstname, u.user_surname, u.active_time, 
			u.user_hometown, u.language_id, u.status_id, u.role_id, 
			u.user_create_datetime, p.profile_nic, u.user_create_datetime, 
			u.status_id, p.profile_hometown, p.profile_allow_msg, p.file_id 
			FROM " . $this->db->prefix . "_user u "
			;
		
		if (isset($tag)) {
			$query .= ", " . $this->db->prefix . "_tag t  ";
		}
		
		$query .= "
			JOIN " . $this->db->prefix . "_user_profile p ON u.user_id=p.user_id AND p.profile_default=1 
			WHERE "
		;
			
		if (isset($this->status_ids)) {
			$query .= "u.status_id=" . $this->status_ids['active'] . " AND ";
		}
		
		if (isset($tag)) {
			$query .= "
				u.user_id=t.item_id AND 
				t.user_id=" . $this->user_id . " AND 
				t.rsp_item_type_id=" . $this->item_types['network'] . " AND
				t.tag_body like " . $this->db->qstr("%" . $tag . "%", get_magic_quotes_gpc()) . " AND "
			;
		}
		
		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $i;
				if (count($this->user_ids) > $key+1) {
				    $user_ids .=",";
				}
			endforeach;
			$query .="u.user_id in (" . $user_ids . ") AND ";
		}
		
		$query .= "1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by u.user_id";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				//if the user is me we set to "online", else we find the status
				if (isset($_SESSION['s_user_id']) && $_SESSION['s_user_id'] == $temp1['user_id']) {
				    $temp1['online_status'] = 1;
				}
				else {
					$temp1['online_status'] = $this->getStatus($temp1['active_time']);
				}
				
				if (isset($this->file)) {
					
					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selUsers class=UserAdmin.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selUsers;




	// checkFeedPassword --------------------------------------------------------------------
	// takes a received password, removes user_id, checks andd returns true if ok
	// tom calthrop - 27th November 2005
	//
	function checkFeedPassword ($feedpassword) {
		//pull vars out of feed string
		$user_id = substr($feedpassword,6);
		$feedpass = substr($feedpassword,0,6);
		
		//we check that this person is who they say they are
		$query = "
			SELECT user_id, language_id 
			FROM " . $this->db->prefix . "_user
			WHERE 
			user_id=" . $user_id . " AND 
			user_feed_password=" . $this->db->qstr($feedpass, get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields['user_id'])) {//I am the correct user for this feed
			return true;
		}
		else {
			return false;
		}
	}
}
