<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "magazine";
include "inc/header.inc.php";


//ACS check
if (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['library'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP LIBRARY ---------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Library.class.php');
$library = new Library($db, null);
$library->rsp_level_id = $rsp_level_id;

if (isset($_REQUEST['library_id'])) {
	$library->library_id = $_REQUEST['library_id'];
}
elseif (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languageArrayPath . 'arr_user.lang.php');


// SETUP WIKI ------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();
//$wiki->disableRule('wikilink');


// SETUP COMMENTS --------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['library']);

if (isset($me['user_id'])) {
	$comment->user_id = $me['user_id'];
}

$comment->wiki = $wiki;


// SETUP TAGS ------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['library']);

if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
}


// SETUP BOOKMARKS -------------------------------------------------------
if (isset($me['user_id'])) {
	require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['library'], $me['user_id']);
}


// PROCESS FORM ----------------------------------------------------------
if (isset($_POST['update_tag'])) {
	$frmdata['item_id'] = $frmdata['library_id'];
	$tag->deleteTags($frmdata);
	$tag->insertTags($frmdata);
	
	return header("Location: lib_view.php?library_id=". $frmdata['library_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['preview'])) {
	unset($library->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
	
	$library->library_id = $_REQUEST['library_id'];
	
	$output_library = $library->selLibraryItem();
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $frmdata['library_id'];
	$comment->insertComment($frmdata);
	
	if (empty($GLOBALS['igloo_error_log'])) {
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db);
		//update stats
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		unset($comment->item_id, $comment->rsp_item_type_id, $comment->section_id, $comment->section_item_id);
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());

		return header("Location: lib_view.php?library_id=". $frmdata['library_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
	$library->library_id = $_REQUEST['library_id'];
	
	$output_library = $library->selLibraryItem();
}
elseif ((isset($frmdata['search_text']) && strlen(trim($frmdata['search_text'])) >= 3) || !empty($_REQUEST['tag'])) {
	
	if (!empty($_REQUEST['tag'])) {
		$library->tag = $_REQUEST['tag'];
	}
	
	//get the latest node library_items
	$library->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
	$library->rsp_status_id = $c_node['rsp']['status']['live'];
	
	$output_library_items = $library->selLibraryItems(trim($frmdata['search_text']));
}
elseif (!empty($_REQUEST['history_library_id'])) {
	//get my library_items
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$library->file = $file;
	
	$output_library_items = $library->getHistory($_REQUEST['history_library_id']);

}
elseif (isset($frmdata['options'])) {
	if ($frmdata['options'] == "list_node") {
		//get the latest node library_items
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$library->file = $file;
		
		$library->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		$library->rsp_status_id = $c_node['rsp']['status']['live'];
		
		$output_library_items = $library->selLibraryItems();
	}
	elseif ($frmdata['options'] == "list_relation") {
		//get the latest relations library_items
		unset($library->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$library->file = $file;
		
		foreach($_SESSION['relations'] as $key => $i):
			$library->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		if (!empty($library->user_ids)) {
			$output_library_items = $library->selLibraryItems();
		}
	}
	elseif ($frmdata['options'] == "list_my") {
		//get my library_items
		unset($library->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$library->file = $file;
		$library->user_id = $me['user_id'];
		
		$output_library_items = $library->selLibraryItems();
	}
	elseif ($frmdata['options'] == "list_marked") {
		//get my marked library_items
		unset($library->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$library->file = $file;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		$watched_library_ids = $bookmark->getBookmarks();
		
		$library->user_id = $me['user_id'];
		
		if (!empty($watched_library_ids)) {
			$library->library_ids = $watched_library_ids;
			$output_library_items = $library->selLibraryItems();
		}
	}
	elseif ($frmdata['options'] == "list_relation_tips") {
		//get my relations tipped library_items
		unset($library->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$library->file = $file;
		
		unset($bookmark->user_id);
		foreach($_SESSION['relations'] as $key => $i):
			$bookmark->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		$recommended_library_ids = $bookmark->getBookmarks();
		
		if (!empty($recommended_library_ids)) {
			$library->library_ids = $recommended_library_ids;
			$output_library_items = $library->selLibraryItems();
		}
		
	}
	elseif ($frmdata['options'] == "list_user") {
		//get library_items for this user (if relation)
		unset($library->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$library->file = $file;
		
		if (!empty($_SESSION['relations'])) {
			foreach($_SESSION['relations'] as $key => $i):
				if (!empty($frmdata['user_id']) && $frmdata['user_id'] == $i['user_id_relation']) {
					$library->user_id = $frmdata['user_id'];
					
					$output_library_items = $library->selLibraryItems();
					
					break;
				}
			endforeach;
		}
	}
	elseif ($frmdata['options'] == "item_mark") {
		//mark this item
		$bookmark->item_id = $frmdata['library_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->insertBookmark();
		
		$library->library_id = $frmdata['library_id'];
		$output_library = $library->selLibraryItem();
	}
	elseif ($frmdata['options'] == "item_tip") {
		//tip this item
		$bookmark->item_id = $frmdata['library_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->insertBookmark();
		
		$library->library_id = $frmdata['library_id'];
		$output_library = $library->selLibraryItem();
	}
	elseif ($frmdata['options'] == "item_edit") {
		//edit this item
		header("Location: lib_edit.php?library_id=" . $frmdata['library_id'] . "&".SID);
		exit;
	}
	elseif ($frmdata['options'] == "item_add") {
		//add an item
		header("Location: lib_edit.php?".SID);
		exit;
	}
	elseif ($frmdata['options'] == "add_wiki_page") {
		return header("Location: lib_edit.php?" . strip_tags(SID));
		exit;
	}
	
	$display = $frmdata['options'];
}
elseif (isset($_REQUEST['library_id'])) {
	$output_library = $library->getPageID($library->library_id);
	
	//find out if this is the newest article
	$newest_doc = $library->getPageName($output_library['library_page_name']);

	if ($output_library['library_id'] == $newest_doc['library_id']) {
	    $newest = true;
	}
	
	$library->library_id = $output_library['library_id'];
}
elseif (isset($page)) {
	$output_library = $library->getPageName($page);
	$newest = true;
}
else {
	$output_library = $library->getPageDefault();
	$newest = true;
}


// CHECK PERMISSION TO VIEW LIBRARY ------------------------------------------
if (!empty($output_library)) {
	// Are we allowed to see this library?
	require_once($languageArrayPath . 'arr_rsp.lang.php');
	
	require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
	$rsp = new Rsp($db, $c_node['rsp']['item_type']['library']);
	$output_library['rsp'] = $rsp->selRspItem($library->library_id);
	
	if (isset($me['user_id']) && $me['user_id'] == $output_library['user_id']) {
		// is the author me?
		$allow_view = 1;
	}
	elseif (!empty($output_library['rsp'])) {
		// is the item published to node or public and can I see it?
		foreach ($output_library['rsp'] as $key => $i):
			if ($i['level_id'] == $rsp_level_id) {
				$allow_view = 1;
				break;
			}
			
			// is it set to network and ar they in my network?
			if (!empty($i['degree_id'])) {
				foreach($_SESSION['relations'] as $key => $r):
					if ($output_library['user_id'] == $i['user_id_relation']) {
						$allow_view = 1;
						break;
					}
					
					if (isset($allow_view)) {
						break;
					}
				endforeach;
			}
		endforeach;
	}
	
	if (!isset($allow_view)) {
		unset($output_library);
	}
}


if (!empty($output_library)) {
	//wikify body
	$wiki_path = "lib_view.php?user_id=" . $output_library['user_id'] . "&page=";
	$wiki_new_path = "lib_edit.php?page=";
	$wiki_image_base = "get_file.php?file=";
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	
	// set an array of pages that exist in the library
	$pages = $library->getPages();
	$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);
	$output_library['library_body_display'] = $wiki->transform($output_library['library_body'], 'Xhtml');
	
	
	// GET AUTHOR
	$output_author = $user->selProfile($output_library['user_id']);
	
	
	// GET BOOKMARK --------------------------------------------------
	if (isset($bookmark)) {
		$bookmark->item_id = $library->library_id;
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_library['bookmark']['watch'] = 1;
		}
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_library['bookmark']['recommend'] = 1;
		}
	}
	
	
	
	//get comments
	unset($comment->user_id);
	// if Item comments is requested (&ico=1) we select only select comment for
	// this library_id, else we get the history and get comments for all 
	// versions of this wiki page
	if (empty($_REQUEST['ico'])) {
		$output_library_history = $library->getHistory($library->library_id);
		
		if (!empty($output_library_history)) {
			$comment->item_ids = array();
			foreach($output_library_history as $key => $i):
				array_push($comment->item_ids, $i['library_id']);
			endforeach;
		}
		
		$output_comments = $comment->selComments();
	}
	else {
		$output_comments = $comment->selComments($library->library_id);
	}
	
	
	//get tags
	$tag->item_name = $output_library['library_page_name'];
	$output_my_tags = $tag->selTags();
	unset($tag->user_id);
	$output_item_tags = $tag->selTags();
	
	
	//get the history of the library item
	$output_sidebar_items = $library->getHistory($output_library['library_id']);

}


if (!empty($output_library_items)) {
	foreach($output_library_items as $key => $i):
		unset($comment->user_id, $comment->section_id, $comment->section_item_id, $comment->rsp_item_type_id);
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		$output_library_items[$key]['comment_total'] = $comment->getCommentCount($i['library_id']);
	endforeach;
	
	$tag->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
	foreach ($output_library_items as $key => $i):
		$tag->item_id = $i['library_id'];
		$output_library_items[$key]['tags'] = $tag->selTags();
	endforeach;
}


//move vars to template
if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
	$template_pageLinkNote = $output_library['library_title'];
}
elseif (empty($display)) { // we will display a button to allow the user to create a first library item
	$body->set('library_first_page', $lang['txt_wiki_default']);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($newest)) {
	$body->set('newest', $newest);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_library_items)) {
	$body->set('library_items', $output_library_items);
	$body->set('rsp_config', $c_node['rsp']); 
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_sidebar_items)) {
	$body->set('sidebar_items', $output_sidebar_items);
}

if (!empty($output_statistic)) {
	$body->set('profile_statistic', $output_statistic);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

$template_pageLink = $lang['txt_library'];

include "inc/footer.inc.php";

?>