/*****
 *       xhackometer - part of the Hackometer project
 *                                                                   
 * xhackometer records keyboard and mouse and cache files
 * for later delivery to hackometer server
 *                                                                   
 *        Copyright (C) 2009 Henrik Sandklef      
 *                                                                   
 * This program is free software; you can redistribute it and/or     
 * modify it under the terms of the GNU General Public License       
 * as published by the Free Software Foundation; either version 3    
 * of the License, or any later version.                             
 *                                                                   
 *                                                                   
 * This program is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
 * GNU General Public License for more details.                      
 *                                                                   
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software       
 * Foundation, Inc., 51 Franklin Street, Boston,            
 * MA  02110-1301, USA.                                              
 ****/

#include "xhm.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/utsname.h>


xhm_data*
xhm_new_xhm_data()
{
  xhm_data     *xd ;
  xhm_control  *xc ;
  xhm_register *xr ;
  struct server_status *s_stat;

  xd = (xhm_data*)     calloc (1, sizeof (xhm_data));
  xc = (xhm_control*)  calloc (1, sizeof (xhm_control));
  xr = xhm_new_xhm_reg (xd);
  s_stat = (struct server_status *) calloc(1,sizeof(struct server_status));


  xd->xhm_ctrl=xc;
  xd->xhm_reg=xr;
  xd->s_stat=s_stat;

  /* xhm control struct */
  xd->xhm_ctrl->verbose_fd=NULL;
  xd->xhm_ctrl->use_record=True;
  xd->xhm_ctrl->display=NULL;

  xd->xhm_ctrl->uin=NULL;
  xd->xhm_ctrl->password=NULL;

  sem_init(&xd->sem, 0, 1) ;

  /* XHM register struct */

  xhm_null_struct (xd);
  return xd;
}

void
free_if_notnull (char *tmp)
{
  if (tmp!=NULL)
    free(tmp);
}

int
xhm_free_xhm_data(xhm_data* xd)
{
  free_if_notnull(xd->xhm_ctrl->uin);
  free_if_notnull(xd->xhm_ctrl->password);

  free_if_notnull(xd->xhm_ctrl->rc_name);
  free_if_notnull(xd->xhm_ctrl->display);
  free (xd->xhm_ctrl);
  free (xd->s_stat);
  xhm_free_xhm_reg ( xd);

  return 0;
}


void
xhm_verbose (xhm_data *xd, char * msg, ...)
{
  va_list ap;
  FILE *fd ;

  fd= xd->xhm_ctrl->verbose_fd;
  if (fd!=NULL) 
    {
      va_start(ap, msg);
      vfprintf ( fd, msg, ap );
    }
}



int
xhm_null_struct (xhm_data *xd)
{
  xd->nr_of_kpress=0;
  xd->nr_of_krelease=0;
  xd->nr_of_bpress=0;
  xd->nr_of_brelease=0;
  xd->nr_of_motions=0;
  xd->nr_of_xpix=0;
  xd->nr_of_ypix=0;
  
  return 0;
} 


int
xhm_is_empty (xhm_data *xd)
{
  return (
      (xd->nr_of_kpress==0)   &&
      (xd->nr_of_krelease==0) &&
      (xd->nr_of_bpress==0)   &&
      (xd->nr_of_brelease==0) &&
      (xd->nr_of_motions==0)  &&
      (xd->nr_of_xpix==0)     &&
      (xd->nr_of_ypix==0) );
} 





int
xhm_cache_struct (xhm_data *xd)
{
  
  return 0;
}


FILE*
xhm_create_rc (xhm_data *xd)
{
  char   rc_buf[100];
  char  *rc_file=NULL;  
  int  fd_int;
  FILE *fd;

  rc_file=getenv("HOME");
  if (rc_file!=NULL)
    {
      strcpy (rc_buf, rc_file);
      strcat(rc_buf, "/");
      strcat(rc_buf, XHM_LOCAL_RC);
      xhm_verbose (xd, "xhm_open_rc_file\tTrying %s\n", rc_buf);

      /* create it */
      if ((fd_int = open (rc_buf, O_CREAT | O_RDWR, S_IWUSR | S_IRUSR | S_IRGRP | S_IROTH  )) < 0)
	{
	  xhm_verbose (xd, "Could not create %s\n", rc_buf);
	}
      close (fd_int);

      xhm_verbose (xd, "xhm_open_rc_file\tTrying \"%s\"\n", rc_buf);
      fd=fopen (rc_buf, "r+");
      if (fd==NULL)
	{
	  xhm_verbose (xd, "xhm_open_rc_file\tCouldn't find %s\n", rc_buf);
	}
      else
	{
	  xd->xhm_ctrl->rc_name=strdup (rc_buf);
	  return fd;
	}
    }
  return NULL;
}

int 
xnee_check ( char *arg, char *long_arg , char *short_arg ) 
{
  return ( ! strcmp ( arg, long_arg) || ( ! strcmp ( arg, short_arg) )) ; 
}


int 
ask_user (FILE *fd, char *field, char *descr, char *def)
{
  char tmp[100];
  
  printf ("Set the value for \"%s\"", field);
  if (descr!=NULL)
    printf ("(%s)", descr);
  printf ("\n");

  printf (" please do any of the following\n");
  if (def !=NULL)
    printf ("\t1) Press RETURN to use the value %s\n", def);
  printf ("\t2) type the new value\n"); 
  
  fgets(tmp, 256, stdin);

  if ( strlen(tmp) == 1 )
    {
      strcpy (tmp, def);
    }

  fprintf (fd,"\n");
  fprintf (fd,"#\n");
  fprintf (fd,"# %s\n", field);
  fprintf (fd,"#   %s \n", descr);
  fprintf (fd,"%s%s\n", field, tmp);
}




int
xhm_fill_rc (xhm_data *xd, FILE* fd)
{
  fprintf (fd,"#####################################\n");
  fprintf (fd,"#                                   #\n");
  fprintf (fd,"#    Resource file for Xhackometer  #\n");
  fprintf (fd,"#                                   #\n");
  fprintf (fd,"#####################################\n");

/*   ask_user (fd, XHM_REAL_NAME,     "User to send the packets as.",        getenv("USER")); */
/*   ask_user (fd, XHM_NICK_NAME,     "Nick name",             "I am called"); */
/*   ask_user (fd, XHM_MAIL,          "User's email address ", "john-doe@nospam.com"); */
/*   ask_user (fd, XHM_HOME_URL,      "User's homepage",       "http://www.myveryownpage.com/~yesitisme"); */
  ask_user (fd, XHM_UIN,      "Identifier on the server",       "0"); 
/*   fprintf (fd,"\n#\n# %s:\n#   \n%s\n", XHM_UIN,XHM_UIN); */
  ask_user (fd, XHM_PASSWORD,      "password used for user.",                    "password");
/*   ask_user (fd, XHM_SERVER,        "server to send the packets to.",             "localhost"); */
/*   ask_user (fd, XHM_SERVER_PORT,   "port on the server to send the packets to.", "10024"); */
/*   ask_user (fd, XHM_SEND_INTERVAL, "set the send interval (in seconds).",        "3600"); */
/*   ask_user (fd, XHM_USE_RECORD,    "Use RECORD extension to collect data.", "True"); */

  
  return 0;
}

char* 
rem_nl(xhm_data *xd, char *val)
{
  int str_len = (strlen(val));

  xhm_verbose (xd, "---> rm_nl \"%s\"\n", val);
  if (val[str_len]=='\n')
    val[str_len]='\0';
  xhm_verbose (xd, " --- rm_nl \"%s\"\n", val);
  if (val[str_len-1]=='\n')
    val[str_len-1]='\0';
  xhm_verbose (xd, " --- rm_nl \"%s\"\n", val);
  xhm_verbose (xd, "<--- rm_nl \"%s\"\n", val);
  return val;
}

int
xhm_use_rc (xhm_data *xd, FILE *fd)
{
  char tmp[256];
  char *val;
  int do_register=False;

  while (fgets(tmp, 256, fd)!=NULL)
    {

      if ( strlen(tmp) == 1 )
	{
	  ;
	}
      else if ( tmp[1]=='#' )
	{
	  ;
	}
      else if ( strncmp(tmp,XHM_PASSWORD, strlen(XHM_PASSWORD)) == 0 )
	{
	  val=strtok (tmp, ":");
	  val=strtok (NULL, ":");
	  xd->xhm_ctrl->password=strdup(rem_nl(xd,val));
	}
      else if ( strncmp(tmp,XHM_UIN, strlen(XHM_UIN)) == 0 )
	{
	  val=strtok (tmp, ":");
	  val=strtok (NULL, ":");
	  
	  val=rem_nl(xd, val);
	  xd->xhm_ctrl->uin=strdup(val);
	}
      else if ( strncmp(tmp,XHM_USE_RECORD, strlen(XHM_USE_RECORD)) == 0 )
	{
	  val=strtok (tmp, ":");
	  val=strtok (NULL, ":");
	  if (strcmp(val,"False")==0)
	    {
	      xd->xhm_ctrl->use_record=False;
	    }
	  else
	    {
	      xd->xhm_ctrl->use_record=True;
	    }
	}
    }
  rewind(fd);
}


FILE*
xhm_find_rc (xhm_data *xd)
{
  char   rc_buf[100];
  char  *rc_file=NULL;  
  FILE  *fd;
  
  /* Try environment variable first */
  rc_file=getenv(XHM_RC_ENV);
  if (rc_file!=NULL)
    {
      xhm_verbose (xd, "xhm_open_rc_file\tTrying %s\n", rc_file);
      fd = fopen ( rc_file , "r+");
      if (fd==NULL)
	{
	  xhm_verbose (xd, "xhm_open_rc_file\tCouldn't find %s\n", rc_file);
	}
      else
	{
	  xd->xhm_ctrl->rc_name=strdup (rc_file);
	  return fd;
	}
    }
  
  /* Perhaps we have a local rc file */ 
  rc_file=getenv("HOME");
  if (rc_file!=NULL)
    {
      strcpy (rc_buf, rc_file);
      strcat(rc_buf, "/");
      strcat(rc_buf, XHM_LOCAL_RC);
      xhm_verbose (xd, "xhm_open_rc_file\tTrying %s\n", rc_buf);
      
      fd = fopen (rc_buf, "r+");
      
      if (fd==NULL)
	{
	  xhm_verbose (xd, "xhm_open_rc_file\tCouldn't find %s\n", rc_buf);
	}
      else
	{
	  xd->xhm_ctrl->rc_name=strdup ( rc_buf);
	  return fd;
	}
    }
  
  /* OK, let's try the system rc file */
  xhm_verbose (xd, "xhm_open_rc_file\tTrying %s\n", XHM_SYSTEM_RC);
  fd = fopen (XHM_SYSTEM_RC, "r+");
  
  if (fd==NULL)
    {
      xhm_verbose (xd, "xhm_open_rc_file\tCouldn't find %s\n", XHM_SYSTEM_RC);
    }
  else
    {
      xd->xhm_ctrl->rc_name=strdup (XHM_SYSTEM_RC);
      return fd;
    }


  xhm_verbose (xd, "############################## CREATING THE FILE \n");
  if ( (fd = xhm_create_rc(xd)) == NULL )
    {
      xhm_verbose (xd, "failed to create\n");
    }
  else
    {
      xhm_verbose (xd, "creation succeeded\n");
      xhm_fill_rc (xd, fd);
      rewind (fd);
      return fd;
    }

  /* We should not get here ... */
  return NULL;
}





char **
xhm_add_data (xhm_data *xd, char **ret_str, char *buf, int index)
{
  char *char_ptr;
  
  if (buf==NULL)
    {
      xhm_verbose (xd,"---> xhm_add_data (... , null, %d) \n",  index);
      ret_str = (char**) (realloc(ret_str, (index+1) * (sizeof(char*))));
      ret_str[index] = NULL;
      return ret_str;
    }
  
  xhm_verbose (xd,"---> xhm_add_data (... , %s, %d) \n", buf, index);
  ret_str = (char**) (realloc(ret_str, (index+1) * (sizeof(char*))));
  
  char_ptr = (char*) (calloc(1,(  (strlen(buf) + 5)   * sizeof(char))));

  if (char_ptr == NULL)
    {
      fprintf (stderr, "failed to allocate TODO HESA: fix this\n");
      exit(0);
    }
  strcpy (char_ptr, buf);
  strcat (char_ptr, "\n");
  ret_str[index] = char_ptr;

  strcpy(ret_str[index], buf);

  strcpy (buf, "\n");
  xhm_verbose (xd,"<--- xhm_add_data\n");
  return ret_str;
}


char **
xhm_data2string ( xhm_data *xd, xhm_data *conv_data)
{
  
  char os_tmp[256]; 
  char win_tmp[256]; 
  char tmp_str[10];
  struct utsname uname_pointer;
  Display *dpy;

  char buf[1024];
  char tmp[100];
  char **ret_str ;
  int index=0;
  xhm_data* convert_this;

  struct tm * timeinfo;
  
  xhm_verbose (xd,"---> xhm_data2string  \n");

  if (conv_data==NULL)
    {
      convert_this=xd;
    }
  else
    {
      convert_this=conv_data;
    }


  
  ret_str = (char**) (calloc(1,sizeof(char*)));
  
  xhm_verbose (xd,"---  xhm_data2string  1\n");
  /* protocol */
/*   strcpy (buf, ""); */
/*   strcat (buf, XHM_PUT); */
/*   sprintf (tmp, "%s/%s",  HACKOMETER_PROTOCOL_NAME,HACKOMETER_PROTOCOL_VERSION); */
/*   strcat (buf, tmp ); */
/*   ret_str = xhm_add_data (xd, ret_str, buf, index++); */
  
  /* user */
/*   strcpy (buf, ""); */
/*   strcat (buf, XHM_UIN); */
/*   sprintf (tmp, "%s",xd->xhm_ctrl->uin); */
/*   strcat (buf, tmp); */
/*   ret_str = xhm_add_data (xd, ret_str, buf, index++); */
  
  xhm_verbose (xd,"---  xhm_data2string  2\n");

  /* password */
/*   strcpy (buf, ""); */
/*   strcat (buf, XHM_PASSWORD); */
/*   sprintf (tmp, "%s",xd->xhm_ctrl->password); */
/*   strcat (buf, tmp); */
/*   ret_str = xhm_add_data (xd, ret_str, buf, index++); */
  
  /* keys */
  strcpy (buf, "");
  strcat (buf, XHM_KEY_PRESS);
  sprintf (tmp, "%d",xd->nr_of_kpress);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);

  strcpy (buf, "");
  strcat (buf, XHM_KEY_RELEASE);
  sprintf (tmp, "%d",convert_this->nr_of_krelease);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);
  
  /*  copy paste cut*/
  strcpy (buf, "");
  strcat (buf, XHM_PASTED_CHARACTERS);
  sprintf (tmp, "%d",convert_this->pasted_chars);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);

  strcpy (buf, "");
  strcat (buf, XHM_COPIED_CHARACTERS);
  sprintf (tmp, "%d",convert_this->copied_chars);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);

  strcpy (buf, "");
  strcat (buf, XHM_CUT_CHARACTERS);
  sprintf (tmp, "%d",convert_this->cut_chars);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);
  
  /* Button */
  strcpy (buf, "");
  strcat (buf, XHM_BUTTON_PRESS);
  sprintf (tmp, "%d",convert_this->nr_of_bpress);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);

  strcpy (buf, "");
  strcat (buf, XHM_BUTTON_RELEASE);
  sprintf (tmp, "%d",convert_this->nr_of_brelease);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);

  /* Motion */
  strcpy (buf, "");
  strcat (buf, XHM_X_PIXELS);
  sprintf (tmp, "%d",convert_this->nr_of_xpix);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);

  strcpy (buf, "");
  strcat (buf, XHM_Y_PIXELS);
  sprintf (tmp, "%d",convert_this->nr_of_ypix);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);
  

  /* Time */
  timeinfo = localtime ( &xd->sample_time_start );
  strcpy (buf, "");
  sprintf (tmp, "%.4d%.2d%.2d%.2d%.2d%.2d",
	   timeinfo->tm_year + 1900 , 
	   timeinfo->tm_mon + 1 , 
	   timeinfo->tm_mday,
	   timeinfo->tm_hour, 
	   timeinfo->tm_min ,
	   timeinfo->tm_sec  );
  
  strcat (buf, XHM_SAMPLE_TIME_START);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);

  timeinfo = localtime ( &xd->sample_time_stop );
  strcpy (buf, "");
  sprintf (tmp, "%.4d%.2d%.2d%.2d%.2d%.2d",
	   timeinfo->tm_year + 1900 , 
	   timeinfo->tm_mon + 1 , 
	   timeinfo->tm_mday,
	   timeinfo->tm_hour, 
	   timeinfo->tm_min ,
	   timeinfo->tm_sec  );
  
  strcat (buf, XHM_SAMPLE_TIME_STOP);
  strcat (buf, tmp);
  ret_str = xhm_add_data (xd, ret_str, buf, index++);



  uname(&uname_pointer);
  
  strcpy (os_tmp, XHM_OS);
  strcat (os_tmp, ":");
  strcat (os_tmp, uname_pointer.sysname);
  strcat (os_tmp, " ");
  strcat (os_tmp, uname_pointer.release);
  strcat (os_tmp, " ");
  strcat (os_tmp, uname_pointer.version);

  strcpy (buf, "");
  strcat (buf, os_tmp);

  ret_str = xhm_add_data (xd, ret_str, buf, index++);

  dpy = XOpenDisplay (NULL);
  if (dpy==NULL)
    {
      printf ("Could not open display ....... leaving \n");
      exit(0);
    }

  sprintf (tmp_str, "X%d", ProtocolVersion(dpy));
  strcpy (win_tmp,XHM_WIN_ENV);
  strcat (win_tmp,tmp_str);
  strcat (win_tmp, " ");

  sprintf (tmp_str, "%d", ProtocolRevision(dpy)); 
  strcat (win_tmp,tmp_str);
  strcat (win_tmp, " ");

  strcat (win_tmp,ServerVendor(dpy));
  strcat (win_tmp, " ");

  sprintf (tmp_str, "%d", VendorRelease(dpy));
  strcat (win_tmp,tmp_str);

  strcpy (buf, "");
  strcat (buf, win_tmp);

  ret_str = xhm_add_data (xd, ret_str, buf, index++);

  xhm_verbose (xd,"<--- xhm_data2string  \n");

  ret_str = xhm_add_data (xd, ret_str, NULL, index++);

  return ret_str;
}


xhm_data *
string2xhm_data ( xhm_data *xd, char **buf)
{
  xhm_data *ret_xd = (xhm_data *) calloc (1, sizeof (xhm_data) );
  int index=0;
  xhm_verbose (xd, "---> string2xhm_data\n");

  
  /*  for (index=0;buf[index]!=NULL;index++)
    {
      printf ("   GOT: \"%s\"   at %d\n", buf[index], index);
      ;
	     
    }
  */
  
  xhm_verbose (xd, "<--- string2xhm_data\n");
  return ret_xd;
}


int
xhm_data_full (xhm_data* xd, xhm_data *to_send)
{
  if ( 
      ((to_send->nr_of_kpress + to_send->nr_of_krelease) > 1000  )
      ||
      ( (to_send->nr_of_bpress + to_send->nr_of_brelease) > 1000  )
      ||
      ( to_send->nr_of_motions > 2000 )
      || 
      ( ( to_send->nr_of_xpix + to_send->nr_of_ypix) > 100 )
      )
    {
      xhm_verbose (xd, "Key:%d  %d  Button:%d %d   Mouse:%d %d %d\n", 
	      to_send->nr_of_kpress ,
	      to_send->nr_of_krelease,
	      to_send->nr_of_bpress ,
	      to_send->nr_of_brelease,
	      to_send->nr_of_motions,
	      to_send->nr_of_xpix,
	      to_send->nr_of_ypix);
	      
      return 1;
    }
  else
    {
      return 0;
    }
}


int
xhm_continue_collect (xhm_data* xd, int loops)
{
  if (  loops > MAX_COLLECT_LOOPS )
    {
      xhm_verbose (xd, " loops  %d > %d .... caching\n", 
		   loops, 
		   MAX_COLLECT_LOOPS); 
      return 0;
    }
  else
    {
      return 1;
    }
}



int
xhm_free_datastrings (xhm_data* xd, char** buf)
{
    int index=0;

    xhm_verbose (xd,"---> xhm_free_datastrings\n");
    xhm_verbose (xd,"---  xhm_free_datastrings freeing (char*)\n");

    while (buf[index]!=NULL)
      {
	xhm_verbose (xd,"---  xhm_free_datastrings freeing at %d \n", index);
	free(buf[index++]);
      }
    
    xhm_verbose (xd,"---  xhm_free_datastrings freeing (char**)\n");
    free(buf);

    xhm_verbose (xd,"<--- xhm_free_datastrings\n");
}


xhm_register*
xhm_new_xhm_reg(xhm_data *xd)
{

  xhm_register *xr = (xhm_register*) calloc (1, sizeof (xhm_register));
  
  xr->nick_name=NULL;
  xr->real_name=NULL;
  xr->email=NULL;
  xr->url=NULL;
  xr->os=NULL;
  xr->win_env=NULL;
}


int
xhm_free_xhm_reg( xhm_data *xd)
{
  xhm_register *xr = xd->xhm_reg;

  xhm_verbose (xd, " ---> xhm_free_xhm_reg()\n");
  free (xr->nick_name);
  free (xr->email);
  free (xr->url);
  free (xr->os);
  free (xr->win_env);
  free (xr->real_name);
  free (xr);
  xhm_verbose (xd, " <--- xhm_free_xhm_reg()\n");
}


int
xhm_rcadd_uin (xhm_data *xd, FILE* fd, int uin)
{
  char tmp[256];
  char *val;
  int do_register=False;
  char uin_str[10];
  FILE *tmpfile;
  int str_len;
  int ret;
  char tmpfile_str[100];

  strcpy (tmpfile_str, xd->xhm_ctrl->rc_name);
  strcat (tmpfile_str, ".tmp");
  tmpfile=fopen ( tmpfile_str, "w");

  xhm_verbose (xd, " ---> xhm_rcadd_uin :)\n");
  if (fd!=NULL)
    xhm_verbose (xd, " ---> xhm_rcadd_uin reading\n");
  else
    xhm_verbose (xd, " ---> xhm_rcadd_uin leaving\n");
  

  while (fgets(tmp, 256, fd)!=NULL)
    {
      if ( strncmp(tmp,XHM_UIN, strlen(XHM_UIN)) == 0 )
	{
	  int i ;
	  char *pos;
	  sprintf(uin_str, "%d", uin);
	  for (i=0;i<=str_len;i++)
	    {
	      if (  (tmp[i]=='\n') || (tmp[i]=='\r'))
		tmp[i]='\0';
	    }
	  strcat (tmp, uin_str);
	  strcat (tmp, "\n");
	}
      else
	{
	  ;
	}
      str_len=strlen(tmp);
      ret=fprintf (tmpfile, "%s", tmp);
      
      if ( ret != str_len)
	{
	  printf ("ERROR: (%d) failed to write:%s\n", ret, tmp);
	}
      else
	{
	  ;
	}
    }
  fclose (tmpfile);

  /* swap file */
  strcpy (tmp, xd->xhm_ctrl->rc_name);
  strcat (tmp, ".old");


  xhm_verbose (xd, "Removing:%s\n", tmp);
  if (unlink (tmp)!=0)
    {
      xhm_verbose (xd, "Removing:%s\n", tmp);
    };

  xhm_verbose (xd, "Renaming:\n", xd->xhm_ctrl->rc_name);
  xhm_verbose (xd, "\t%s --> %s", xd->xhm_ctrl->rc_name, tmp);
  if (ret=rename (xd->xhm_ctrl->rc_name, tmp))
    {
      xhm_verbose (xd, " Failed %d\n", errno);
      return -1;
    }
  else
    {
      xhm_verbose (xd, " OK  %d\n", ret);
    }
  xhm_verbose (xd, "\t%s --> %s", tmpfile_str,xd->xhm_ctrl->rc_name);
  if (ret=rename (tmpfile_str,xd->xhm_ctrl->rc_name))
    {
      xhm_verbose (xd, " Failed %d\n", errno);
      xhm_verbose (xd, "EISDIR     =%d\n",EISDIR); 
      xhm_verbose (xd, "EXDEV     =%d\n",EXDEV); 
      xhm_verbose (xd, "ENOTEMPTY     =%d\n",ENOTEMPTY); 
      xhm_verbose (xd, "EEXIST     =%d\n",EEXIST); 
      xhm_verbose (xd, "EBUSY     =%d\n",EBUSY); 
      xhm_verbose (xd, "EINVAL     =%d\n",EINVAL); 
      xhm_verbose (xd, "EMLINK     =%d\n",EMLINK); 
      xhm_verbose (xd, "ENOTDIR     =%d\n",ENOTDIR); 
      xhm_verbose (xd, "EFAULT     =%d\n",EFAULT); 
      xhm_verbose (xd, "EACCES     =%d\n",EACCES); 
      xhm_verbose (xd, "EPERM     =%d\n",EPERM); 
      xhm_verbose (xd, "EACCES     =%d\n",EACCES); 
      xhm_verbose (xd, "ENAMETOOLONG     =%d\n",ENAMETOOLONG); 
      xhm_verbose (xd, "ENOENT     =%d\n",ENOENT); 
      xhm_verbose (xd, "ENOMEM     =%d\n",ENOMEM); 
      xhm_verbose (xd, "EROFS     =%d\n",EROFS); 
      xhm_verbose (xd, "ELOOP     =%d\n",ELOOP); 
      xhm_verbose (xd, "ENOSPC     =%d\n",ENOSPC);  


      return -1;
    }
  else
    {
      xhm_verbose (xd, " OK %d\n"), ret;
    }
  return 0;
  xhm_verbose (xd, " <--- xhm_rcadd_uin \n");
}
