/*****
 *       xhackometer - part of the Hackometer project
 *                                                                   
 * xhackometer records keyboard and mouse and cache files
 * for later delivery to hackometer server
 *                                                                   
 *        Copyright (C) 2009 Henrik Sandklef      
 *                                                                   
 * This program is free software; you can redistribute it and/or     
 * modify it under the terms of the GNU General Public License       
 * as published by the Free Software Foundation; either version 3    
 * of the License, or any later version.                             
 *                                                                   
 *                                                                   
 * This program is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
 * GNU General Public License for more details.                      
 *                                                                   
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software       
 * Foundation, Inc., 51 Franklin Street, Boston,            
 * MA  02110-1301, USA.                                              
 ****/


#include <sys/stat.h>
#include <dirent.h>

#include "xhm/xhm.h"
#include "send/send.h"
#include "cache/cache.h"
#include "cache/file.h"



int 
xhm_cache_create_dir(xhm_data *xd)
{
  char buf[MAX_FILE_NAME_LENGTH];
  char file_buf[MAX_FILE_NAME_LENGTH];
  char * home_dir = getenv ("HOME");
  struct stat cache ;
  DIR *cache_dir;
  int ret_val=0 ;


  xhm_verbose (xd,"---> create_dir\n");

  if ( home_dir!=NULL)
    {
      strcpy (buf, home_dir);
      strcat (buf, "/");
      strcat (buf, XHM_LOCAL_DIR);
      strcat (buf, "/");
      strcat (buf, XHM_LOCAL_CACHE);
      xhm_verbose (xd,"Trying to find dir (for cache): \"%s\"\n", buf);
      if (stat ( buf, &cache))
	{
	  strcpy (buf, home_dir);
	  strcat (buf, "/");
	  strcat (buf, XHM_LOCAL_DIR);
	  if (stat ( buf, &cache))
	    {
	      xhm_verbose (xd," ... creating %s\n", buf);
	      if (! mkdir(buf, (mode_t) 0700 ))
		{
		  xhm_verbose (xd," ...  ... darn I failed to create %s\n", buf);
		  ret_val= XHM_NO_CACHE_FOUND;
		}
	      else
		{
		  xhm_verbose (xd," ... created %s \n", buf);
		}
	    }
	  strcat (buf, "/");
	  strcat (buf, XHM_LOCAL_CACHE);
	  xhm_verbose (xd," ... creating %s\n", buf);
	  if (! mkdir(buf, (mode_t) 0700 ))
	    {
	      xhm_verbose (xd," ...  ... darn I failed to create %s\n", buf);
	      ret_val= XHM_NO_CACHE_FOUND;
	    }
	  else
	    {
	      xhm_verbose (xd," ... created %s\n",buf);
	    }
	}
    }
  else
    {
      xhm_verbose (xd," ...  no home dir found\n");
      ret_val= XHM_NO_CACHE_FOUND;
    }

  xhm_verbose (xd,"<--- create_dir returns %d\n", ret_val);
  return ret_val;
}




int
xhm_do_write_cache (xhm_data *xd, FILE* cache_file)
{
  char **data_string;
  int index=0;
  
  xhm_verbose (xd,"---> xhm_do_write_cache\n");

  if (cache_file==NULL) 
    {
      xhm_verbose (xd,"<--- xhm_do_write_cache  (no file found)\n");
      return XHM_NO_CACHE_FOUND;
    }

  data_string = xhm_data2string (xd, NULL );

  /* HESA HESA HESA FIX FIX */
  /* UGLY HACK TO PRINT TO STDOUT */
/*   cache_file = stdout; */
  /* */

  if (data_string!=NULL)
    {
      fprintf (cache_file, "####################################\n");
      fprintf (cache_file, "#\n");
      fprintf (cache_file, "#   cached data for xhackometer\n");
      fprintf (cache_file, "#\n");
      fprintf (cache_file, "#\n");

      while (data_string[index]!=NULL)
	{
	  fprintf (cache_file, "%s\n", data_string[index]);
	  index++;
	}
      
      xhm_free_datastrings (xd, data_string);

      
    }
  else
    {
      xhm_verbose (xd,"<--- xhm_do_write_cache  (no file found)\n");
      return XHM_NO_CACHE_FOUND;
    }
  xhm_verbose (xd,"<--- xhm_do_write_cache \n");
  return 0;
}




int 
xhm_file_cache (xhm_data *xd)
{
  static char base_buf[MAX_FILE_NAME_LENGTH];
  char buf[MAX_FILE_NAME_LENGTH];
  char * home_dir = getenv ("HOME");
  struct stat cache ;
  DIR *cache_dir = NULL ;
  int ret_val=0 ;
  FILE *cache_file = NULL;
  static int init_done = 0 ;
  int suffix=1;
  char date_string[MAX_FILE_NAME_LENGTH];
  char file_string[MAX_FILE_NAME_LENGTH];
  time_t rawtime;
  struct tm * timeinfo;
  
  xhm_verbose (xd, "---> xhm_cache_data()\n");

  printf ("CACHE DONE\n");

  /* set stop time */
  time ( &xd->sample_time_stop );

  if ( !init_done )
    {

      ret_val = xhm_cache_create_dir(xd);
      
      if (ret_val)
	{
	  xhm_verbose (xd, "<--- xhm_cache_data()\n");
	  return ret_val;
	}
      
      strcpy (base_buf, home_dir);
      strcat (base_buf, "/");
      strcat (base_buf, XHM_LOCAL_DIR);
      strcat (base_buf, "/");
      strcat (base_buf, XHM_LOCAL_CACHE);
      xhm_verbose (xd,"Trying to find dir (for cache) again: \"%s\"\n", buf);
      printf("Trying to find dir (for cache) again: \"%s\"\n", buf);
      
      if (!stat ( buf, &cache))
	{
	  xhm_verbose (xd," ... found it\n");
	  if ( S_ISDIR (cache.st_mode) )
	    {
	      xhm_verbose (xd," ... and it's a dir\n" );
	      cache_dir=opendir (buf);
	      if (cache_dir==NULL)
		{
		  closedir (cache_dir);
		  cache_dir = NULL;
		  return XHM_NO_CACHE_FOUND;
		}
	    }
	}
      init_done=1;
    }


  printf ("INIT DONE\n");

  printf ("EMPTY %d\n", xhm_is_empty(xd));

  if ( xhm_is_empty(xd))
    {
      printf ("EMPTY\n");
      return 0;
    }
  else
    {
      printf ("HAS DATA\n");
    }
  printf ("  \n");
		  
  time ( &rawtime );
  timeinfo = localtime ( &rawtime );
  strcpy (buf, base_buf);
  strcat (buf, "/");
  sprintf (date_string, "%.4d%.2d%.2d-%.2d:%.2d",
	   timeinfo->tm_year + 1900 , timeinfo->tm_mon + 1 , timeinfo->tm_mday,
	   timeinfo->tm_hour, timeinfo->tm_min  );
  
  strncpy (file_string, buf, MAX_FILE_NAME_LENGTH);
  strcat (file_string, date_string);
  strcat (file_string, XHM_CACHE_FILE_SUFFIX);

  printf ("  FILE WILL BE %s\n", buf);
  
  xhm_verbose (xd, "Initially trying file=\"%s\"\n\n", file_string);
  while (!stat ( file_string, &cache))
    {
      char suff[10];
      xhm_verbose (xd, "trying file=\"%s\"   base dir=%s\n\n", file_string, buf);
      sprintf (suff, "_%.4d", suffix++);
      /* 		  printf("trying file=\"%s\"   base dir=%s  suff='%s'\n\n", file_string, buf, suff); */
      strcpy (file_string, buf);
      strcat (file_string, date_string);
      strcat (file_string, suff);
      strcat (file_string, XHM_CACHE_FILE_SUFFIX);
    }
  xhm_verbose (xd, "file_string = %s\n", file_string);
  cache_file=fopen (file_string, "w");
  
  /* 	      printf( "file_string = %s  %d\n", file_string, cache_file); */
  
  xhm_verbose (xd, " writing to file = %s\n", file_string);
  if (cache_file==NULL)
    {
      ret_val= XHM_NO_CACHE_FOUND;
    }
  else
    {
      xhm_do_write_cache (xd, cache_file);
      fclose (cache_file);
    }
  xhm_verbose (xd, "wrote to file\n");

  xhm_verbose (xd,"<--- xhm_cache_data\n");

  printf ("CACHE DONE\n");

  xhm_null_struct (xd);

  /* set start time */
  time ( &xd->sample_time_start );

  return ret_val;
}

