/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<stdio.h>
#include<string.h>

#ifdef HAVE_VSNPRINTF
#define VSNPRINTF "-DHAVE_VSNPRINTF"
#else
#define VSNPRINTF ""
#endif

#ifdef STOP_AT_ERROR
#define ERRFLAG "-DSTOP_AT_ERROR"
#else
#define ERRFLAG ""
#endif

#ifdef USE_LONG_DOUBLE
#define LDBL "-DUSE_LONG_DOUBLE"
#else
#define LDBL ""
#endif

#ifdef BE_STRICT
#define IF_VAR_UNDEF "-DBE_STRICT"
#else
#define IF_VAR_UNDEF ""
#endif

/* The macros VERSION, IPATH and LPATH are directly defined on the */
/* command line to the compiler.                                   */

#ifndef VERSION
#define VERSION "unknown"
#endif

#ifndef IPATH
#define IPATH ""
#endif

#ifndef LPATH
#define LPATH ""
#endif

/* Possible options: -v, -c, -l, -n */

int main (int argc, char* argv[])
{
  int i;
  unsigned char flag = 0;
  unsigned char v, c, l, n;

  if ( argc == 1)
    {
      fprintf (stderr, "*** Usage:  %s [-v] [-n] or\n", argv[0]);
      fprintf (stderr, "***         %s [-c] [-l] [-n]\n\n", argv[0]);
      fprintf (stderr, "*** Meaning of the options:\n");
      fprintf (stderr, "    -v      return the current version of XXCalc\n");
      fprintf (stderr, "    -c      return flags to compile using XXCalc\n");
      fprintf (stderr, "    -l      return flags to link  against XXCalc\n");
      fprintf (stderr, "    -n      insert a newline at the end\n\n");
      return 0;
    }
  else if ( argc > 5 )
    {
      fprintf (stderr, "*** Usage:  %s [-v] [-n] or\n", argv[0]);
      fprintf (stderr, "***         %s [-c] [-l] [-n]\n\n", argv[0]);
      return 1;
    }
  else
    {
      for (i=1; i<argc; i++)
	{
	  if ( strcmp ("-v", argv[i]) == 0 )
	    {
	      if (flag != 0 && flag != 8)
		{
		  fprintf (stderr, "*** Usage:  %s [-v] [-n] or\n", argv[0]);
		  fprintf (stderr, "***         %s [-c] [-l] [-n]\n\n", 
			   argv[0]);
		  return 1;
		}
	      else
		flag += 1;
	    }
	  else if ( strcmp ("-c", argv[i]) == 0 )
	    {
	      if ((flag % 2 == 1) || ((flag >> 1) % 2 == 1))
		{
		  fprintf (stderr, "*** Usage:  %s [-v] [-n] or\n", argv[0]);
		  fprintf (stderr, "***         %s [-c] [-l] [-n]\n\n", 
			   argv[0]);
		  return 1;
		}
	      else
		flag += 2;
	    }
	  else if ( strcmp ("-l", argv[i]) == 0 )
	    {
	      if ((flag % 2 == 1) || ((flag >> 2) % 2 == 1))
		{
		  fprintf (stderr, "*** Usage:  %s [-v] [-n] or\n", argv[0]);
		  fprintf (stderr, "***         %s [-c] [-l] [-n]\n\n",
			   argv[0]);
		  return 1;
		}
	      else
		flag += 4;
	    }
	  else if ( strcmp ("-n", argv[i]) == 0 )
	    {
	      if ((flag >> 3) % 2 == 1)
		{
		  fprintf (stderr, "*** Usage:  %s [-v] [-n] or\n", argv[0]);
		  fprintf (stderr, "***         %s [-c] [-l] [-n]\n\n",
			   argv[0]);
		  return 1;
		}
	      else
		flag += 8;
	    }
	  else
	    {
	      fprintf (stderr, "*** Usage:  %s [-v] [-n] or\n", argv[0]);
	      fprintf (stderr, "***         %s [-c] [-l] [-n]\n\n", argv[0]);
	      return 1;
	    }
	} /* end for */
      v = flag % 2;
      c = (flag >> 1) % 2;
      l = (flag >> 2) % 2;
      n = (flag >> 3) % 2;
      if ( (v) )
	printf (VERSION);
      if ( (c) )
	{
	  printf ("%s %s %s %s ", VSNPRINTF, ERRFLAG, LDBL, IF_VAR_UNDEF);
	  printf (IPATH);
	  putchar (' ');
	}
      if ( (l) )
	{
	  printf (LPATH);
	  putchar (' ');
	  printf ("-lxxcalc ");
	  printf ("-lm"); 
	}
      if ( (n) )
	printf("\n");
      else
	fflush (stdout);
      return 0;
    } /* end else */
} 
