/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<stdlib.h>
#include<string.h>
#include"tokstack.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif

static xx_mathtoken *
newtok (b_yte type, long priority, c_omplex value,
	const char *name, str_s_ize lname)
{
  xx_mathtoken *ptok = (xx_mathtoken *) malloc (sizeof (xx_mathtoken));
  str_s_ize n = XX_MAX_NDIM - 1 <= lname ? XX_MAX_NDIM - 1 : lname; 

  if (!ptok)
    return NULL;
  else
    {
      ptok->type = type;
      ptok->pr = priority;
      ptok->value = value;
      strncpy (ptok->name, name, n);
      ptok->name[n] = '\0';
      return ptok;
    }
}

static void
deltok (xx_mathtoken * ptok)
{
  free ((void *) ptok);
}

void
xx_ts_init (xx_tokstack * ts)
{
  ts->first = NULL;
  ts->length = 0;
}

int
xx_ts_push (xx_tokstack * ts, b_yte type, long priority, c_omplex value,
	    const char *name, str_s_ize lname)
{
  xx_toknode *p;

  if (!(p = (xx_toknode *) malloc (sizeof (xx_toknode))))
    return 0;
  else if (!(p->ptoken = newtok (type, priority, value, name, lname)))
    {
      free ((void *) p);
      return 0;
    }
  else
    {
      p->next = ts->first;
      ts->first = p;
      ts->length++;
      return 1;
    }
}

void
xx_ts_pop (xx_tokstack * ts)
{
  xx_toknode *p;

  if (!ts->first)
    return;
  else
    {
      p = ts->first;
      ts->first = p->next;
      deltok (p->ptoken);
      free ((void *) p);
      ts->length--;
    }
}

void
xx_ts_destroy (xx_tokstack * ts)
{
  xx_toknode *p;

  while ((ts->first))
    {
      p = ts->first;
      ts->first = p->next;
      deltok (p->ptoken);
      free ((void *) p);
    }
  ts->length = 0;
}

int
xx_ts_top (xx_tokstack ts, xx_mathtoken * ptok)
{
  if (!ts.first)
    return 0;
  else
    {
      ptok->type = ts.first->ptoken->type;
      ptok->pr = ts.first->ptoken->pr;
      ptok->value = ts.first->ptoken->value;
      strncpy (ptok->name, ts.first->ptoken->name, XX_MAX_NDIM - 1);
      ptok->name[XX_MAX_NDIM - 1] = '\0';
      return 1;
    }
}

static xx_toknode *xx_ts_iterator = NULL;

const xx_mathtoken *
xx_ts_run (const xx_tokstack * ts)
{
  static const xx_mathtoken *ptok;

  if ((ts))
    xx_ts_iterator = ts->first;
  if (!xx_ts_iterator)
    return NULL;
  else
    {
      ptok = (const xx_mathtoken *) xx_ts_iterator->ptoken;
      xx_ts_iterator = xx_ts_iterator->next;
      return ptok;
    }
}

int
xx_ts_isempty (xx_tokstack ts)
{
  return (!ts.first);
}

ui_nteger
xx_ts_len (xx_tokstack ts)
{
  return ts.length;
}
