/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<stdio.h>
#include<stdlib.h>
#include<xxcalc/evaluate.h>
/* Do not put the 3 lines below in your programs ! They are useful only for */
/* enhanced debugging (if you have the Dmalloc library).                    */
#ifdef DMALLOC 
#include <dmalloc.h>
#endif

static int
bgetline (char *s, unsigned long size, FILE * pf)
{
  int i = 0, n = 0;
  char ch;

  if (!size || (feof (pf)) || (ferror (pf)))
    return -1;
  else
    {
      while ((ch = getc (pf)) != EOF && ch != '\n')
	{
	  if (n < size - 1)
	    s[n++] = ch;
	  i++;
	}
    }
  s[n] = '\0';
  return (ch == EOF ? -1 - i : i);
}

int
main (void)
{
  int i;
  char input[500];
  c_omplex z;
  char name[50];
  char *suffix[] = {
    "A", "B", "C",
    "D", "E", "F",
    "G", "H", "I", "J",
    NULL
  };
  unsigned currstack = 0, currlist = 0, n, counter;
  char **yanl;
  c_omplex *yavl;
  ui_nteger j, nvars;

  printf ("Starting program\n");
  if (!xx_mkstacks (5))
    {
      fprintf (stderr, "Cannot create the requested stack(s), aborting.\n");
      return -1;
    }
  else
    printf ("Created %u stack(s)\n", xx_gettns ());
  if (!xx_mklists (3))
    {
      fprintf (stderr,
	       "Cannot create the requested list(s) of variables, aborting.\n");
      return -1;
    }
  else
    printf ("Created %u list(s) of variables\n", xx_gettnl ());
  printf ("Loading varlists...");
  fflush (stdout);
  for (i = 0; suffix[i] != NULL; i++)
    {
      snprintf (name, 50, "X%s", suffix[i]);
      if (!xx_addvar (0, name, c_reset (i, 0)))
	{
	  fprintf (stderr,
		   "Cannot load variables in the list 0, aborting.\n");
	  return -1;
	}
    }
  for (i = 0; suffix[i] != NULL; i++)
    {
      snprintf (name, 50, "Y%s", suffix[i]);
      if (!xx_addvar (1, name, c_reset (0, i)))
	{
	  fprintf (stderr, "Cannot load variables in the list 1, aborting\n");
	  return -1;
	}
    }
  for (i = 0; suffix[i] != NULL; i++)
    {
      snprintf (name, 50, "Z%s", suffix[i]);
      if (!xx_addvar (2, name, c_reset (i, i)))
	{
	  fprintf (stderr, "Cannot load variables in the list 2, aborting\n");
	  return -1;
	}
    }
  printf ("done.\n");
  printf ("Insert an expression or command, then hit <Return>\n");
  printf ("Available commands:\n");
  printf
    ("@\t- Re-evaluate the current stack using the current variable-list\n");
  printf
    ("@d#\t- Display the contents of the variable-list # (must be 0 <= # < %u)\n",
     xx_gettnl ());
  printf ("@l#\t- Switch to use the variable-list # (must be 0 <= # < %u)\n",
	  xx_gettnl ());
  printf ("@ns\t- Create a new empty stack\n");
  printf ("@nl\t- Create a new empty list\n");
  printf ("@s#\t- Switch to use the stack # (must be 0 <= # < %u)\n",
	  xx_gettns ());
  printf ("@L\t- List the names of all the variables in the current stack\n");  
  printf ("@m\t- Allow for usage of implicit multiplication\n");
  printf ("@M\t- Forbid usage of implicit multiplication\n");  
  printf ("@q\t- Quit the program\n");
  counter = 0;
  do
    {
      printf ("[%u]  ", ++counter);
      bgetline (input, 500, stdin);
      if (input[0] == '@')
	{
	  switch (input[1])
	    {
	    case '\0':
	      z = xx_eval (NULL, currstack, currlist, 0);
	      printf ("\nResult=\t");
	      c_wrt (1, 12, z);
	      putchar ('\n');
	      fprintf (stderr, "%s\n", xx_errmsg ());
	      break;
	    case 's':
	      if (sscanf (input + 2, "%u", &n) == 0)
		fprintf (stderr, "Invalid command\n");
	      else
		currstack = n;
	      break;
	    case 'l':
	      if (sscanf (input + 2, "%u", &n) == 0)
		fprintf (stderr, "Invalid command\n");
	      else
		currlist = n;
	      break;
	    case 'n':
	      if (input[2] == 's')
		xx_addnewstack ();
	      else if (input[2] == 'l')
		xx_addnewlist ();
	      else
		fprintf (stderr, "Invalid command\n");
	      break;
	    case 'd':
	      if (sscanf (input + 2, "%u", &n) < 1)
		fprintf (stderr, "Invalid command\n");
	      else if (!xx_readlist (n, &yanl, &yavl))
		fprintf (stderr, "Cannot scan the variable-list %u\n", n);
	      else
		{
		  if (!yanl)
		    printf ("List %u is empty\n", n);
		  else
		    {
		      printf ("List %u\n", n);
		      for (i = 0; yanl[i] != NULL; i++)
			{
			  printf ("%s\t= ", yanl[i]);
			  c_wrt (1, 12, yavl[i]);
			  putchar ('\n');
			  free ((void *) yanl[i]);
			}
		      free ((void *) yanl);
		      free ((void *) yavl);
		    }
		}
	      break;
	    case 'L':
	      if ( !(yanl = xx_findvars (currstack, &nvars)) )
		fprintf (stderr, "Operation failed (stack empty?)\n");
	      else
		{
		  printf ("Number of the variables found "		\
			  "in the current stack: %lu\n", nvars);
		  if (nvars > 0)
		    {
		      printf ("Names of the variables:\n");
		      for (j = 0; j < nvars; j++)
			{
			  printf ("%s\n", yanl[j]);
			  free ((void *) yanl[j]);	
			}
		    }
		  free ((void *) yanl);		      
		}
	      break;
	    case 'm':
	      xx_allow_implicit_multiplication();
	      break;
	    case 'M':
	      xx_forbid_implicit_multiplication();
	      break;
	    case 'q':
	      goto quit_program;
	      break;
	    default:
	      fprintf (stderr, "Invalid command\n");
	    }
	}
      else
	{
	  z = xx_eval (input, currstack, currlist, 0);
	  printf ("\nResult=\t");
	  c_wrt (1, 12, z);
	  putchar ('\n');
	  fprintf (stderr, "%s\n", xx_errmsg ());
	}
      printf (">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
    }
  while ((*input));
 quit_program:
  printf ("Deleting stacks and lists...");
  xx_rmstacks ();
  xx_rmlists ();
  printf ("done.\n");
  printf ("Program terminated, bye!\n");
  return 0;
}
