/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<stdio.h>
#include<stdlib.h>
#include<xxcalc/compl.h>
#include<xxcalc/evaluate.h>
/* Do not put the 3 lines below in your programs ! They are useful only for */
/* enhanced debugging (if you have the Dmalloc library).                    */
#ifdef DMALLOC 
#include <dmalloc.h>
#endif

#define FAILURE 0

int
main (void)
{
  const char *nlist[] = {
    "XA", "AX", "YA", "AY", "ZZ", "X", "Y", "Z", NULL
  };
  c_omplex vlist[] = {
    {-1, -1},
    {-2, -2},
    {-3, -3},
    {-4, -4},
    {0, 0},
    {1, 1},
    {2, 2},
    {3, 3}
  };
  const char *namelist[] = {
    "AXAXA",
    "A_B",
    "ABC_ABC_ABC_S",
    "_EFD",
    "A b",
    "CDCDCDCDCDD",
    "X_3__",
    "H",
    "PRICE",
    "CD_",
    "C.CDCD_CD",
    "",
    "CDE1",
    " AB",
    "2CDCDCDCDCD",
    "__A",
    "A__C",
    "XYZXYZXYZXYZ_",
    "A___",
    NULL
  };
  const char *yanl[] = {
    "XFA",
    "XFB",
    "XFC",
    "XFD",
    "XFE",
    "X",
    "Y",
    "Z",
    NULL
  };
  c_omplex yavl[] = {
    {0, 0},
    {1, -1},
    {2, -2},
    {3, -3},
    {4, -4},
    {5, -5},
    {6, -6},
    {7, -7}
  };
  const char *ans[2] = {
    "NOT VALID",
    "VALID"
  };
  int i, isdef;
  char **dyn_namelist;
  c_omplex *dyn_valuelist;

  printf ("\nAt the start we have %u varlist(s) allocated\n", xx_gettnl ());
  if (xx_mklists (5) == FAILURE)
    fprintf (stderr, "Cannot create %u lists\n", 5);
  else
    printf ("Created %u list(s)\n", xx_gettnl ());
  printf ("We are going to check if some strings are or are not\n");
  printf ("valid variable-names\n");
  for (i = 0; namelist[i] != NULL; i++)
    printf ("%s:\t\t %s\n", namelist[i], ans[xx_validname (namelist[i])]);
  printf ("The first unacceptable name is the string %ld\n",
	  -xx_validnames (namelist));
  printf ("**********************************************************\n");
  printf ("Is the varlist 10 empty ? (1=T,0=F,-1=UNEX. LIST) %d\n",
	  xx_is_list_empty (10));
  printf ("Anyway, I will try to scan the varlist 10...");
  fflush (stdout);
  if (xx_readlist (10, &dyn_namelist, &dyn_valuelist) == FAILURE)
    fprintf (stderr, "Cannot scan varlist 10\n");
  else if (dyn_namelist == NULL)
    fprintf (stderr, "Warning: the varlist 10 is empty\n");
  else
    {
      printf ("The elements of the varlist 10 are:\n");
      for (i = 0; dyn_namelist[i] != NULL; i++)
	{
	  printf ("Name:\t%s\t Value", dyn_namelist[i]);
	  c_wrt (1, 6, dyn_valuelist[i]);
	  putchar ('\n');
	}
    }
  printf ("Is the varlist 0 empty ? (1=T,0=F,-1=UNEX. LIST) %d\n",
	  xx_is_list_empty (0));
  printf ("In fact, the varlist 0 has %lu elements\n", xx_getll (0));
  printf ("Anyway, I will try to scan the varlist 0...");
  fflush (stdout);
  if (xx_readlist (0, &dyn_namelist, &dyn_valuelist) == FAILURE)
    fprintf (stderr, "Cannot scan varlist 0\n");
  else if (dyn_namelist == NULL)
    fprintf (stderr, "Warning: the varlist 0 is empty\n");
  else
    {
      printf ("The elements of the varlist 0 are:\n");
      for (i = 0; dyn_namelist[i] != NULL; i++)
	{
	  printf ("Name:\t%s\t Value", dyn_namelist[i]);
	  c_wrt (1, 6, dyn_valuelist[i]);
	  putchar ('\n');
	}
    }
  if (!xx_addvars (0, nlist, vlist))
    fprintf (stderr, "Cannot add variables to the list 0\n");
  else
    printf ("*** Added variables to the list 0\n");
  printf ("Is the varlist 0 empty now ? (1=T,0=F,-1=UNEX. LIST) %d\n",
	  xx_is_list_empty (0));
  printf ("In fact, the varlist 0 has %lu elements\n", xx_getll (0));
  if (xx_readlist (0, &dyn_namelist, &dyn_valuelist) == FAILURE)
    fprintf (stderr, "Cannot scan varlist 0\n");
  else if (dyn_namelist == NULL)
    fprintf (stderr, "Warning: the varlist 0 is empty\n");
  else
    {
      printf ("The elements of the varlist 0 are:\n");
      for (i = 0; dyn_namelist[i] != NULL; i++)
	{
	  printf ("Name:\t%s\t Value", dyn_namelist[i]);
	  c_wrt (1, 6, dyn_valuelist[i]);
	  putchar ('\n');
	}
    }
  for (i = 0; dyn_namelist[i] != NULL; i++)
    free ((void *) dyn_namelist[i]);
  free ((void *) dyn_namelist);
  free ((void *) dyn_valuelist);
  /* Until here we have tested xx_is_list_empty(), xx_getll() and xx_readlist(). */
  /* Now is the turn of xx_getvar(), xx_getvars().                            */
  printf ("We are looking for some variables inside the lists 0,1,10.\n");
  printf ("List 0:\n");
  printf ("Name: \t\"H\"\t Value: ");
  c_wrt (1, 6, xx_getvar (0, "H", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"CDCD\"\t Value: ");
  c_wrt (1, 6, xx_getvar (0, "CDCD", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"CDE\"\t Value: ");
  c_wrt (1, 6, xx_getvar (0, "CDE", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"PRICE\"\t Value: ");
  c_wrt (1, 6, xx_getvar (0, "PRICE", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"AX\"\t Value: ");
  c_wrt (1, 6, xx_getvar (0, "AX", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"AY\"\t Value: ");
  c_wrt (1, 6, xx_getvar (0, "AY", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"ZZ\"\t Value: ");
  c_wrt (1, 6, xx_getvar (0, "ZZ", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"\"\t Value: ");
  c_wrt (1, 6, xx_getvar (0, "", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"*\"\t Value: ");
  c_wrt (1, 6, xx_getvar (0, NULL, &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  /* *** */
  printf ("\nList 1:\n");
  printf ("Name: \t\"H\"\t Value: ");
  c_wrt (1, 6, xx_getvar (1, "H", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"CDCD\"\t Value: ");
  c_wrt (1, 6, xx_getvar (1, "CDCD", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"CDE\"\t Value: ");
  c_wrt (1, 6, xx_getvar (1, "CDE", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"PRICE\"\t Value: ");
  c_wrt (1, 6, xx_getvar (1, "PRICE", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"AX\"\t Value: ");
  c_wrt (1, 6, xx_getvar (1, "AX", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"AY\"\t Value: ");
  c_wrt (1, 6, xx_getvar (1, "AY", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"ZZ\"\t Value: ");
  c_wrt (1, 6, xx_getvar (1, "ZZ", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  /* *** */
  printf ("\nList 5:\n");
  printf ("Name: \t\"H\"\t Value: ");
  c_wrt (1, 6, xx_getvar (5, "H", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"CDCD\"\t Value: ");
  c_wrt (1, 6, xx_getvar (5, "CDCD", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"CDE\"\t Value: ");
  c_wrt (1, 6, xx_getvar (5, "CDE", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"PRICE\"\t Value: ");
  c_wrt (1, 6, xx_getvar (5, "PRICE", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"AX\"\t Value: ");
  c_wrt (1, 6, xx_getvar (5, "AX", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"AY\"\t Value: ");
  c_wrt (1, 6, xx_getvar (5, "AY", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("Name: \t\"ZZ\"\t Value: ");
  c_wrt (1, 6, xx_getvar (5, "ZZ", &isdef));
  printf ("\t Is it defined\?(1=Yes, 0=No) %d\n", isdef);
  printf ("I want to add some variables to the varlist 1:\n");
  for (i = 0; yanl[i] != NULL; i++)
    {
      if (!xx_addvar (1, yanl[i], c_reset (i, -i)))
	fprintf (stderr, "Cannot add \"%s\" to the varlist 1\n", yanl[i]);
      else
	{
	  printf ("Added \"%s\" with value ", yanl[i]);
	  c_wrt (1, 6, c_reset (i, -i));
	  putchar ('\n');
	}
    }
  printf ("done.\n\n");
  /*                              */
  /* Now starts the 2nd search    */
  /*                              */
  printf ("Now starts the second search: we are looking for a new\n");
  printf ("set of variables.\n");
  if (!(dyn_valuelist = xx_getvars (0, nlist)))
    fprintf (stderr, "Error occurred in scanning varlist 0\n");
  else
    {
      printf ("Varlist 0\n");
      for (i = 0; nlist[i] != NULL; i++)
	{
	  printf ("Name: \t%s\t Value: ", nlist[i]);
	  c_wrt (1, 6, dyn_valuelist[i]);
	  putchar ('\n');
	}
      free ((void *) dyn_valuelist);
    }
  if (!(dyn_valuelist = xx_getvars (1, nlist)))
    fprintf (stderr, "Error occurred in scanning varlist 1\n");
  else
    {
      printf ("Varlist 1\n");
      for (i = 0; nlist[i] != NULL; i++)
	{
	  printf ("Name: \t%s\t Value: ", nlist[i]);
	  c_wrt (1, 6, dyn_valuelist[i]);
	  putchar ('\n');
	}
      free ((void *) dyn_valuelist);
    }
  if (!(dyn_valuelist = xx_getvars (5, nlist)))
    fprintf (stderr, "Error occurred in scanning varlist 5\n");
  else
    {
      printf ("Varlist 5\n");
      for (i = 0; nlist[i] != NULL; i++)
	{
	  printf ("Name: \t%s\t Value: ", nlist[i]);
	  c_wrt (1, 6, dyn_valuelist[i]);
	  putchar ('\n');
	}
      free ((void *) dyn_valuelist);
    }
  /*                              */
  /* Now starts the 3rd search    */
  /*                              */
  printf ("Now starts the third search: we are looking for a new\n");
  printf ("set of variables.\n");
  if (!(dyn_valuelist = xx_getvars (0, yanl)))
    fprintf (stderr, "Error occurred in scanning varlist 0\n");
  else
    {
      printf ("Varlist 0\n");
      for (i = 0; yanl[i] != NULL; i++)
	{
	  printf ("Name: \t%s\t Value: ", yanl[i]);
	  c_wrt (1, 6, dyn_valuelist[i]);
	  putchar ('\n');
	}
      free ((void *) dyn_valuelist);
    }
  if (!(dyn_valuelist = xx_getvars (1, yanl)))
    fprintf (stderr, "Error occurred in scanning varlist 1\n");
  else
    {
      printf ("Varlist 1\n");
      for (i = 0; yanl[i] != NULL; i++)
	{
	  printf ("Name: \t%s\t Value: ", yanl[i]);
	  c_wrt (1, 6, dyn_valuelist[i]);
	  putchar ('\n');
	}
      free ((void *) dyn_valuelist);
    }
  if (!(dyn_valuelist = xx_getvars (5, yanl)))
    fprintf (stderr, "Error occurred in scanning varlist 5\n");
  else
    {
      printf ("Varlist 5\n");
      for (i = 0; yanl[i] != NULL; i++)
	{
	  printf ("Name: \t%s\t Value: ", yanl[i]);
	  c_wrt (1, 6, dyn_valuelist[i]);
	  putchar ('\n');
	}
      free ((void *) dyn_valuelist);
    }
  /* Now is the turn of xx_setvar(), xx_setvars(). */
  printf ("We are going to change the values of some variables of\n");
  printf ("the varlist 0 and 1.\n");
  printf ("Now varlist 0 contains the variables: \n");
  for (i = 0; nlist[i] != NULL; i++)
    printf ("\"%s\" ", nlist[i]);
  printf ("\nwhile the variables in varlist 1 are: \n");
  for (i = 0; yanl[i] != NULL; i++)
    printf ("\"%s\" ", yanl[i]);
  printf ("\nLet us start with the varlist 0\n");
  for (i = 0; nlist[i] != NULL; i++)
    {
      if (!xx_setvar (0, nlist[i], c_convert ((i + 1) * 1000)))
	fprintf (stderr, "Cannot reset \"%s\" in varlist 0\n", nlist[i]);
      else
	{
	  printf ("The new value of \"%s\" is \t", nlist[i]);
	  c_wrt (1, 6, c_convert ((i + 1) * 1000));
	  putchar ('\n');
	}
    }
  for (i = 0; yanl[i] != NULL; i++)
    {
      if (!xx_setvar (0, yanl[i], c_convert ((i + 1) * 1000)))
	fprintf (stderr, "Cannot reset \"%s\" in varlist 0\n", yanl[i]);
      else
	{
	  printf ("The new value of \"%s\" is \t", yanl[i]);
	  c_wrt (1, 6, c_convert ((i + 1) * 1000));
	  putchar ('\n');
	}
    }
  if (!xx_setvar (0, NULL, c_convert ((i + 1) * 1000)))
    fprintf (stderr, "Cannot reset NULL in varlist 0\n");
  if (!xx_setvar (0, "", c_convert ((i + 1) * 1000)))
    fprintf (stderr, "Cannot reset \"\" in varlist 0\n");
  /* *** */
  printf ("Now is the turn of the varlist 1\n");
  for (i = 0; nlist[i] != NULL; i++)
    {
      if (!xx_setvar (1, nlist[i], c_reset (0, (i + 1) * 1000)))
	fprintf (stderr, "Cannot reset \"%s\" in varlist 0\n", nlist[i]);
      else
	{
	  printf ("The new value of \"%s\" is \t", nlist[i]);
	  c_wrt (1, 6, c_reset (0, (i + 1) * 1000));
	  putchar ('\n');
	}
    }
  for (i = 0; yanl[i] != NULL; i++)
    {
      if (!xx_setvar (1, yanl[i], c_reset (0, (i + 1) * 1000)))
	fprintf (stderr, "Cannot reset \"%s\" in varlist 0\n", yanl[i]);
      else
	{
	  printf ("The new value of \"%s\" is \t", yanl[i]);
	  c_wrt (1, 6, c_reset (0, (i + 1) * 1000));
	  putchar ('\n');
	}
    }
  printf ("We can try to do the same with the varlist 5, but...\n");
  for (i = 0; yanl[i] != NULL; i++)
    {
      if (!xx_setvar (5, yanl[i], c_convert ((i + 1) * 1000)))
	fprintf (stderr, "Cannot reset \"%s\" in varlist 0\n", yanl[i]);
      else
	{
	  printf ("The new value of \"%s\" is \t", yanl[i]);
	  c_wrt (1, 6, c_convert ((i + 1) * 1000));
	  putchar ('\n');
	}
    }
  /* xx_setvars() */
  printf ("Now we return to the precedent values of the variables\n");
  printf ("of the varlists 0 and 1.\n");
  if (!xx_setvars (0, nlist, vlist))
    fprintf (stderr, "It is impossible to restore the list 0\n");
  else
    {
      printf ("Now in list 0 we have:\n");
      for (i = 0; nlist[i] != NULL; i++)
	{
	  printf ("%s: \t", nlist[i]);
	  c_wrt (1, 6, vlist[i]);
	  putchar ('\n');
	}
    }
  if (!xx_setvars (1, yanl, yavl))
    fprintf (stderr, "It is impossible to restore the list 1\n");
  else
    {
      printf ("Now in list 1 we have:\n");
      for (i = 0; yanl[i] != NULL; i++)
	{
	  printf ("%s: \t", yanl[i]);
	  c_wrt (1, 6, yavl[i]);
	  putchar ('\n');
	}
    }
  printf ("Now we can try to do the same on the lists 2 and 5, but...\n");
  if (!xx_setvars (2, yanl, yavl))
    fprintf (stderr, "It is impossible to  restore the list 2\n");
  else if (xx_is_list_empty (2))
    printf ("Warning: list 2 is empty\n");
  else				/* It should not be executed */
    return -1;
  if (!xx_setvars (5, yanl, yavl))
    fprintf (stderr, "It is impossible to  restore the list 5\n");
  else if (xx_is_list_empty (5))
    printf ("Warning: list 5 is empty\n");
  else				/* It should not be executed */
    return -1;
  printf ("It is not finished here, let us restart !\n");
  if (!xx_setvars (0, yanl, yavl))
    fprintf (stderr, "It is impossible to restore the list 0\n");
  else
    {
      if (xx_readlist (0, &dyn_namelist, &dyn_valuelist) == FAILURE)
	fprintf (stderr, "Cannot scan varlist 0\n");
      else if (dyn_namelist == NULL)
	fprintf (stderr, "Warning: the varlist 0 is empty\n");
      else
	{
	  printf ("The elements of the varlist 0 are:\n");
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    {
	      printf ("Name:\t%s\t Value", dyn_namelist[i]);
	      c_wrt (1, 6, dyn_valuelist[i]);
	      putchar ('\n');
	    }
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    free ((void *) dyn_namelist[i]);
	  free ((void *) dyn_namelist);
	  free ((void *) dyn_valuelist);
	}
    }
  /*                                        */
  /* Now we pass to test xx_rmvar(), xx_rmvars(). */
  /*                                        */
  printf ("We are going to test xx_rmvar() and xx_rmvars()\n");
  if (!xx_rmvar (1, "X"))
    fprintf (stderr, "Cannot remove \"X\" from the varlist 1\n");
  else
    {
      printf ("Removed \"X\" from 1, now  X = \t\t");
      c_wrt (1, 6, xx_getvar (1, "X", &isdef));
      putchar ('\n');
    }
  if (!xx_rmvar (1, "Y"))
    fprintf (stderr, "Cannot remove \"Y\" from the varlist 1\n");
  else
    {
      printf ("Removed \"Y\" from 1, now  Y = \t\t");
      c_wrt (1, 6, xx_getvar (1, "Y", &isdef));
      putchar ('\n');
    }
  if (!xx_rmvar (1, "Z"))
    fprintf (stderr, "Cannot remove \"Z\" from the varlist 1\n");
  else
    {
      printf ("Removed \"Z\" from 1, now  Z = \t\t");
      c_wrt (1, 6, xx_getvar (1, "Z", &isdef));
      putchar ('\n');
    }
  if (!xx_rmvar (1, "X"))
    fprintf (stderr, "Cannot remove \"X\" from the varlist 1\n");
  else
    {
      printf ("Removed newly \"X\" from 1, now  X = \t");
      c_wrt (1, 6, xx_getvar (1, "X", &isdef));
      putchar ('\n');
    }
  if (!xx_rmvar (2, "Y"))
    fprintf (stderr, "Cannot remove \"Y\" from the varlist 2\n");
  else
    {
      printf ("Removed \"Y\" from 2, now  Y = \t\t");
      c_wrt (1, 6, xx_getvar (2, "Y", &isdef));
      putchar ('\n');
    }
  if (!xx_rmvar (5, "Z"))
    fprintf (stderr, "Cannot remove \"Z\" from the varlist 5\n");
  else
    {
      printf ("Removed \"Z\" from 5, now  Z = \t\t");
      c_wrt (1, 6, xx_getvar (5, "Z", &isdef));
      putchar ('\n');
    }
  printf ("Let us continue with the varlist 0 !\n");
  if (!xx_rmvars (0, nlist))
    fprintf (stderr, "Cannot clean the varlist 0\n");
  else
    {
      for (i = 0; nlist[i] != NULL; i++)
	{
	  printf ("Removed \"%s\" from 0, now  %s = \t\t", nlist[i],
		  nlist[i]);
	  c_wrt (1, 6, xx_getvar (0, nlist[i], &isdef));
	  putchar ('\n');
	}
    }
  if (!xx_rmvars (0, nlist))
    fprintf (stderr, "Cannot clean the varlist 0\n");
  else
    {
      for (i = 0; nlist[i] != NULL; i++)
	{
	  printf ("Removed \"%s\" from 0, now  %s = \t\t", nlist[i],
		  nlist[i]);
	  c_wrt (1, 6, xx_getvar (0, nlist[i], &isdef));
	  putchar ('\n');
	}
    }
  if (!xx_rmvars (1, nlist))
    fprintf (stderr, "Cannot clean the varlist 1\n");
  else
    {
      for (i = 0; nlist[i] != NULL; i++)
	{
	  printf ("Removed \"%s\" from 1, now  %s = \t\t", nlist[i],
		  nlist[i]);
	  c_wrt (1, 6, xx_getvar (1, nlist[i], &isdef));
	  putchar ('\n');
	}
      for (i = 0; yanl[i] != NULL; i++)
	{
	  printf ("In varlist 1 %s = \t\t", yanl[i]);
	  c_wrt (1, 6, xx_getvar (1, yanl[i], &isdef));
	  putchar ('\n');
	}
    }
  if (!xx_rmvars (5, nlist))
    fprintf (stderr, "Cannot clean the varlist 5\n");
  else
    {
      for (i = 0; nlist[i] != NULL; i++)
	{
	  printf ("Removed \"%s\" from 5, now  %s = \t\t", nlist[i],
		  nlist[i]);
	  c_wrt (1, 6, xx_getvar (5, nlist[i], &isdef));
	  putchar ('\n');
	}
    }
  xx_rmlistno (1);
  xx_rmlistno (0);
  printf ("All lists have been cleaned.\n");
  printf ("We have always %u lists\n", xx_gettnl ());
  printf ("And we are going to execute some adding operations over\n");
  printf ("some of these.\n");
  printf ("Let us start with the varlist 0 !\n");
  for (i = 0; nlist[i] != NULL; i++)
    {
      if (!xx_addvar (0, nlist[i], c_reset (i, 0)))
	fprintf (stderr, "Cannot add \"%s\" to varlist 0\n", nlist[i]);
      else if (!xx_addvar (0, nlist[i], c_reset (2 * i + 1, 0)))
	fprintf (stderr, "Cannot add \"%s\" to varlist 0\n", nlist[i]);
      else
	printf ("New value of %s = \t", nlist[i]);
      c_wrt (1, 6, xx_getvar (0, nlist[i], &isdef));
      putchar ('\n');
    }
  printf ("Let us continue with the varlist 1 !\n");
  for (i = 0; yanl[i] != NULL; i++)
    {
      if (!xx_addvar (1, yanl[i], c_reset (0, i)))
	fprintf (stderr, "Cannot add \"%s\" to varlist 1\n", yanl[i]);
      else if (!xx_addvar (1, yanl[i], c_reset (0, 2 * i + 1)))
	fprintf (stderr, "Cannot add \"%s\" to varlist 1\n", yanl[i]);
      else
	printf ("New value of %s = \t", yanl[i]);
      c_wrt (1, 6, xx_getvar (1, yanl[i], &isdef));
      putchar ('\n');
    }
  printf ("Now is the turn of the list 5 ( inexistent!!! )\n");
  for (i = 0; yanl[i] != NULL; i++)
    {
      if (!xx_addvar (5, yanl[i], c_reset (0, i)))
	fprintf (stderr, "Cannot add \"%s\" to varlist 5\n", yanl[i]);
      else if (!xx_addvar (5, yanl[i], c_reset (0, 2 * i + 1)))
	fprintf (stderr, "Cannot add \"%s\" to varlist 5\n", yanl[i]);
      else
	printf ("New value of %s = \t", yanl[i]);
      c_wrt (1, 6, xx_getvar (5, yanl[i], &isdef));
      putchar ('\n');
    }
  printf ("Now is the turn of the list 2\n");
  if (!xx_addvars (2, nlist, vlist))
    fprintf (stderr, "Cannot add any variable to the varlist 2\n");
  else
    {
      for (i = 0; nlist[i] != NULL; i++)
	{
	  printf ("New value of %s = \t", nlist[i]);
	  c_wrt (1, 6, xx_getvar (2, nlist[i], &isdef));
	  putchar ('\n');
	}
    }
  if (!xx_addvars (2, yanl, yavl))
    fprintf (stderr, "Cannot add any variable to the varlist 2\n");
  else
    {
      for (i = 0; yanl[i] != NULL; i++)
	{
	  printf ("New value of %s = \t", yanl[i]);
	  c_wrt (1, 6, xx_getvar (2, yanl[i], &isdef));
	  putchar ('\n');
	}
    }
  if (!xx_addvars (5, yanl, yavl))
    fprintf (stderr, "Cannot add any variable to the varlist 5\n");
  else
    {
      for (i = 0; yanl[i] != NULL; i++)
	{
	  printf ("New value of %s = \t", yanl[i]);
	  c_wrt (1, 6, xx_getvar (5, yanl[i], &isdef));
	  putchar ('\n');
	}
    }
  printf ("Test of the routines xx_mergevl() and xx_dupvl()\n");
  if (!xx_mergevl (0, 1))
    fprintf (stderr, "Cannot add the vars of the list 1 to the list 0\n");
  else
    {
      printf ("I have added the variables of the list 1 to the list 0\n");
      if (xx_readlist (0, &dyn_namelist, &dyn_valuelist) == FAILURE)
	fprintf (stderr, "Cannot scan varlist 0\n");
      else if (dyn_namelist == NULL)
	fprintf (stderr, "Warning: the varlist 0 is empty\n");
      else
	{
	  printf ("The elements of the varlist 0 are:\n");
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    {
	      printf ("Name:\t%s\t Value", dyn_namelist[i]);
	      c_wrt (1, 6, dyn_valuelist[i]);
	      putchar ('\n');
	    }
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    free ((void *) dyn_namelist[i]);
	  free ((void *) dyn_namelist);
	  free ((void *) dyn_valuelist);
	}
    }
  if (!xx_mergevl (1, 0))
    fprintf (stderr, "Cannot add the vars of the list 0 to the list 1\n");
  else
    {
      printf ("I have added the variables of the list 0 to the list 1\n");
      if (xx_readlist (1, &dyn_namelist, &dyn_valuelist) == FAILURE)
	fprintf (stderr, "Cannot scan varlist 1\n");
      else if (dyn_namelist == NULL)
	fprintf (stderr, "Warning: the varlist 1 is empty\n");
      else
	{
	  printf ("The elements of the varlist 1 are:\n");
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    {
	      printf ("Name:\t%s\t Value", dyn_namelist[i]);
	      c_wrt (1, 6, dyn_valuelist[i]);
	      putchar ('\n');
	    }
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    free ((void *) dyn_namelist[i]);
	  free ((void *) dyn_namelist);
	  free ((void *) dyn_valuelist);
	}
    }
  if (!xx_mergevl (5, 0))
    fprintf (stderr, "Cannot add the vars of the list 0 to the list 5\n");
  else
    {
      printf ("I have added the variables of the list 0 to the list 5\n");
      if (xx_readlist (5, &dyn_namelist, &dyn_valuelist) == FAILURE)
	fprintf (stderr, "Cannot scan varlist 5\n");
      else if (dyn_namelist == NULL)
	fprintf (stderr, "Warning: the varlist 5 is empty\n");
      else
	{
	  printf ("The elements of the varlist 5 are:\n");
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    {
	      printf ("Name:\t%s\t Value", dyn_namelist[i]);
	      c_wrt (1, 6, dyn_valuelist[i]);
	      putchar ('\n');
	    }
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    free ((void *) dyn_namelist[i]);
	  free ((void *) dyn_namelist);
	}
    }
  if (!xx_dupvl (3, 2))
    fprintf (stderr, "Cannot duplicate list 2 in list 3\n");
  else
    {
      printf ("Duplicated list 2 in list 3\n");
      if (xx_readlist (3, &dyn_namelist, &dyn_valuelist) == FAILURE)
	fprintf (stderr, "Cannot scan varlist 3\n");
      else if (dyn_namelist == NULL)
	fprintf (stderr, "Warning: the varlist 3 is empty\n");
      else
	{
	  printf ("The elements of the varlist 3 are:\n");
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    {
	      printf ("Name:\t%s\t Value", dyn_namelist[i]);
	      c_wrt (1, 6, dyn_valuelist[i]);
	      putchar ('\n');
	    }
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    free ((void *) dyn_namelist[i]);
	  free ((void *) dyn_namelist);
	  free ((void *) dyn_valuelist);
	}
    }
  if (!xx_dupvl (4, 1))
    fprintf (stderr, "Cannot duplicate list 1 in list 4\n");
  else
    {
      printf ("Duplicated list 1 in list 4\n");
      if (xx_readlist (4, &dyn_namelist, &dyn_valuelist) == FAILURE)
	fprintf (stderr, "Cannot scan varlist 4\n");
      else if (dyn_namelist == NULL)
	fprintf (stderr, "Warning: the varlist 4 is empty\n");
      else
	{
	  printf ("The elements of the varlist 4 are:\n");
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    {
	      printf ("Name:\t%s\t Value", dyn_namelist[i]);
	      c_wrt (1, 6, dyn_valuelist[i]);
	      putchar ('\n');
	    }
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    free ((void *) dyn_namelist[i]);
	  free ((void *) dyn_namelist);
	  free ((void *) dyn_valuelist);
	}
    }
  if (!xx_dupvl (3, 3))
    fprintf (stderr, "Cannot duplicate list 3 in list 3\n");
  else
    {
      printf ("Duplicated list 3 in list 3\n");
      if (xx_readlist (3, &dyn_namelist, &dyn_valuelist) == FAILURE)
	fprintf (stderr, "Cannot scan varlist 3\n");
      else if (dyn_namelist == NULL)
	fprintf (stderr, "Warning: the varlist 3 is empty\n");
      else
	{
	  printf ("The elements of the varlist 3 are:\n");
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    {
	      printf ("Name:\t%s\t Value", dyn_namelist[i]);
	      c_wrt (1, 6, dyn_valuelist[i]);
	      putchar ('\n');
	    }
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    free ((void *) dyn_namelist[i]);
	  free ((void *) dyn_namelist);
	}
    }
  if (!xx_dupvl (5, 0))
    fprintf (stderr, "Cannot duplicate list 0 in list 5\n");
  else
    {
      printf ("Duplicated list 0 in list 5\n");
      if (xx_readlist (5, &dyn_namelist, &dyn_valuelist) == FAILURE)
	fprintf (stderr, "Cannot scan varlist 5\n");
      else if (dyn_namelist == NULL)
	fprintf (stderr, "Warning: the varlist 5 is empty\n");
      else
	{
	  printf ("The elements of the varlist 5 are:\n");
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    {
	      printf ("Name:\t%s\t Value", dyn_namelist[i]);
	      c_wrt (1, 6, dyn_valuelist[i]);
	      putchar ('\n');
	    }
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    free ((void *) dyn_namelist[i]);
	  free ((void *) dyn_namelist);
	}
    }
  if (!xx_dupvl (3, 4))
    fprintf (stderr, "Cannot duplicate list 4 in list 3\n");
  else
    {
      printf ("Duplicated list 4 in list 3\n");
      if (xx_readlist (3, &dyn_namelist, &dyn_valuelist) == FAILURE)
	fprintf (stderr, "Cannot scan varlist 3\n");
      else if (dyn_namelist == NULL)
	fprintf (stderr, "Warning: the varlist 3 is empty\n");
      else
	{
	  printf ("The elements of the varlist 3 are:\n");
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    {
	      printf ("Name:\t%s\t Value", dyn_namelist[i]);
	      c_wrt (1, 6, dyn_valuelist[i]);
	      putchar ('\n');
	    }
	  for (i = 0; dyn_namelist[i] != NULL; i++)
	    free ((void *) dyn_namelist[i]);
	  free ((void *) dyn_namelist);
	  free ((void *) dyn_valuelist);
	}
    }
  xx_rmlists ();
  return 0;
}
