#!/bin/bash
#
#  This file is part of the XXCalc library
#  Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
#                 2011, 2012, 2013  Ivano Primi  <ivprimi@libero.it>    
#
#  XXCalc is free software; see the source and the file
#  LICENSE for copying conditions.
#  There is NO warranty; not even for MERCHANTABILITY or FITNESS 
#  FOR A PARTICULAR PURPOSE.
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

if [ $# -gt 1 ]; then
    echo "Usage: $0 [COMPILER_NAME]"
    echo ""
    echo "When COMPILER_NAME is not specified, gcc is used"
    exit 1
elif [ $# -eq 1 ]; then
    CC=$1
else
    CC=gcc
fi

which $CC > /dev/null
if [ $? != 0 ]; then
    echo "The compiler $CC has not been found."
    echo "Maybe you have to update the environment variable PATH."
    if [ $# -eq 0 ]; then
	echo "Alternatively, you can explicitely order to use"
	echo "a specific compiler by calling this script in the following way:"
	echo "      $0 COMPILER"	
    fi
    echo "Building process aborted."
    exit 1
fi

which xxcconf > /dev/null
if [ $? != 0 ]; then
    echo "The program xxcconf has not been found."
    echo "Maybe you have to update the environment variable PATH."
    echo "Building process aborted."
    exit 1
fi

for source in ./*.c ; do
    $CC -c -g -Wall $(xxcconf -c) $source
done

for obj in ./*.o ; do
    $CC $obj $(xxcconf -l) -o ${obj%\.o}
done

echo "Building process done."
rm ./*.o
echo "Removed all the object files from the current directory"
exit 0
