/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<stdio.h>   /* for sprintf() */
#include<string.h>
#include"ioctype.h"
#include"varlist.h"
#include"mathtok.h" /* for XX_MAX_VNSIZE */
#include"utils.h"
#include"parser.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif

/* This function returns the first significant character     */
/* of S before the position POS, or '\0' if POS==0 or every  */
/* character before POS is a space (' ', '\t' or '\n').      */
/* It assumes 0 <= POS <= strlen(S) and POS <= LONG_MAX.     */
static char
fschbp (const char *s, str_s_ize pos)
{
  long i;

  for (i = (long) pos - 1; i >= 0 && xx_isspace (s[i]) != 0; i--);
  return (i < 0 ? '\0' : s[i]);
}


/* This function returns the first significant character of  */
/* S after the position POS, or '\0' if POS>= strlen(S)-1 or */
/* every character after POS is a space (' ', '\t' or '\n'). */
/* It assumes that 0 <= POS <= strlen(S).                    */
static char
fschap (const char *s, str_s_ize pos)
{
  str_s_ize i;

  if (s[pos] == '\0')
    return '\0';
  else				/* 0 <= pos <= strlen(s)-1 */
    {
      for (i = pos + 1; xx_isspace (s[i]) != 0; i++);
      return s[i];
    }
}

/* Check for the presence, inside expr, of regular expressions having the     */
/* form  "\[[ \n\t]*varname[ \n\t]*\]", where varname is a valid varname,i.e. */
/* a sequence formed by uppercase letters, digits and the character '_'       */
/* which starts with an uppercase letter and has a length <= XX_MAX_VNSIZE-1  */
/* (see mathtok.h for the value of the macro XX_MAX_VNSIZE). Check for the    */
/* correct use of these regular expressions and return an error code != 0     */
/* if you find any syntax error.                                              */

int
xx_chkind (char* expr)
{
  b_yte opb = 0;
  i_nteger i, j, k;
  char* endp;

  for (i=0; expr[i] != '\0'; i++)
    {
      if (expr[i] == ']')
	{
	  if (!opb)
	    return XX_MISSOSQP;
	  else
	    opb = 0;
	}
      if (expr[i] =='[')
	{
	  opb = 1;
	  for(j = i-1; j>=0 && io_isdigit(expr[j])!=0; j--);
	  if( j < 0 )
	    return XX_WRONGPOSSQP;
	  else if(expr[j]!=']' && expr[j]!='_' && !io_isalpha(expr[j]))
	    return XX_WRONGPOSSQP;
	  else
	    {
	      for(j=i+1; xx_isspace(expr[j])!=0; j++);
	      for(k = j; expr[k]!='\0'; k++)
		expr[k-j+i+1] = expr[k];
	      expr[k-j+i+1] = '\0';
	      /* We have removed the spaces between [ and the first */
	      /* significant character after it.                    */
	      if( (io_isalpha(expr[i+1])) )
		{
		  xx_str2id (expr+i+1, &endp);
		  if (endp - expr - i > XX_MAX_VNSIZE)
		    return XX_VNAME2LONG;
		  else
		    i = endp - expr; /* This is the position of the first */
		    /* character after the varname.                       */
		  for(; xx_isspace(*endp)!=0; endp++);
		  if(*endp != ']')
		    return XX_MISSCSQP;
		  else
		    j = endp - expr; /* This is the position of ] */
		  for(k = j; expr[k]!='\0'; k++)
		    expr[k-j+i] = expr[k];
		  expr[k-j+i] = '\0';
		  /* We have removed all the spaces between the last character
		     of the varname and the character ].                  */
		}
	      else
		return XX_INVINDEX;
	    }
	} /* end if(expr[i] =='[') */
    } /* end for(...) */
  return XX_OK;
}


/* The following function performs these operations:   */
/* [1] - If the '-' sign is found at the start of S,   */
/*       or after a binary operator, or after an open  */
/*       parenthesis the function will replace it with */
/*       a '~'.                                        */
/* [2] - If the '+' sign is found at the start of S,   */
/*       or after a binary operator, or after an open  */
/*       parenthesis the function will replace it with */
/*       a ' '.                                        */

/* 
   If an error occurs during its execution the function
   returns the corresponding errcode, otherwise XX_OK (0).  
*/
int
xx_preprocessor (char *s)
{
  str_s_ize i, ls;
  char ch;
  int errcode;

  ls = strlen (s);
  if (ls > XX_MAX_EXLEN)
    return XX_EXPR2LONG;
  for (i = 0; i < ls; i++)	/* Look for unary + and - */
    {
      if ((s[i] == '-') || (s[i] == '+'))
	{
	  ch = fschbp (s, i);
	  if ((ch == '\0') || (ch == '(') || xx_maybeinop (ch))	/* * */
	    {
	      /* The following one is the unique check on */
	      /* the syntax done by the preprocessor.     */
	      ch = fschap (s, i);
	      if ((ch == '\0'))
		return XX_BADTOKATEND;
	      else if ((ch == ')') || xx_maybeinop (ch))
		return XX_MISSVALUE;
	      else		/* The unary + is superfluous. */
		s[i] = (s[i] == '-') ? '~' : ' ';
	    }
	}
    }
  if( (errcode = xx_chkind (s)) != XX_OK )
    return errcode;
  else
    return XX_OK;
}
