/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _PARSER_H_
#define _PARSER_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Some useful constants */

/* XX_MAX_EXLEN := highest acceptable value for the length of a math */
/*                 expression.                                       */
#define XX_MAX_EXLEN   2000

/* XX_MAX_PAR_LEVEL+1 == available levels of parenthesis  */
#define XX_MAX_PAR_LEVEL 99
/* number of functions and operators that may appear in */
/* a single level of parenthesis. It cannot be greater  */
/* than XX_LOG_PR - 1 (see below).                      */
#define XX_OFN4LP       999

/* Priority-jump for every level of parenthesis. */
#define XX_PR_SKIP    10000
/* Priority-jump for functions.                  */
#define XX_FUNC_PR     8000
/* Priority-jump for the unary - (~).            */
#define XX_MIN_PR      7000
/* Priority-jump for minimum and maximum         */
#define XX_MINMAX_PR   6000
/* Priority-jump for ^.                          */
#define XX_POW_PR      5000
/* Priority-jump for *, /, %, &, \.              */
#define XX_PROD_PR     4000
/* Priority-jump for +, -.                       */
#define XX_SUM_PR      3000
/* Priority-jump for <, >, <=, >=, ==, !=.       */
#define XX_CMP_PR      2000
/* Priority-jump for &&, ||, ^^.                 */
#define XX_LOG_PR      1000


/* Error codes */
#define XX_OK             0
#define XX_EMPTYEXPR      1	
#define XX_ILLCHAR        2	
#define XX_EXPR2LONG      3	
#define XX_VNAME2LONG     4	
#define XX_TOKEN2LONG     5     
#define XX_INVNUM         6	
#define XX_OVER_FLOW      7	
#define XX_MISSCP         8	
#define XX_TOOCP          9	
#define XX_OVERMLP       10	
#define XX_INEXOP        11	
#define XX_ILLCALL2FUNC  12	
#define XX_INEXFUNC      13	
#define XX_DIVBYZERO     14	
#define XX_OUTOFDOMAIN   15	
#define XX_BADEXPONENT   16	
#define XX_BADTOKATSTART 17	
#define XX_BADTOKATEND   18	
#define XX_FUNCWOOPAR    19	
#define XX_MISSVALUE     20	
#define XX_MISSOPER      21	
#define XX_MISSOSQP      22     
#define XX_MISSCSQP      23     
#define XX_WRONGPOSSQP   24     
#define XX_INVINDEX      25     
#define XX_INVINDEXVALUE 26      
#define XX_UNRECTOK      27	
#define XX_OVERLOAD      28	
#define XX_UNDEFVAR      29     
#define XX_INVALID_REF_TO_STACK 30  
#define XX_INVALID_REF_TO_VLIST 31  
				    
#define XX_SELECTED_VLIST_FULL  32  
                                         
#define XX_FAILED_ASSIGNMENT    33  
#define XX_FATAL_ERROR  100

void xx_allow_implicit_multiplication (void);
void xx_forbid_implicit_multiplication (void);

#ifdef __cplusplus
}
#endif
#endif /* _PARSER_H_ */
