/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _NUMTYPES_H_
#define _NUMTYPES_H_

#include<stddef.h>
#include<float.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef USE_LONG_DOUBLE
#define MATH_PI 3.1415926535897932384626433832795029L
#define MATH_E  2.7182818284590452353602874713526625L
typedef long double r_eal;
typedef long long i_nteger;
typedef unsigned long long ui_nteger;
#define R_EAL_MAX  LDBL_MAX
#define R_EAL_MIN  LDBL_MIN
#define R_MAX_PREC LDBL_DIG
#else
#define MATH_PI 3.14159265358979323846
#define MATH_E  2.71828182845904523536
typedef double r_eal;
typedef long i_nteger;
typedef unsigned long ui_nteger;
#define R_EAL_MAX  DBL_MAX
#define R_EAL_MIN  DBL_MIN
#define R_MAX_PREC DBL_DIG
#endif

typedef signed char  sb_yte;
typedef unsigned char b_yte;
typedef size_t str_s_ize;

#ifdef __cplusplus
}
#endif

#endif /* _NUMTYPES_H_*/
