/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<string.h>
#include"mathtok.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif

/* 
   If you update one of the lists below, mind to check for
   the correctness of the value of XX_MAX_NUMCHARS (see below)
*/

static const char *operators[] = {
  "+",
  "-",
  "*",
  "/",
  "%",
  "$",
  "\\",
  "^",
  "<",
  ">",
  "<=",
  ">=",
  "==",
  "!=",
  "&&",
  "||",
  "^^",
  "><",
  "<>"
};

static const char *functions[] = {
  "re",
  "im",
  "abs",
  "arg",
  "neg",
  "conj",
  "inv",
  "swap",
  "sqr",
  "sqrt",
  "cbrt",
  "exp",
  "expx",
  "log",
  "logx",
  "sin",
  "cos",
  "tan",
  "asin",
  "acos",
  "atan",
  "sinh",
  "cosh",
  "tanh",
  "asinh",
  "acosh",
  "atanh",
  "floor",
  "ceil",
  "round",
  "fix",
  "frac",
  "Xcc",
  "Xco",
  "Xoc",
  "Xoo",
  "Xlc",
  "Xlo",
  "Xrc",
  "Xro",
  "step",
  "erf",
  "erfc",
  "dms",
  "deg",
  "rtod",
  "dtor",
  "fact"
};

/* Modified on Oct 31, 2003 to avoid too calls to malloc() */
/* within parser.c                                         */

#define XX_MAX_NUMCHARS 5

b_yte
xx_toktype (const char *name, str_s_ize length)
{
  b_yte i;
  char tmpbuff[XX_MAX_NUMCHARS + 1];

  if ( length > XX_MAX_NUMCHARS || length == 0 )
    return XX_UNDEFINED;
  else
    {
      strncpy (tmpbuff, name, length);
      tmpbuff[length] = '\0';
    }
  for (i = 0; i < XX_OPNUM; i++)
    if (strcmp (tmpbuff, operators[i]) == 0)
      return i + XX_OPERATOR;
  for (i = 0; i < XX_FUNCNUM; i++)
    if (strcmp (tmpbuff, functions[i]) == 0)
      return i + XX_FUNCTION;
  return XX_UNDEFINED;
}
