/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include"ioctype.h"

int io_islower (int ch)
{
#if !(CONSEC_LOWER_LETTERS)
  switch (ch)
    {
    case 'a': case 'b': case 'c': case 'd': case 'e':
    case 'f': case 'g': case 'h': case 'i': case 'j':
    case 'k': case 'l': case 'm': case 'n': case 'o':
    case 'p': case 'q': case 'r': case 's': case 't':
    case 'u': case 'v': case 'w': case 'x': case 'y':
    case 'z':
      return 1;
    default:
      return 0;
    }
#else
  return (ch >= 'a' && ch <= 'z');
#endif
}

int io_isupper (int ch)
{
#if !(CONSEC_UPPER_LETTERS)
  switch (ch)
    {
    case 'A': case 'B': case 'C': case 'D': case 'E':
    case 'F': case 'G': case 'H': case 'I': case 'J':
    case 'K': case 'L': case 'M': case 'N': case 'O':
    case 'P': case 'Q': case 'R': case 'S': case 'T':
    case 'U': case 'V': case 'W': case 'X': case 'Y':
    case 'Z':
      return 1;
    default:
      return 0;
    }
#else
  return (ch >= 'A' && ch <= 'Z');
#endif
}

int io_isdigit (int ch)
{
#if !(CONSEC_DIGITS)
  switch (ch)
    {
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      return 1;
    default:
      return 0;
    }
#else
  return (ch >= '0' && ch <= '9');
#endif
}

int io_isxdigit(int ch)
{
#if (CONSEC_LOWER_LETTERS) && (CONSEC_UPPER_LETTERS)\
&&  (CONSEC_DIGITS)
  return ( (ch >= '0' && ch <= '9') || (ch >= 'A' && ch <= 'F') || (ch >= 'a' && ch <= 'f') );
#else
  switch (ch)
    {
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
    case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
    case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
      return 1;
    default:
      return 0;
    }
#endif
}

int io_isalpha (int ch)
{
#if (CONSEC_LOWER_LETTERS) && (CONSEC_UPPER_LETTERS)
  return ( (ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z') );
#else
  switch (ch)
    {
    case 'a': case 'b': case 'c': case 'd': case 'e':
    case 'f': case 'g': case 'h': case 'i': case 'j':
    case 'k': case 'l': case 'm': case 'n': case 'o':
    case 'p': case 'q': case 'r': case 's': case 't':
    case 'u': case 'v': case 'w': case 'x': case 'y':
    case 'z':
    case 'A': case 'B': case 'C': case 'D': case 'E':
    case 'F': case 'G': case 'H': case 'I': case 'J':
    case 'K': case 'L': case 'M': case 'N': case 'O':
    case 'P': case 'Q': case 'R': case 'S': case 'T':
    case 'U': case 'V': case 'W': case 'X': case 'Y':
    case 'Z':
      return 1;
    default:
      return 0;
    }
#endif 
}

int io_isalnum (int ch)
{
#if (CONSEC_LOWER_LETTERS) && (CONSEC_UPPER_LETTERS) && (CONSEC_DIGITS)
  return ( (ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z') || (ch >= '0' && ch <= '9') );
#else
  switch (ch)
    {
    case 'a': case 'b': case 'c': case 'd': case 'e':
    case 'f': case 'g': case 'h': case 'i': case 'j':
    case 'k': case 'l': case 'm': case 'n': case 'o':
    case 'p': case 'q': case 'r': case 's': case 't':
    case 'u': case 'v': case 'w': case 'x': case 'y':
    case 'z':
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
    case 'A': case 'B': case 'C': case 'D': case 'E':
    case 'F': case 'G': case 'H': case 'I': case 'J':
    case 'K': case 'L': case 'M': case 'N': case 'O':
    case 'P': case 'Q': case 'R': case 'S': case 'T':
    case 'U': case 'V': case 'W': case 'X': case 'Y':
    case 'Z':
      return 1;
    default:
      return 0;
    }
#endif 
}


/*
  In the POSIX and C locales the spaces are given by
  ' ', '\t', '\n', '\r', '\f' and '\v' .
*/

int io_isspace (int ch)
{
  return ( ch == ' '  || ch == '\t' || ch == '\n' ||
	   ch == '\r' || ch == '\f' || ch == '\v' ); 
}


/*
  A blank is either a space (' ') or an
  horizontal tabulator ('\t').
*/

int io_isblank (int ch)
{
  return ( ch == ' ' || ch == '\t' );
}


/*
  In the ASCII character set the printable characters are all
  the characters from ' ' to '~'.
*/

int io_isprint (int ch)
{
#if !(CHARSET_IS_ASCII)
  switch (ch)
    {
    case ' ': case '!': case '"': case '#':
    case '$': case '%': case '&': case '\'':
    case '(': case ')': case '*': case '+':
    case ',': case '-': case '.': case '/':
    case '0': case '1': case '2': case '3':
    case '4': case '5': case '6': case '7':
    case '8': case '9': case ':': case ';':
    case '<': case '=': case '>': case '?':
    case '@': case 'A': case 'B': case 'C':
    case 'D': case 'E': case 'F': case 'G':
    case 'H': case 'I': case 'J': case 'K':
    case 'L': case 'M': case 'N': case 'O':
    case 'P': case 'Q': case 'R': case 'S':
    case 'T': case 'U': case 'V': case 'W':
    case 'X': case 'Y': case 'Z': case '[':
    case '\\': case ']': case '^': case '_':
    case '`': case 'a': case 'b': case 'c':
    case 'd': case 'e': case 'f': case 'g':
    case 'h': case 'i': case 'j': case 'k':
    case 'l': case 'm': case 'n': case 'o':
    case 'p': case 'q': case 'r': case 's':
    case 't': case 'u': case 'v': case 'w':
    case 'x': case 'y': case 'z': case '{':
    case '|': case '}': case '~':
      return 1;
    default:
      return 0;
    }
#else
  return ( ch >= ' ' && ch <= '~' );
#endif
}


/*
  In the ASCII character set the graphic characters are all
  the characters from '!' to '~'.
*/

int io_isgraph (int ch)
{
#if !(CHARSET_IS_ASCII)
  switch (ch)
    {
    case '!': case '"': case '#':
    case '$': case '%': case '&': case '\'':
    case '(': case ')': case '*': case '+':
    case ',': case '-': case '.': case '/':
    case '0': case '1': case '2': case '3':
    case '4': case '5': case '6': case '7':
    case '8': case '9': case ':': case ';':
    case '<': case '=': case '>': case '?':
    case '@': case 'A': case 'B': case 'C':
    case 'D': case 'E': case 'F': case 'G':
    case 'H': case 'I': case 'J': case 'K':
    case 'L': case 'M': case 'N': case 'O':
    case 'P': case 'Q': case 'R': case 'S':
    case 'T': case 'U': case 'V': case 'W':
    case 'X': case 'Y': case 'Z': case '[':
    case '\\': case ']': case '^': case '_':
    case '`': case 'a': case 'b': case 'c':
    case 'd': case 'e': case 'f': case 'g':
    case 'h': case 'i': case 'j': case 'k':
    case 'l': case 'm': case 'n': case 'o':
    case 'p': case 'q': case 'r': case 's':
    case 't': case 'u': case 'v': case 'w':
    case 'x': case 'y': case 'z': case '{':
    case '|': case '}': case '~':
      return 1;
    default:
      return 0;
    }
#else
  return ( ch >= '!' && ch <= '~' );
#endif
}


/* 
   io_iscntrl(ch) == !(io_isprint(ch))
*/

int io_iscntrl (int ch)
{
#if !(CHARSET_IS_ASCII)
  switch (ch)
    {
    case ' ': case '!': case '"': case '#':
    case '$': case '%': case '&': case '\'':
    case '(': case ')': case '*': case '+':
    case ',': case '-': case '.': case '/':
    case '0': case '1': case '2': case '3':
    case '4': case '5': case '6': case '7':
    case '8': case '9': case ':': case ';':
    case '<': case '=': case '>': case '?':
    case '@': case 'A': case 'B': case 'C':
    case 'D': case 'E': case 'F': case 'G':
    case 'H': case 'I': case 'J': case 'K':
    case 'L': case 'M': case 'N': case 'O':
    case 'P': case 'Q': case 'R': case 'S':
    case 'T': case 'U': case 'V': case 'W':
    case 'X': case 'Y': case 'Z': case '[':
    case '\\': case ']': case '^': case '_':
    case '`': case 'a': case 'b': case 'c':
    case 'd': case 'e': case 'f': case 'g':
    case 'h': case 'i': case 'j': case 'k':
    case 'l': case 'm': case 'n': case 'o':
    case 'p': case 'q': case 'r': case 's':
    case 't': case 'u': case 'v': case 'w':
    case 'x': case 'y': case 'z': case '{':
    case '|': case '}': case '~':
      return 0;
    default:
      return 1;
    }
#else
  return ( ch < 32 || ch == 127 );
#endif
}


/*
  In the ASCII character set the punctuation marks are all
  the characters from '!' to '~' which are not digits
  nor letters.
*/

int io_ispunct (int ch)
{
#if !(CHARSET_IS_ASCII)
  switch (ch)
    {
    case '!': case '"': case '#': case '$': case '%': 
    case '&': case '\'': case '(': case ')': case '*': 
    case '+': case ',': case '-': case '.': case '/':
    case ':': case ';': case '<': case '=': case '>':
    case '?': case '@': case '[': case '\\': case ']': 
    case '^': case '_': case '`': case '{':
    case '|': case '}': case '~':
      return 1;
    default:
      return 0;
    }
#else
  return (  (ch >= '!' && ch <= '~') && !(ch >= 'a' && ch <= 'z') && 
	   !(ch >= '0' && ch <= '9') && !(ch >= 'A' && ch <= 'Z') );
#endif
}

int io_tolower (int ch)
{
#if !(CONSEC_UPPER_LETTERS)
  switch (ch)
    {
    case 'A': return 'a';
    case 'B': return 'b';
    case 'C': return 'c';
    case 'D': return 'd';
    case 'E': return 'e';
    case 'F': return 'f';
    case 'G': return 'g';
    case 'H': return 'h';
    case 'I': return 'i';
    case 'J': return 'j';
    case 'K': return 'k';
    case 'L': return 'l';
    case 'M': return 'm';
    case 'N': return 'n';
    case 'O': return 'o';
    case 'P': return 'p';
    case 'Q': return 'q';
    case 'R': return 'r';
    case 'S': return 's';
    case 'T': return 't';
    case 'U': return 'u';
    case 'V': return 'v';
    case 'W': return 'w';
    case 'X': return 'x';
    case 'Y': return 'y';
    case 'Z': return 'z';
    default:
      return ch;
    }
#else
  return ( (ch >= 'A' && ch <= 'Z') ? ch - 'A' + 'a' : ch);
#endif
}

int io_toupper (int ch)
{
#if !(CONSEC_LOWER_LETTERS)
  switch (ch)
    {
    case 'a': return 'A';
    case 'b': return 'B';
    case 'c': return 'C';
    case 'd': return 'D';
    case 'e': return 'E';
    case 'f': return 'F';
    case 'g': return 'G';
    case 'h': return 'H';
    case 'i': return 'I';
    case 'j': return 'J';
    case 'k': return 'K';
    case 'l': return 'L';
    case 'm': return 'M';
    case 'n': return 'N';
    case 'o': return 'O';
    case 'p': return 'P';
    case 'q': return 'Q';
    case 'r': return 'R';
    case 's': return 'S';
    case 't': return 'T';
    case 'u': return 'U';
    case 'v': return 'V';
    case 'w': return 'W';
    case 'x': return 'X';
    case 'y': return 'Y';
    case 'z': return 'Z';
    default:
      return ch;
    }
#else
  return ( (ch >= 'a' && ch <= 'z') ? ch - 'a' + 'A' : ch);
#endif
}
