/*
   This file is part of the XXCalc Library - version 3.2
   Copyright (C)  2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
   2011, 2012, 2013    Ivano Primi ( ivprimi@libero.it )    

   The XXCalc Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The XXCalc library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include<stdio.h> /* for sprintf() */
#include<stdlib.h>
#include<string.h>
#include"parser.h"
#include"mathtok.h"
#include"utils.h"
#include"expander.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif

#define MAX_INDEX_AGREABLE 1000000000U
#define NDMIA 10 /* Number of digits of the highest allowable index */

/* Replace every occurence of "[name]" inside 'str' with the string pointed by */
/* 'number'. Assume that 'str' is long enough. Return a value != XX_OK in case */
/* of error.                                                                   */
static int
replace (char* str, const char* name, const char* number)
{
  char *sz, *psz, *tail;
  str_s_ize i, j, l = strlen (name);

  sz = (char*)malloc ((l+3)*sizeof(char));
  if (!sz)
    return XX_FATAL_ERROR;
  else
    {
      sz[0] = '[';
      strcpy (sz+1, name);
      sz[l+1] = ']';
      sz[l+2] = '\0';
    }
  /* Now sz == "[name]" */
  tail = (char*)malloc ((strlen(str)+1)*sizeof(char));
  if(!tail)
    {
      free ((void*)sz);
      return XX_FATAL_ERROR;
    }
  while ( (psz = strstr (str, sz)) )
    {
      strcpy (tail, psz + l + 2); /* I have copied inside 'tail' the characters
				      of 'str' after the ']'                  */
      i = psz-str; /* This is the position of '[' */
      for (j = i; number[j-i] != '\0'; str[j] = number[j-i], j++);
      strcpy (str+j, tail);
    }
  free ((void*)tail);
  free ((void*)sz);
  return XX_OK;
}

char*
xx_expander (const char* s, xx_varlist vl, int *errcode)
{
  static char name[XX_MAX_VNSIZE]; /* This is the returned string */
  str_s_ize l, ls = strlen (s);
  ui_nteger n;
  char *str, *sz, *endp, number[NDMIA+1];
  c_omplex z;
  int yesno;

  for (n=0, l=0; n<ls; n++) /* Find the number of the indexes */
    if( s[n]=='[' )
      l++;
  l = l * NDMIA + ls;
  str = (char*) malloc ((l+1)*sizeof(char));
  /* Ok, I am not very optimistic !! */
  if(!str)
    {
      *errcode = XX_FATAL_ERROR;
      return NULL;
    }
  else
    strcpy(str, s);
  while( (sz = strchr (str, '[')) )
    {
      xx_str2id (sz+1, &endp);
      /* We assume that the error XX_VNAME2LONG cannot occurs 
	 (see the related code inside xx_chkind()). */
      strncpy (name, sz+1, endp - sz -1);
      name[endp - sz -1] = '\0';
      /* Now we know the name of the variable */
      z = xx_vl_get (vl, name, &yesno);
#ifdef BE_STRICT
      if(!yesno)
	{
	  free ((void*)str);
	  *errcode = XX_UNDEFVAR;
	  return NULL;
	}
#endif
      n = xx_c2ui (z, &yesno);
      if( yesno == 0  ||  n > MAX_INDEX_AGREABLE )
	{
	  free ((void*)str);
	  *errcode = XX_INVINDEXVALUE;
	  return NULL;
	}
      else
	{
#ifdef USE_LONG_DOUBLE
	  sprintf (number, "%llu", n);
#else
          sprintf (number, "%lu", n);
#endif
	  /* Do not worry, number is long enough ! */
	  replace (str, name, number);
	}
    } /* End while */
  if( strlen(str) > XX_MAX_VNSIZE - 1 )
    {
      free ((void*)str);
      *errcode = XX_VNAME2LONG;
      return NULL;
    }
  else
    {
      strcpy (name, str);
      free ((void*)str);
      *errcode = XX_OK;
      return name;
    }
}
